/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds.i18n;

import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.i18n.MethodCallerConverter;
import com.gmail.dpierron.calibre.opds.i18n.Object2StringConverter;
import com.gmail.dpierron.tools.Helper;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LocalizationHelper {
    INSTANCE;

    private static final Object2StringConverter CONVERTER;

    public Vector<String> getAvailableLocalizations() {
        return Localization.Main.getAvailableLocalizations();
    }

    public String getEnumConstantHumanName(Enum enumConstant) {
        return this.getEnumConstantHumanName(enumConstant, false);
    }

    public String getEnumConstantHumanName(Enum enumConstant, boolean secondary) {
        String label = this.uncheckedGetEnumConstantHumanName(enumConstant, secondary);
        if (label == null) {
            label = enumConstant.toString();
        }
        return label;
    }

    public String uncheckedGetEnumConstantHumanName(Enum enumConstant) {
        return this.uncheckedGetEnumConstantHumanName(enumConstant, false);
    }

    public String uncheckedGetEnumConstantHumanName(Enum enumConstant, boolean secondary) {
        String name;
        if (enumConstant == null) {
            return null;
        }
        String label = null;
        if (!secondary) {
            label = CONVERTER.getStringValueOrNull(enumConstant);
        }
        if (Helper.isNullOrEmpty(label) && (label = Localization.Enum.getText(name = "enum." + enumConstant.getDeclaringClass().getCanonicalName() + "." + (secondary ? "secondary." : "") + enumConstant.name())).equals(name)) {
            label = null;
        }
        return label;
    }

    public String getYesOrNo(Boolean b) {
        if (b == null) {
            return "";
        }
        if (b.booleanValue()) {
            return Localization.Main.getText("boolean.yes");
        }
        return Localization.Main.getText("boolean.no");
    }

    static {
        CONVERTER = new MethodCallerConverter("getHumanName");
    }
}

