/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds.i18n;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.tools.Helper;
import com.gmail.dpierron.tools.Utf8ResourceBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Localization {
    Enum("Enumerations"),
    Main("Localization");

    Logger logger = Logger.getLogger(Localization.class);
    private boolean initialized = false;
    private String localizationBundleName;
    private ResourceBundle localizations;

    public ResourceBundle getBundle() {
        if (this.localizations == null) {
            this.reloadLocalizations();
        }
        return this.localizations;
    }

    private Localization(String localizationBundleName) {
        this.localizationBundleName = localizationBundleName;
        this.reloadLocalizations();
    }

    public Vector<String> getAvailableLocalizations() {
        Vector<String> result = new Vector<String>();
        for (String lang : Locale.getISOLanguages()) {
            Locale locale = new Locale(lang);
            ResourceBundle bundle = this.getResourceBundle(this.localizationBundleName, locale, false);
            if (bundle == null || !bundle.getLocale().getLanguage().equalsIgnoreCase(lang)) continue;
            result.add(locale.getLanguage());
        }
        return result;
    }

    private ResourceBundle getResourceBundle(String name) {
        return this.getResourceBundle(name, null);
    }

    private ResourceBundle getResourceBundle(String name, Locale locale, boolean englishIfNull) {
        ResourceBundle result = null;
        try {
            result = locale != null ? Utf8ResourceBundle.getBundle((String)name, (Locale)locale) : Utf8ResourceBundle.getBundle((String)name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null && englishIfNull) {
            return this.getResourceBundle(name, Locale.ENGLISH);
        }
        return result;
    }

    private ResourceBundle getResourceBundle(String name, Locale locale) {
        return this.getResourceBundle(name, locale, true);
    }

    public void reloadLocalizations() {
        this.localizations = Helper.isNullOrEmpty((Object)StanzaConfiguration.INSTANCE.getLanguage()) ? this.getResourceBundle(this.localizationBundleName) : this.getResourceBundle(this.localizationBundleName, new Locale(StanzaConfiguration.INSTANCE.getLanguage()));
        this.initialized = true;
    }

    private String lookupText(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getText(String key) {
        String message = this.lookupText(key);
        return message;
    }

    public String getText(String key, Object ... parameters) {
        String message = this.lookupText(key);
        if (message == null) {
            return null;
        }
        String formattedMessage = MessageFormat.format(message, parameters);
        return formattedMessage;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

