/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.opds.CatalogContext;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.thumbnails.CreateThumbnail;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ThumbnailManager {
    private static final String THUMBNAIL_HEIGHT_DAT = "thumbnailHeight.dat";
    private static final Logger logger = Logger.getLogger(ThumbnailManager.class);
    private boolean thumbnailSizeChanged = false;
    private Map<File, File> thumbnailsToGenerate = new HashMap<File, File>();
    private long timeInThumbnails = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThumbnailManager() {
        File thumbnailSizeFile = new File(StanzaConfiguration.INSTANCE.getDatabaseFolder(), THUMBNAIL_HEIGHT_DAT);
        if (!thumbnailSizeFile.exists()) {
            this.thumbnailSizeChanged = true;
        } else {
            try {
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(new FileInputStream(thumbnailSizeFile));
                    int oldSize = ois.readInt();
                    this.thumbnailSizeChanged = oldSize != StanzaConfiguration.INSTANCE.getThumbnailHeight();
                }
                finally {
                    if (ois != null) {
                        ois.close();
                    }
                }
            }
            catch (Exception e) {
                logger.warn("cannot read the file " + thumbnailSizeFile.getAbsolutePath());
                this.thumbnailSizeChanged = true;
            }
        }
    }

    public void setThumbnailToGenerate(File thumbnailFile, File coverFile) {
        if (!this.thumbnailsToGenerate.containsKey(thumbnailFile)) {
            this.thumbnailsToGenerate.put(thumbnailFile, coverFile);
        }
    }

    String getThumbnailFilename(Book book) {
        EBookFile file = book.getPreferredFile();
        if (file != null) {
            return book.getPreferredFile().getName() + ".jpg";
        }
        return "thumbnail.jpg";
    }

    String getThumbnailUri(Book book) {
        return "../../" + FeedHelper.INSTANCE.urlEncode(book.getPath(), true) + "/" + FeedHelper.INSTANCE.urlEncode(this.getThumbnailFilename(book), true);
    }

    boolean hasThumbnailSizeChanged() {
        return this.thumbnailSizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeThumbnailHeightFile() {
        File thumbnailSizeFile = new File(StanzaConfiguration.INSTANCE.getDatabaseFolder(), THUMBNAIL_HEIGHT_DAT);
        try {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(thumbnailSizeFile));
                oos.writeInt(StanzaConfiguration.INSTANCE.getThumbnailHeight());
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("cannot write the file " + thumbnailSizeFile.getAbsolutePath());
        }
    }

    public void generateThumbnails() {
        for (File thumbnailFile : this.thumbnailsToGenerate.keySet()) {
            File coverFile = this.thumbnailsToGenerate.get(thumbnailFile);
            long now = System.currentTimeMillis();
            try {
                CreateThumbnail ct = new CreateThumbnail(coverFile.getAbsolutePath());
                ct.getThumbnail(StanzaConfiguration.INSTANCE.getThumbnailHeight(), 0);
                ct.saveThumbnail(thumbnailFile, "jpeg");
            }
            catch (Exception e) {
                CatalogContext.INSTANCE.getCallback().errorOccured(Localization.Main.getText("error.generatingThumbnail", coverFile.getAbsolutePath()), e);
            }
            this.timeInThumbnails += System.currentTimeMillis() - now;
        }
        this.writeThumbnailHeightFile();
    }
}

