/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.TagSubCatalog;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import com.gmail.dpierron.tools.RootTreeNode;
import com.gmail.dpierron.tools.TreeNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagTreeSubCatalog
extends TagSubCatalog {
    public TagTreeSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public TagTreeSubCatalog(List<Book> books) {
        super(books);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getLevelOfTreeNode(Breadcrumbs pBreadcrumbs, TreeNode level, int from) throws IOException {
        Element entry;
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        int itemsCount = level.getChildren().size();
        String filename = pBreadcrumbs.getFilename() + "_tags" + level.getGuid();
        if (from > 0) {
            filename = filename + "_" + pageNumber;
        }
        filename = filename + ".xml";
        filename = SecureFileManager.INSTANCE.encode(filename);
        boolean onRoot = level.isRoot();
        String title = onRoot ? Localization.Main.getText("tags.title") : level.getId();
        String urn = "calibre:tags:" + level.getGuid();
        String summary = "";
        if (onRoot) {
            List<Tag> tags = this.getTags();
            if (tags.size() > 1) {
                summary = Localization.Main.getText("tags.categorized", tags.size());
            } else if (tags.size() == 1) {
                summary = Localization.Main.getText("tags.categorized.single");
            }
        } else {
            summary = Summarizer.INSTANCE.summarizeTagLevels(level.getChildren());
        }
        int maxPages = Summarizer.INSTANCE.getPageNumber(itemsCount);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            for (int i = from; i < itemsCount; ++i) {
                if (i - from >= StanzaConfiguration.INSTANCE.getMaxBeforePaginate()) {
                    Element nextLink = this.getLevelOfTreeNode(pBreadcrumbs, level, i);
                    feed.addContent((Content)nextLink);
                    break;
                }
                TreeNode childLevel = (TreeNode)level.getChildren().get(i);
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                Element entry2 = this.getLevelOfTreeNode(breadcrumbs, childLevel);
                if (entry2 == null) continue;
                feed.addContent((Content)entry2);
            }
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        if (from > 0) {
            String titleNext = pageNumber != maxPages ? Localization.Main.getText("title.nextpage", pageNumber, maxPages) : Localization.Main.getText("title.lastpage");
            entry = FeedHelper.INSTANCE.getNext(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename), titleNext);
        } else {
            entry = FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHcSURBVDjLhZPZihpBFIbrJeY2wbcQmjxdIGSSTC4zQxLyAK4o7igoKm7TPW49LoiYjqLG3DWpZmx7/tQpsR1xycW5qTr/9/+n+jTTdR3dbhftdhutVgvNZhOapkFVVTQajSsA7FKxTqcDx3GOajqdSki1Wr0IYeRMAsMwpPNkMnEhdCZSoFQqnYUwikzN5EYH9XpdNU0Ttm3LcwJWKhXk8/mTEEauu0YhfhKRDcuysDBt5H5tk4zHYxSLReRyuSMII+dd5M1mAxL//uvgw8Mz3t4DWWN7NxqNKAXS6fQBhIkZ+Wq1kk3r9Rpz4XytPeNLF/iqAx8f9pDhcEgpEI/HXQir1WpvxIx8uVzKps7Kls53AvCjB3x7PIQMBgNKgUgkIiGSUi6XFTEjXywWsunxj433qoM7fQ+51oDMzy2k1+tRCoRCoSt3lkKhoIgZ+Xw+P4J8F4DPTeDm3oK92aZIJpMIBAKvD15UzKdks1k+m81cyDsB+SRGuG2tYVpPL8Ued4SXlclklFQqxWkTCaILyG3bgWXvnf1+v8d9xFPLkUgklFgsxmkTd5+YxOL8QHwWQBWNRr3ipTktWL/fPym+CKAKh8PeYDDISezz+TwnV/l/v6tw9Qrxq3P3/wBazDrstPR7KQAAAABJRU5ErkJggg==");
        }
        return entry;
    }

    private Element getLevelOfTreeNode(Breadcrumbs pBreadcrumbs, TreeNode level) throws IOException {
        if (Helper.isNullOrEmpty((Object)level.getChildren())) {
            Tag tag = (Tag)level.getData();
            String urn = "calibre:tags";
            return this.getTag(pBreadcrumbs, tag, urn, level.getId());
        }
        return this.getLevelOfTreeNode(pBreadcrumbs, level, 0);
    }

    @Override
    Element _getEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        TreeNode root = this.getTreeOfTags(this.getTags());
        return this.getLevelOfTreeNode(pBreadcrumbs, root);
    }

    private TreeNode getTreeOfTags(List<Tag> tags) {
        RootTreeNode root = new RootTreeNode();
        for (Tag tag : tags) {
            String[] partsOfTag = tag.getPartsOfTag(StanzaConfiguration.INSTANCE.getSplitTagsOn());
            RootTreeNode currentPositionInTree = root;
            for (int i = 0; i < partsOfTag.length; ++i) {
                String partOfTag = partsOfTag[i];
                TreeNode nextPositionInTree = currentPositionInTree.getChildWithId(partOfTag);
                if (nextPositionInTree == null) {
                    nextPositionInTree = new TreeNode(partOfTag);
                    currentPositionInTree.addChild(nextPositionInTree);
                    currentPositionInTree = nextPositionInTree;
                    continue;
                }
                currentPositionInTree = nextPositionInTree;
            }
            currentPositionInTree.setData((Object)tag);
        }
        this.removeUnNeededLevelsInTree((TreeNode)root, null);
        return root;
    }

    private TreeNode removeUnNeededLevelsInTree(TreeNode node, TreeNode removedParent) {
        if (removedParent != null) {
            node.setId(removedParent.getId() + StanzaConfiguration.INSTANCE.getSplitTagsOn() + node.getId());
        }
        if (node.getData() != null) {
            return node;
        }
        Vector<TreeNode> newChildren = new Vector<TreeNode>(node.getChildren().size());
        for (TreeNode childNode : node.getChildren()) {
            if (childNode.getData() == null && childNode.getChildren().size() <= 1) {
                TreeNode newChild;
                if (childNode.getChildren().size() == 0 || (newChild = this.removeUnNeededLevelsInTree((TreeNode)childNode.getChildren().get(0), childNode)) == null) continue;
                newChild.setParent(node);
                newChildren.add(newChild);
                continue;
            }
            newChildren.add(this.removeUnNeededLevelsInTree(childNode, null));
        }
        node.setChildren(newChildren);
        return node;
    }
}

