/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.datamodel.filter.RemoveSelectedTagsFilter;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.SubCatalog;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.TagListSubCatalog;
import com.gmail.dpierron.calibre.opds.TagTreeSubCatalog;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagSubCatalog
extends BooksSubCatalog {
    private static final Logger logger = Logger.getLogger(TagSubCatalog.class);
    private List<Tag> tags;
    private Map<Tag, List<Book>> mapOfBooksByTag;

    public TagSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public TagSubCatalog(List<Book> books) {
        super(books);
    }

    @Override
    List<Book> filterOutStuff(List<Book> originalBooks) {
        Vector<Book> result = new Vector<Book>();
        TreeSet<Tag> tagsToRemove = new TreeSet<Tag>();
        for (Object objectToFilterOut : this.stuffToFilterOut) {
            if (!(objectToFilterOut instanceof Tag)) continue;
            tagsToRemove.add((Tag)objectToFilterOut);
        }
        if (Helper.isNotNullOrEmpty(tagsToRemove)) {
            Vector<Book> originalBooks2 = new Vector<Book>(originalBooks.size());
            for (Book book : originalBooks) {
                originalBooks2.add(book.copy());
            }
            originalBooks = originalBooks2;
            result.addAll(originalBooks);
            RemoveSelectedTagsFilter filter = new RemoveSelectedTagsFilter(tagsToRemove);
            for (Book book : originalBooks) {
                if (filter.didBookPassThroughFilter(book)) continue;
                result.remove(book);
            }
        }
        return result;
    }

    List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new Vector<Tag>();
            for (Book book : this.getBooks()) {
                for (Tag tag : book.getTags()) {
                    if (this.tags.contains(tag)) continue;
                    this.tags.add(tag);
                }
            }
            Collections.sort(this.tags, new Comparator<Tag>(){

                @Override
                public int compare(Tag o1, Tag o2) {
                    String title1 = o1 == null ? "" : o1.getName();
                    String title2 = o2 == null ? "" : o2.getName();
                    return title1.compareTo(title2);
                }
            });
        }
        return this.tags;
    }

    public Map<Tag, List<Book>> getMapOfBooksByTag() {
        if (this.mapOfBooksByTag == null) {
            this.mapOfBooksByTag = new HashMap<Tag, List<Book>>();
            for (Book book : this.getBooks()) {
                for (Tag tag : book.getTags()) {
                    List<Book> books = this.mapOfBooksByTag.get(tag);
                    if (books == null) {
                        books = new Vector<Book>();
                        this.mapOfBooksByTag.put(tag, books);
                    }
                    books.add(book);
                }
            }
        }
        return this.mapOfBooksByTag;
    }

    private boolean makeTagDeep(Tag tag, List<Book> books) {
        if (tag == null) {
            return false;
        }
        if (Helper.isNullOrEmpty((Object)tag.getName())) {
            return false;
        }
        if (books.size() < StanzaConfiguration.INSTANCE.getMinBooksToMakeDeepLevel()) {
            return false;
        }
        String name = tag.getName().toUpperCase(Locale.ENGLISH);
        for (String tagToMakeDeep : StanzaConfiguration.INSTANCE.getTokenizedTagsToMakeDeep()) {
            if (!(tagToMakeDeep.contains("*") ? name.startsWith(tagToMakeDeep = tagToMakeDeep.substring(0, tagToMakeDeep.indexOf(42))) : name.equals(tagToMakeDeep.toUpperCase(Locale.ENGLISH)))) continue;
            return true;
        }
        return false;
    }

    Element getTag(Breadcrumbs pBreadcrumbs, Tag tag, String baseurn, String titleWhenCategorized) throws IOException {
        List<Book> books;
        if (logger.isDebugEnabled()) {
            logger.debug(pBreadcrumbs + "/" + tag.getName());
        }
        if (Helper.isNullOrEmpty(books = this.getMapOfBooksByTag().get(tag))) {
            return null;
        }
        String basename = "tag_";
        String filename = this.getFilenamePrefix(pBreadcrumbs) + basename + tag.getId() + ".xml";
        filename = SecureFileManager.INSTANCE.encode(filename);
        String title = titleWhenCategorized != null ? titleWhenCategorized : tag.getName();
        String urn = baseurn + ":" + tag.getId();
        if (logger.isDebugEnabled()) {
            logger.debug("sorting " + books.size() + " books");
        }
        this.sortBooksByTitle(books);
        if (this.makeTagDeep(tag, books)) {
            String summary = Localization.Main.getText("deeplevel.summary", Summarizer.INSTANCE.getBookWord(books.size()));
            if (logger.isDebugEnabled()) {
                logger.debug("making a deep level");
            }
            return this.getSubCatalogLevel(pBreadcrumbs, books, this.getStuffToFilterOutAnd(tag), title, summary, urn, filename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHcSURBVDjLhZPZihpBFIbrJeY2wbcQmjxdIGSSTC4zQxLyAK4o7igoKm7TPW49LoiYjqLG3DWpZmx7/tQpsR1xycW5qTr/9/+n+jTTdR3dbhftdhutVgvNZhOapkFVVTQajSsA7FKxTqcDx3GOajqdSki1Wr0IYeRMAsMwpPNkMnEhdCZSoFQqnYUwikzN5EYH9XpdNU0Ttm3LcwJWKhXk8/mTEEauu0YhfhKRDcuysDBt5H5tk4zHYxSLReRyuSMII+dd5M1mAxL//uvgw8Mz3t4DWWN7NxqNKAXS6fQBhIkZ+Wq1kk3r9Rpz4XytPeNLF/iqAx8f9pDhcEgpEI/HXQir1WpvxIx8uVzKps7Kls53AvCjB3x7PIQMBgNKgUgkIiGSUi6XFTEjXywWsunxj433qoM7fQ+51oDMzy2k1+tRCoRCoSt3lkKhoIgZ+Xw+P4J8F4DPTeDm3oK92aZIJpMIBAKvD15UzKdks1k+m81cyDsB+SRGuG2tYVpPL8Ued4SXlclklFQqxWkTCaILyG3bgWXvnf1+v8d9xFPLkUgklFgsxmkTd5+YxOL8QHwWQBWNRr3ipTktWL/fPym+CKAKh8PeYDDISezz+TwnV/l/v6tw9Qrxq3P3/wBazDrstPR7KQAAAABJRU5ErkJggg==", new Option[0]);
        }
        String summary = Summarizer.INSTANCE.summarizeBooks(books);
        if (logger.isDebugEnabled()) {
            logger.debug("making a simple book list");
        }
        return this.getListOfBooks(pBreadcrumbs, books, 0, title, summary, urn, filename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHcSURBVDjLhZPZihpBFIbrJeY2wbcQmjxdIGSSTC4zQxLyAK4o7igoKm7TPW49LoiYjqLG3DWpZmx7/tQpsR1xycW5qTr/9/+n+jTTdR3dbhftdhutVgvNZhOapkFVVTQajSsA7FKxTqcDx3GOajqdSki1Wr0IYeRMAsMwpPNkMnEhdCZSoFQqnYUwikzN5EYH9XpdNU0Ttm3LcwJWKhXk8/mTEEauu0YhfhKRDcuysDBt5H5tk4zHYxSLReRyuSMII+dd5M1mAxL//uvgw8Mz3t4DWWN7NxqNKAXS6fQBhIkZ+Wq1kk3r9Rpz4XytPeNLF/iqAx8f9pDhcEgpEI/HXQir1WpvxIx8uVzKps7Kls53AvCjB3x7PIQMBgNKgUgkIiGSUi6XFTEjXywWsunxj433qoM7fQ+51oDMzy2k1+tRCoRCoSt3lkKhoIgZ+Xw+P4J8F4DPTeDm3oK92aZIJpMIBAKvD15UzKdks1k+m81cyDsB+SRGuG2tYVpPL8Ued4SXlclklFQqxWkTCaILyG3bgWXvnf1+v8d9xFPLkUgklFgsxmkTd5+YxOL8QHwWQBWNRr3ipTktWL/fPym+CKAKh8PeYDDISezz+TwnV/l/v6tw9Qrxq3P3/wBazDrstPR7KQAAAABJRU5ErkJggg==", new Option[0]);
    }

    abstract Element _getEntry(Breadcrumbs var1) throws IOException;

    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getTags())) {
            return null;
        }
        return this._getEntry(pBreadcrumbs);
    }

    public static SubCatalog getTagSubCatalog(List<Book> books) {
        if (Helper.isNotNullOrEmpty((Object)StanzaConfiguration.INSTANCE.getSplitTagsOn())) {
            return new TagTreeSubCatalog(books);
        }
        return new TagListSubCatalog(books);
    }

    public static SubCatalog getTagSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        if (Helper.isNotNullOrEmpty((Object)StanzaConfiguration.INSTANCE.getSplitTagsOn())) {
            return new TagTreeSubCatalog(stuffToFilterOut, books);
        }
        return new TagListSubCatalog(stuffToFilterOut, books);
    }
}

