/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.TagSubCatalog;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagListSubCatalog
extends TagSubCatalog {
    public TagListSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public TagListSubCatalog(List<Book> books) {
        super(books);
    }

    @Override
    Element _getEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_tags.xml");
        String title = Localization.Main.getText("tags.title");
        String urn = "calibre:tags";
        String summary = "";
        if (this.getTags().size() > 1) {
            summary = Localization.Main.getText("tags.alphabetical", this.getTags().size());
        } else if (this.getTags().size() == 1) {
            summary = Localization.Main.getText("authors.alphabetical.single");
        }
        return this.getListOfTags(pBreadcrumbs, this.getTags(), 0, null, title, summary, urn, filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getListOfTags(Breadcrumbs pBreadcrumbs, List<Tag> tags, int from, String guid, String title, String summary, String urn, String pFilename, SplitOption splitOption) throws IOException {
        Element entry;
        int catalogSize;
        boolean willSplit;
        Map<String, List<Tag>> mapOfTagsByLetter = null;
        boolean bl = willSplit = splitOption != SplitOption.Paginate && tags.size() > StanzaConfiguration.INSTANCE.getMaxBeforeSplit();
        if (willSplit) {
            mapOfTagsByLetter = DataModel.splitTagsByLetter(tags);
            catalogSize = 0;
        } else {
            catalogSize = tags.size();
        }
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        int maxPages = Summarizer.INSTANCE.getPageNumber(catalogSize);
        String filename = SecureFileManager.INSTANCE.decode(pFilename);
        if (Helper.isNotNullOrEmpty((Object)guid)) {
            filename = filename + "_" + guid;
        }
        if (from > 0) {
            int pos = filename.lastIndexOf(".xml");
            if (pos >= 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + "_" + pageNumber;
        }
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        filename = SecureFileManager.INSTANCE.encode(filename);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            List<Object> result;
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            if (willSplit) {
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                result = this.getListOfTagsSplitByLetter(breadcrumbs, mapOfTagsByLetter, guid, title, urn, pFilename);
            } else {
                result = new Vector();
                for (int i = from; i < tags.size(); ++i) {
                    if (i - from >= StanzaConfiguration.INSTANCE.getMaxBeforePaginate()) {
                        Element nextLink = this.getListOfTags(pBreadcrumbs, tags, i, guid, title, summary, urn, pFilename, splitOption);
                        result.add(nextLink);
                        break;
                    }
                    Tag tag = tags.get(i);
                    Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                    Element entry2 = this.getTag(breadcrumbs, tag, urn, null);
                    if (entry2 == null) continue;
                    result.add(entry2);
                }
            }
            feed.addContent(result);
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        if (from > 0) {
            String titleNext = pageNumber != maxPages ? Localization.Main.getText("title.nextpage", pageNumber, maxPages) : Localization.Main.getText("title.lastpage");
            entry = FeedHelper.INSTANCE.getNext(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename), titleNext);
        } else {
            entry = FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHcSURBVDjLhZPZihpBFIbrJeY2wbcQmjxdIGSSTC4zQxLyAK4o7igoKm7TPW49LoiYjqLG3DWpZmx7/tQpsR1xycW5qTr/9/+n+jTTdR3dbhftdhutVgvNZhOapkFVVTQajSsA7FKxTqcDx3GOajqdSki1Wr0IYeRMAsMwpPNkMnEhdCZSoFQqnYUwikzN5EYH9XpdNU0Ttm3LcwJWKhXk8/mTEEauu0YhfhKRDcuysDBt5H5tk4zHYxSLReRyuSMII+dd5M1mAxL//uvgw8Mz3t4DWWN7NxqNKAXS6fQBhIkZ+Wq1kk3r9Rpz4XytPeNLF/iqAx8f9pDhcEgpEI/HXQir1WpvxIx8uVzKps7Kls53AvCjB3x7PIQMBgNKgUgkIiGSUi6XFTEjXywWsunxj433qoM7fQ+51oDMzy2k1+tRCoRCoSt3lkKhoIgZ+Xw+P4J8F4DPTeDm3oK92aZIJpMIBAKvD15UzKdks1k+m81cyDsB+SRGuG2tYVpPL8Ued4SXlclklFQqxWkTCaILyG3bgWXvnf1+v8d9xFPLkUgklFgsxmkTd5+YxOL8QHwWQBWNRr3ipTktWL/fPym+CKAKh8PeYDDISezz+TwnV/l/v6tw9Qrxq3P3/wBazDrstPR7KQAAAABJRU5ErkJggg==");
        }
        return entry;
    }

    private List<Element> getListOfTagsSplitByLetter(Breadcrumbs pBreadcrumbs, Map<String, List<Tag>> mapOfTagsByLetter, String guid, String baseTitle, String baseUrn, String baseFilename) throws IOException {
        if (Helper.isNullOrEmpty(mapOfTagsByLetter)) {
            return null;
        }
        String sTitle = baseTitle;
        if (Helper.isNotNullOrEmpty((Object)sTitle)) {
            sTitle = sTitle + ", ";
        }
        Vector<Element> result = new Vector<Element>(mapOfTagsByLetter.keySet().size());
        TreeSet<String> letters = new TreeSet<String>(mapOfTagsByLetter.keySet());
        for (String letter : letters) {
            String baseFilenameCleanedUp = SecureFileManager.INSTANCE.decode(baseFilename);
            int pos = baseFilenameCleanedUp.indexOf(".xml");
            if (pos > -1) {
                baseFilenameCleanedUp = baseFilenameCleanedUp.substring(0, pos);
            }
            String letterFilename = baseFilenameCleanedUp + "_" + letter + ".xml";
            letterFilename = SecureFileManager.INSTANCE.encode(letterFilename);
            String letterUrn = baseUrn + ":" + letter;
            List<Tag> tagsInThisLetter = mapOfTagsByLetter.get(letter);
            String letterTitle = letter.equals("_") ? Localization.Main.getText("splitByLetter.tag.other") : Localization.Main.getText("splitByLetter.letter", Localization.Main.getText("tagword.title"), letter);
            String summary = Summarizer.INSTANCE.summarizeTags(tagsInThisLetter);
            Element element = null;
            if (tagsInThisLetter.size() > 0) {
                element = this.getListOfTags(pBreadcrumbs, tagsInThisLetter, 0, guid, letterTitle, summary, letterUrn, letterFilename, SplitOption.Paginate);
            }
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }
}

