/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.tools.Composite;
import com.gmail.dpierron.tools.TreeNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Summarizer {
    INSTANCE;


    public int getPageNumber(int itemNumber) {
        double pageSize = StanzaConfiguration.INSTANCE.getMaxBeforePaginate();
        double dItemNumber = itemNumber;
        double result = dItemNumber / pageSize;
        return (int)Math.ceil(result);
    }

    public String summarizeBooks(List elements) {
        InternalSummarizer summarizer = new InternalSummarizer(){

            String getWord(int itemsCount) {
                return Summarizer.this.getBookWord(itemsCount);
            }

            String getTitle(Object o) {
                return ((Book)o).getTitle();
            }
        };
        return summarizer.summarize(elements);
    }

    public String summarizeTags(List elements) {
        InternalSummarizer summarizer = new InternalSummarizer(){

            String getWord(int itemsCount) {
                return Summarizer.this.getTagWord(itemsCount);
            }

            String getTitle(Object o) {
                return ((Tag)o).getName();
            }
        };
        return summarizer.summarize(elements);
    }

    public String summarizeTagLevels(List elements) {
        InternalSummarizer summarizer = new InternalSummarizer(){

            String getWord(int itemsCount) {
                return Summarizer.this.getTagLevelWord(itemsCount);
            }

            String getTitle(Object o) {
                return ((TreeNode)o).getId();
            }
        };
        return summarizer.summarize(elements);
    }

    public String summarizeAuthors(List elements) {
        InternalSummarizer summarizer = new InternalSummarizer(){

            String getWord(int itemsCount) {
                return Summarizer.this.getAuthorWord(itemsCount);
            }

            String getTitle(Object o) {
                return ((Author)o).getLastName();
            }
        };
        return summarizer.summarize(elements);
    }

    public String summarizeSeries(List elements) {
        InternalSummarizer summarizer = new InternalSummarizer(){

            String getWord(int itemsCount) {
                return Summarizer.this.getSeriesWord(itemsCount);
            }

            String getTitle(Object o) {
                return ((Series)o).getName();
            }
        };
        return summarizer.summarize(elements);
    }

    public String getBookWord(int nb) {
        if (nb == 0) {
            return Localization.Main.getText("bookword.none");
        }
        if (nb == 1) {
            return Localization.Main.getText("bookword.one");
        }
        return Localization.Main.getText("bookword.many", nb);
    }

    public String getAuthorWord(int nb) {
        if (nb == 0) {
            return Localization.Main.getText("authorword.none");
        }
        if (nb == 1) {
            return Localization.Main.getText("authorword.one");
        }
        return Localization.Main.getText("authorword.many", nb);
    }

    public String getTagLevelWord(int nb) {
        if (nb == 0) {
            return Localization.Main.getText("taglevelword.none");
        }
        if (nb == 1) {
            return Localization.Main.getText("taglevelword.one");
        }
        return Localization.Main.getText("taglevelword.many", nb);
    }

    public String getSeriesWord(int nb) {
        if (nb == 0) {
            return Localization.Main.getText("seriesword.none");
        }
        if (nb == 1) {
            return Localization.Main.getText("seriesword.one");
        }
        return Localization.Main.getText("seriesword.many", nb);
    }

    public String getTagWord(int nb) {
        if (nb == 0) {
            return Localization.Main.getText("tagword.none");
        }
        if (nb == 1) {
            return Localization.Main.getText("tagword.one");
        }
        return Localization.Main.getText("tagword.many", nb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class InternalSummarizer {
        private InternalSummarizer() {
        }

        abstract String getWord(int var1);

        abstract String getTitle(Object var1);

        public Composite<Integer, String> concatenateListWhileShortening(String separator, Collection toConcatenate, int maxSize) {
            Composite badResult = new Composite((Object)0, null);
            try {
                if (toConcatenate == null || toConcatenate.size() == 0) {
                    return badResult;
                }
                StringBuffer lines = new StringBuffer();
                String theSeparator = separator == null ? ", " : separator;
                Iterator iter = toConcatenate.iterator();
                int howMuch = 0;
                while (iter.hasNext() && lines.length() < maxSize) {
                    Object o = iter.next();
                    String result = null;
                    result = this.getTitle(o);
                    if (result == null) {
                        result = o.toString();
                    }
                    if (lines.length() < maxSize - result.length()) {
                        lines.append(result);
                        ++howMuch;
                        if (!iter.hasNext() || lines.length() >= maxSize - theSeparator.length()) continue;
                        lines.append(theSeparator);
                        continue;
                    }
                    lines.append("...");
                    break;
                }
                return new Composite((Object)howMuch, (Object)lines.toString());
            }
            catch (Exception e) {
                return badResult;
            }
        }

        public String summarize(List elements) {
            return this.summarize(elements, false);
        }

        public String summarize(List elements, boolean includePagesCount) {
            if (elements == null) {
                return "";
            }
            int itemsCount = elements.size();
            Composite<Integer, String> shortList = this.concatenateListWhileShortening(", ", elements, StanzaConfiguration.INSTANCE.getMaxSummaryLength());
            int shortListItemCount = (Integer)shortList.getFirstElement();
            String summary = (String)shortList.getSecondElement();
            if (shortListItemCount < itemsCount) {
                int maxPages;
                String itemsCountSummary;
                summary = itemsCountSummary = this.getWord(itemsCount);
                if (includePagesCount && (maxPages = Summarizer.this.getPageNumber(itemsCount)) > 1) {
                    summary = Localization.Main.getText("title.numberOfPages", itemsCountSummary, maxPages);
                }
            }
            return summary;
        }
    }
}

