/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.opds.AllBooksSubCatalog;
import com.gmail.dpierron.calibre.opds.AuthorsSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.CatalogContext;
import com.gmail.dpierron.calibre.opds.CatalogManager;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.HtmlManager;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.RatingsSubCatalog;
import com.gmail.dpierron.calibre.opds.RecentBooksSubCatalog;
import com.gmail.dpierron.calibre.opds.SeriesSubCatalog;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.TagSubCatalog;
import com.gmail.dpierron.calibre.opds.ThumbnailManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubCatalog {
    private List<Book> books;
    Set<Object> stuffToFilterOut;

    public SubCatalog(List<Book> books) {
        this(null, books);
    }

    public SubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        this.setStuffToFilterOut(stuffToFilterOut);
        this.setBooks(books);
    }

    void setBooks(List<Book> books) {
        this.books = null;
        if (Helper.isNotNullOrEmpty(this.stuffToFilterOut)) {
            this.books = this.filterOutStuff(books);
        }
        if (this.books == null) {
            this.books = books;
        }
    }

    List<Book> getBooks() {
        return this.books;
    }

    Set<Object> getStuffToFilterOut() {
        return this.stuffToFilterOut;
    }

    Set<Object> getStuffToFilterOutAnd(Object newStuff) {
        TreeSet<Object> result = new TreeSet<Object>();
        if (this.stuffToFilterOut != null) {
            result.addAll(this.stuffToFilterOut);
        }
        if (newStuff != null) {
            result.add(newStuff);
        }
        return result;
    }

    SubCatalog setStuffToFilterOut(Set<Object> stuffToFilterOut) {
        this.stuffToFilterOut = stuffToFilterOut;
        return this;
    }

    List<Book> filterOutStuff(List<Book> originalBooks) {
        return originalBooks;
    }

    boolean isInDeepLevel() {
        return Helper.isNotNullOrEmpty(this.stuffToFilterOut);
    }

    HtmlManager getHtmlManager() {
        return CatalogContext.INSTANCE.getHtmlManager();
    }

    void setHtmlManager(HtmlManager htmlManager) {
        CatalogContext.INSTANCE.setHtmlManager(htmlManager);
    }

    CatalogManager getCatalogManager() {
        return CatalogContext.INSTANCE.getCatalogManager();
    }

    void setCatalogManager(CatalogManager catalogManager) {
        CatalogContext.INSTANCE.setCatalogManager(catalogManager);
    }

    public ThumbnailManager getThumbnailManager() {
        return CatalogContext.INSTANCE.getThumbnailManager();
    }

    public void setThumbnailManager(ThumbnailManager thumbnailManager) {
        CatalogContext.INSTANCE.setThumbnailManager(thumbnailManager);
    }

    public abstract Element getSubCatalogEntry(Breadcrumbs var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getSubCatalogLevel(Breadcrumbs pBreadcrumbs, List<Book> books, Set<Object> stuffToFilterOut, String title, String summary, String urn, String filename, SplitOption splitOption, String icon, Option ... options) throws IOException {
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
            Element entry = TagSubCatalog.getTagSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                feed.addContent((Content)entry);
            }
            if ((entry = new AuthorsSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs)) != null) {
                feed.addContent((Content)entry);
            }
            if ((entry = new SeriesSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs)) != null) {
                feed.addContent((Content)entry);
            }
            if ((entry = new RecentBooksSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs)) != null) {
                feed.addContent((Content)entry);
            }
            if (StanzaConfiguration.INSTANCE.generateRatings() && (entry = new RatingsSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs)) != null) {
                feed.addContent((Content)entry);
            }
            if (StanzaConfiguration.INSTANCE.generateAllbooks() && (entry = new AllBooksSubCatalog(stuffToFilterOut, books).getSubCatalogEntry(breadcrumbs)) != null) {
                feed.addContent((Content)entry);
            }
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        return FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHcSURBVDjLhZPZihpBFIbrJeY2wbcQmjxdIGSSTC4zQxLyAK4o7igoKm7TPW49LoiYjqLG3DWpZmx7/tQpsR1xycW5qTr/9/+n+jTTdR3dbhftdhutVgvNZhOapkFVVTQajSsA7FKxTqcDx3GOajqdSki1Wr0IYeRMAsMwpPNkMnEhdCZSoFQqnYUwikzN5EYH9XpdNU0Ttm3LcwJWKhXk8/mTEEauu0YhfhKRDcuysDBt5H5tk4zHYxSLReRyuSMII+dd5M1mAxL//uvgw8Mz3t4DWWN7NxqNKAXS6fQBhIkZ+Wq1kk3r9Rpz4XytPeNLF/iqAx8f9pDhcEgpEI/HXQir1WpvxIx8uVzKps7Kls53AvCjB3x7PIQMBgNKgUgkIiGSUi6XFTEjXywWsunxj433qoM7fQ+51oDMzy2k1+tRCoRCoSt3lkKhoIgZ+Xw+P4J8F4DPTeDm3oK92aZIJpMIBAKvD15UzKdks1k+m81cyDsB+SRGuG2tYVpPL8Ued4SXlclklFQqxWkTCaILyG3bgWXvnf1+v8d9xFPLkUgklFgsxmkTd5+YxOL8QHwWQBWNRr3ipTktWL/fPym+CKAKh8PeYDDISezz+TwnV/l/v6tw9Qrxq3P3/wBazDrstPR7KQAAAABJRU5ErkJggg==");
    }

    String getFilenamePrefix(Breadcrumbs pBreadcrumbs) {
        if (this.isInDeepLevel()) {
            return pBreadcrumbs.getFilename() + "_";
        }
        return "";
    }
}

