/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeriesSubCatalog
extends BooksSubCatalog {
    private List<Series> series;
    private Map<Series, List<Book>> mapOfBooksBySerie;

    public SeriesSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public SeriesSubCatalog(List<Book> books) {
        super(books);
    }

    List<Series> getSeries() {
        if (this.series == null) {
            this.series = new Vector<Series>();
            for (Book book : this.getBooks()) {
                if (book.getSeries() == null || this.series.contains(book.getSeries())) continue;
                this.series.add(book.getSeries());
            }
            Collections.sort(this.series, new Comparator<Series>(){

                @Override
                public int compare(Series o1, Series o2) {
                    String title1 = o1 == null ? "" : o1.getName();
                    String title2 = o2 == null ? "" : o2.getName();
                    return title1.compareTo(title2);
                }
            });
        }
        return this.series;
    }

    public Map<Series, List<Book>> getMapOfBooksBySerie() {
        if (this.mapOfBooksBySerie == null) {
            this.mapOfBooksBySerie = new HashMap<Series, List<Book>>();
            for (Book book : this.getBooks()) {
                List<Book> books = this.mapOfBooksBySerie.get(book.getSeries());
                if (books == null) {
                    books = new Vector<Book>();
                    Series serie = book.getSeries();
                    if (serie != null) {
                        this.mapOfBooksBySerie.put(serie, books);
                    }
                }
                books.add(book);
            }
        }
        return this.mapOfBooksBySerie;
    }

    public List<Element> getContentOfListOfSeries(Breadcrumbs pBreadcrumbs, String title, String summary, String urn, String pFilename) throws IOException {
        if (Helper.isNullOrEmpty(this.getSeries())) {
            return null;
        }
        return this.getContentOfListOfSeries(pBreadcrumbs, this.getSeries(), 0, title, summary, urn, pFilename, null, true);
    }

    private List<Element> getContentOfListOfSeries(Breadcrumbs pBreadcrumbs, List<Series> series, int from, String title, String summary, String urn, String pFilename, SplitOption splitOption, boolean addTheSeriesWordToTheTitle) throws IOException {
        List<Element> result;
        boolean willSplit;
        Map<String, List<Series>> mapOfSeriesByLetter = null;
        boolean bl = willSplit = splitOption != SplitOption.Paginate && series.size() > StanzaConfiguration.INSTANCE.getMaxBeforeSplit();
        if (willSplit) {
            mapOfSeriesByLetter = DataModel.splitSeriesByLetter(series);
        }
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        String filename = SecureFileManager.INSTANCE.decode(pFilename);
        if (from > 0) {
            int pos = filename.lastIndexOf(".xml");
            if (pos >= 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + "_" + pageNumber;
        }
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        filename = SecureFileManager.INSTANCE.encode(filename);
        if (willSplit) {
            Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
            result = this.getListOfSeriesSplitByLetter(breadcrumbs, mapOfSeriesByLetter, title, urn, pFilename, addTheSeriesWordToTheTitle);
        } else {
            result = new Vector<Element>();
            for (int i = from; i < series.size(); ++i) {
                if (i - from >= StanzaConfiguration.INSTANCE.getMaxBeforePaginate()) {
                    Element nextLink = this.getListOfSeries(pBreadcrumbs, series, i, title, summary, urn, pFilename, splitOption, addTheSeriesWordToTheTitle);
                    result.add(nextLink);
                    break;
                }
                Series serie = series.get(i);
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                Element entry = this.getSeries(breadcrumbs, serie, urn, addTheSeriesWordToTheTitle);
                if (entry == null) continue;
                result.add(entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getListOfSeries(Breadcrumbs pBreadcrumbs, List<Series> series, int from, String title, String summary, String urn, String pFilename, SplitOption splitOption, boolean addTheSeriesWordToTheTitle) throws IOException {
        Element entry;
        boolean willSplit = splitOption != SplitOption.Paginate && series.size() > StanzaConfiguration.INSTANCE.getMaxBeforeSplit();
        int catalogSize = willSplit ? 0 : series.size();
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        int maxPages = Summarizer.INSTANCE.getPageNumber(catalogSize);
        String filename = SecureFileManager.INSTANCE.decode(pFilename);
        if (from > 0) {
            int pos = filename.lastIndexOf(".xml");
            if (pos >= 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + "_" + pageNumber;
        }
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        filename = SecureFileManager.INSTANCE.encode(filename);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            List<Element> result = this.getContentOfListOfSeries(pBreadcrumbs, series, from, title, summary, urn, pFilename, splitOption, addTheSeriesWordToTheTitle);
            feed.addContent(result);
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        if (from > 0) {
            String titleNext = pageNumber != maxPages ? Localization.Main.getText("title.nextpage", pageNumber, maxPages) : Localization.Main.getText("title.lastpage");
            entry = FeedHelper.INSTANCE.getNext(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename), titleNext);
        } else {
            entry = FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ+SURBVBgZBcExbFRlAADg7//fu7teC3elQEoMgeDkYDQ6oMQQTYyGxMHZuDA6Ypw0cWI20cHJUdl0cJLIiomR6OACGhUCpqGWtlzbu/b97/3v9/tCKQVc/e7RRXz+7OrSpUXbW7S9tu8ddv0M+3iCjF1s42v8WAP0XffKi2eOXfro9dMAYJ766SL1092jfDa17DfZgycHfvh7/hau1QB9161PhgE8epoNQlAHqprRIDo3iqoYDSpeOjv2zHRl7atfNj6LALltJys1Xc9+CmYtTxtmR8yO2D7kv4MMPr7x0KULK54/NThdA+S2XTs+jOYN86MsxqBGVRErKkEV6BHynp//2fXbw9lGDZBTWp+OK7PDzqIpYiyqSMxBFakUVYVS2dxrfHHrrz1crQG6lM6vTwZmR0UHhSoHsSBTKeoS9YU8yLrUXfj+w9d2IkBOzfkz05F5KkKkCkFERACEQil0TSOnJkMNV67fHNdVHI4GUcpZVFAUZAEExEibs4P5osMeROiadHoUiIEeCgFREAoRBOMB2weNrkmbNz+9UiBCTs1yrVdHqhgIkRL0EOj7QGG5jrZ2D+XUbADEy9dunOpSun7xuXMe7xUPNrOd/WyeyKUIoRgOGS8xWWZ7b6FLaROgzim9iXd+vXvf7mHtoCnaXDRtkLpel3t9KdamUx+8fcbj7YWc0hZAndv25XffeGH8yfuvAoBcaHOROhS+vLlhecD+wUJu222AOrft/cdPZr65ddfqsbHVyZLVlZHpysjx5aHRMBrV0XuX141qtnb25bb9F6Duu+7b23funb195955nMRJnMAJTJeGg8HS0sBkZWx1suz3Px79iZ8A/gd7ijssEaZF9QAAAABJRU5ErkJggg==");
        }
        return entry;
    }

    private List<Element> getListOfSeriesSplitByLetter(Breadcrumbs pBreadcrumbs, Map<String, List<Series>> mapOfSeriesByLetter, String baseTitle, String baseUrn, String baseFilename, boolean addTheSeriesWordToTheTitle) throws IOException {
        if (Helper.isNullOrEmpty(mapOfSeriesByLetter)) {
            return null;
        }
        String sTitle = baseTitle;
        if (Helper.isNotNullOrEmpty((Object)sTitle)) {
            sTitle = sTitle + ", ";
        }
        Vector<Element> result = new Vector<Element>(mapOfSeriesByLetter.keySet().size());
        TreeSet<String> letters = new TreeSet<String>(mapOfSeriesByLetter.keySet());
        for (String letter : letters) {
            String baseFilenameCleanedUp = SecureFileManager.INSTANCE.decode(baseFilename);
            int pos = baseFilenameCleanedUp.indexOf(".xml");
            if (pos > -1) {
                baseFilenameCleanedUp = baseFilenameCleanedUp.substring(0, pos);
            }
            String letterFilename = baseFilenameCleanedUp + "_" + letter + ".xml";
            letterFilename = SecureFileManager.INSTANCE.encode(letterFilename);
            String letterUrn = baseUrn + ":" + letter;
            List<Series> seriesInThisLetter = mapOfSeriesByLetter.get(letter);
            int itemsCount = seriesInThisLetter.size();
            String letterTitle = letter.equals("_") ? Localization.Main.getText("splitByLetter.series.other") : Localization.Main.getText("splitByLetter.letter", Localization.Main.getText("seriesword.title"), letter);
            Element element = null;
            if (itemsCount > 0) {
                String summary = Summarizer.INSTANCE.summarizeSeries(seriesInThisLetter);
                element = this.getListOfSeries(pBreadcrumbs, seriesInThisLetter, 0, letterTitle, summary, letterUrn, letterFilename, SplitOption.Paginate, addTheSeriesWordToTheTitle);
            }
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private Element getSeries(Breadcrumbs pBreadcrumbs, Series series, String baseurn, boolean addTheSeriesWordToTheTitle) throws IOException {
        List<Book> books = this.getMapOfBooksBySerie().get(series);
        if (Helper.isNullOrEmpty(books)) {
            return null;
        }
        Collections.sort(books, new Comparator<Book>(){

            @Override
            public int compare(Book o1, Book o2) {
                Integer index1 = o1 == null ? Integer.MIN_VALUE : o1.getSerieIndex();
                Integer index2 = o2 == null ? Integer.MIN_VALUE : o2.getSerieIndex();
                return index1.compareTo(index2);
            }
        });
        String basename = "serie_";
        String filename = this.getFilenamePrefix(pBreadcrumbs) + basename + series.getId() + ".xml";
        filename = SecureFileManager.INSTANCE.encode(filename);
        String title = series.getName();
        if (addTheSeriesWordToTheTitle) {
            title = Localization.Main.getText("content.series") + " " + title;
        }
        String urn = baseurn + ":" + series.getId();
        String summary = Summarizer.INSTANCE.summarizeBooks(books);
        Element result = this.getListOfBooks(pBreadcrumbs, books, 0, title, summary, urn, filename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ+SURBVBgZBcExbFRlAADg7//fu7teC3elQEoMgeDkYDQ6oMQQTYyGxMHZuDA6Ypw0cWI20cHJUdl0cJLIiomR6OACGhUCpqGWtlzbu/b97/3v9/tCKQVc/e7RRXz+7OrSpUXbW7S9tu8ddv0M+3iCjF1s42v8WAP0XffKi2eOXfro9dMAYJ766SL1092jfDa17DfZgycHfvh7/hau1QB9161PhgE8epoNQlAHqprRIDo3iqoYDSpeOjv2zHRl7atfNj6LALltJys1Xc9+CmYtTxtmR8yO2D7kv4MMPr7x0KULK54/NThdA+S2XTs+jOYN86MsxqBGVRErKkEV6BHynp//2fXbw9lGDZBTWp+OK7PDzqIpYiyqSMxBFakUVYVS2dxrfHHrrz1crQG6lM6vTwZmR0UHhSoHsSBTKeoS9YU8yLrUXfj+w9d2IkBOzfkz05F5KkKkCkFERACEQil0TSOnJkMNV67fHNdVHI4GUcpZVFAUZAEExEibs4P5osMeROiadHoUiIEeCgFREAoRBOMB2weNrkmbNz+9UiBCTs1yrVdHqhgIkRL0EOj7QGG5jrZ2D+XUbADEy9dunOpSun7xuXMe7xUPNrOd/WyeyKUIoRgOGS8xWWZ7b6FLaROgzim9iXd+vXvf7mHtoCnaXDRtkLpel3t9KdamUx+8fcbj7YWc0hZAndv25XffeGH8yfuvAoBcaHOROhS+vLlhecD+wUJu222AOrft/cdPZr65ddfqsbHVyZLVlZHpysjx5aHRMBrV0XuX141qtnb25bb9F6Duu+7b23funb195955nMRJnMAJTJeGg8HS0sBkZWx1suz3Px79iZ8A/gd7ijssEaZF9QAAAABJRU5ErkJggg==", Option.INCLUDE_SERIE_NUMBER);
        return result;
    }

    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getSeries())) {
            return null;
        }
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_series.xml");
        String title = Localization.Main.getText("series.title");
        String urn = "calibre:series";
        String summary = "";
        if (this.getSeries().size() > 1) {
            summary = Localization.Main.getText("series.alphabetical", this.series.size());
        } else if (this.getSeries().size() == 1) {
            summary = Localization.Main.getText("series.alphabetical.single");
        }
        return this.getListOfSeries(pBreadcrumbs, this.getSeries(), 0, title, summary, urn, filename, null, false);
    }
}

