/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentBooksSubCatalog
extends BooksSubCatalog {
    public RecentBooksSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
        this.sortBooks();
    }

    public RecentBooksSubCatalog(List<Book> books) {
        super(books);
        this.sortBooks();
    }

    private void sortBooks() {
        Collections.sort(this.getBooks(), new Comparator<Book>(){

            @Override
            public int compare(Book o1, Book o2) {
                Date ts1 = o1 == null ? new Date() : o1.getTimestamp();
                Date ts2 = o2 == null ? new Date() : o2.getTimestamp();
                return ts2.compareTo(ts1);
            }
        });
        this.setBooks(new Helper.ListCopier().copyList(this.getBooks(), StanzaConfiguration.INSTANCE.getBooksInRecentAdditions()));
    }

    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getBooks())) {
            return null;
        }
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_recent.xml");
        String title = Localization.Main.getText("recent.title");
        String urn = "calibre:recent";
        String summary = "";
        if (this.getBooks().size() > 1) {
            summary = Localization.Main.getText("recent.list", this.getBooks().size());
        } else if (this.getBooks().size() == 1) {
            summary = Localization.Main.getText("recent.list.single");
        }
        return this.getListOfBooks(pBreadcrumbs, this.getBooks(), 0, title, summary, urn, filename, SplitOption.SplitByDate, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAIESURBVDjLlVJtaxpBEH7uvNSL50skFBqCiDVYpCWiIAjtx4Ih4I/zs78jkD9QioVAUBGNWigqRfpBxSO+3LnbmY13mNQWOvAwuzszz7zsQEoJBomWzWY/V6vVb5lM5oruBr/tYBQKhU+1Wu0r+/CbF6cOA02Tv9jr5gbn+TyGd3cQlQpe40nYFry9xZvLS/y8v8fm+lrZ0lJqukbCTlYwCCsWw3a7RTgex3EggLiuK5jkYkYiynYcjcLcEXOsvjvDNAx0BgPl1O31IIjEPjmBHQ5ja5rodLvK1nl48Ang9dgHRIyyN87O0LNtXFD2FLWmU4B0HKxdF99JDwhvhUCB9CPZLwDd2K/gw+kp3lsW5GYDl5wEg8heEdG7oyNkSGuE4GKBRyL1q6jX69J13b/CcRy5XC4VWPiNYzjWwAFZr9dot9tIp9Po9/uq9/l8jnK57H25L/ohAg4ejUaI0ORzuRxSqRRCoRAosw+P6BmB95inXfAWhdFqtVQ1Dg+UqqNW/Jg/WnhZ4mw2g6DJc/BkMlFnhud3cAb7ZNwOrbaaQzKZ5OXBcDiEQb/GA9XljoqU2A+u0CqzqVgswqKv5awcPB6PfSJ/Bgv6V5uEjoIN+wjQHrDmCjhzIpHAarVSLfktdGlNyTHKZf1LvAqYrNlsolQqPRFMp9MvjUbjI/5D6Dd+sP4NLTpNB1cxufkAAAAASUVORK5CYII=", Option.INCLUDE_TIMESTAMP);
    }
}

