/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.i18n.LocalizationHelper;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingsSubCatalog
extends BooksSubCatalog {
    private List<BookRating> ratings;
    Map<BookRating, List<Book>> mapOfBooksByRating;

    public RatingsSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public RatingsSubCatalog(List<Book> books) {
        super(books);
    }

    List<BookRating> getRatings() {
        if (this.ratings == null) {
            this.ratings = new Vector<BookRating>();
            for (Book book : this.getBooks()) {
                if (this.ratings.contains((Object)book.getRating())) continue;
                this.ratings.add(book.getRating());
            }
            Collections.sort(this.ratings, new Comparator<BookRating>(){

                @Override
                public int compare(BookRating o1, BookRating o2) {
                    int val1 = o1 == null ? -1 : o1.getValue();
                    int val2 = o2 == null ? -1 : o2.getValue();
                    return new Integer(val1).compareTo(new Integer(val2));
                }
            });
        }
        return this.ratings;
    }

    private Map<BookRating, List<Book>> getMapOfBooksByRating() {
        if (this.mapOfBooksByRating == null) {
            this.mapOfBooksByRating = new HashMap<BookRating, List<Book>>();
            for (Book book : this.getBooks()) {
                List<Book> books = this.mapOfBooksByRating.get((Object)book.getRating());
                if (books == null) {
                    books = new Vector<Book>();
                    BookRating rating = book.getRating();
                    if (rating != null) {
                        this.mapOfBooksByRating.put(rating, books);
                    }
                }
                books.add(book);
            }
        }
        return this.mapOfBooksByRating;
    }

    private Element getRatedBooks(Breadcrumbs pBreadcrumbs, BookRating rating, String baseurn) throws IOException {
        List<Book> books = this.getMapOfBooksByRating().get((Object)rating);
        if (Helper.isNullOrEmpty(books)) {
            return null;
        }
        if (books == null) {
            books = new Vector<Book>();
        }
        String basename = "rated_";
        String filename = this.getFilenamePrefix(pBreadcrumbs) + basename + rating.getId() + ".xml";
        filename = SecureFileManager.INSTANCE.encode(filename);
        String title = LocalizationHelper.INSTANCE.getEnumConstantHumanName(rating);
        String urn = baseurn + ":" + rating.getId();
        this.sortBooksByTitle(books);
        String summary = Summarizer.INSTANCE.summarizeBooks(books);
        Element result = this.getListOfBooks(pBreadcrumbs, books, 0, title, summary, urn, filename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGvSURBVDjLpZO7alZREEbXiSdqJJDKYJNCkPBXYq12prHwBezSCpaidnY+graCYO0DpLRTQcR3EFLl8p+9525xgkRIJJApB2bN+gZmqCouU+NZzVef9isyUYeIRD0RTz482xouBBBNHi5u4JlkgUfx+evhxQ2aJRrJ/oFjUWysXeG45cUBy+aoJ90Sj0LGFY6anw2o1y/mK2ZS5pQ50+2XiBbdCvPk+mpw2OM/Bo92IJMhgiGCox+JeNEksIC11eLwvAhlzuAO37+BG9y9x3FTuiWTzhH61QFvdg5AdAZIB3Mw50AKsaRJYlGsX0tymTzf2y1TR9WwbogYY3ZhxR26gBmocrxMuhZNE435FtmSx1tP8QgiHEvj45d3jNlONouAKrjjzWaDv4CkmmNu/Pz9CzVh++Yd2rIz5tTnwdZmAzNymXT9F5AtMFeaTogJYkJfdsaaGpyO4E62pJ0yUCtKQFxo0hAT1JU2CWNOJ5vvP4AIcKeao17c2ljFE8SKEkVdWWxu42GYK9KE4c3O20pzSpyyoCx4v/6ECkCTCqccKorNxR5uSXgQnmQkw2Xf+Q+0iqQ9Ap64TwAAAABJRU5ErkJggg==", Option.DONOTINCLUDE_RATING);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getRatings())) {
            return null;
        }
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_rating.xml");
        String title = Localization.Main.getText("rating.title");
        String urn = "calibre:rating";
        String summary = Localization.Main.getText("rating.summary", Summarizer.INSTANCE.getBookWord(this.getBooks().size()));
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            Vector<Element> result = new Vector<Element>();
            for (int i = 0; i < BookRating.sortedRatings().length; ++i) {
                BookRating rating = BookRating.sortedRatings()[i];
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                Element entry = this.getRatedBooks(breadcrumbs, rating, urn);
                if (entry == null) continue;
                result.add(entry);
            }
            feed.addContent(result);
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        return FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGvSURBVDjLpZO7alZREEbXiSdqJJDKYJNCkPBXYq12prHwBezSCpaidnY+graCYO0DpLRTQcR3EFLl8p+9525xgkRIJJApB2bN+gZmqCouU+NZzVef9isyUYeIRD0RTz482xouBBBNHi5u4JlkgUfx+evhxQ2aJRrJ/oFjUWysXeG45cUBy+aoJ90Sj0LGFY6anw2o1y/mK2ZS5pQ50+2XiBbdCvPk+mpw2OM/Bo92IJMhgiGCox+JeNEksIC11eLwvAhlzuAO37+BG9y9x3FTuiWTzhH61QFvdg5AdAZIB3Mw50AKsaRJYlGsX0tymTzf2y1TR9WwbogYY3ZhxR26gBmocrxMuhZNE435FtmSx1tP8QgiHEvj45d3jNlONouAKrjjzWaDv4CkmmNu/Pz9CzVh++Yd2rIz5tTnwdZmAzNymXT9F5AtMFeaTogJYkJfdsaaGpyO4E62pJ0yUCtKQFxo0hAT1JU2CWNOJ5vvP4AIcKeao17c2ljFE8SKEkVdWWxu42GYK9KE4c3O20pzSpyyoCx4v/6ECkCTCqccKorNxR5uSXgQnmQkw2Xf+Q+0iqQ9Ap64TwAAAABJRU5ErkJggg==");
    }
}

