/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.Catalog;
import com.gmail.dpierron.calibre.opds.CatalogCallbackInterface;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.i18n.LocalizationHelper;
import com.gmail.dpierron.tools.Helper;
import org.apache.log4j.Logger;

public class Log4jCatalogCallback
implements CatalogCallbackInterface {
    private static final Logger logger = Logger.getLogger(Catalog.class);
    double to20;
    int pos;
    int position;

    private void dumpOption(String option, Object value) {
        String label = Localization.Main.getText("config." + option + ".label");
        label = Helper.pad((String)label, (char)' ', (int)40) + " : ";
        logger.info(label + value);
    }

    public void dumpOptions() {
        this.dumpOption("lang", StanzaConfiguration.INSTANCE.getLanguage());
        this.dumpOption("wikilang", StanzaConfiguration.INSTANCE.getWikipediaLanguage());
        this.dumpOption("catalogFolder", StanzaConfiguration.INSTANCE.getCatalogFolderName());
        this.dumpOption("catalogTitle", StanzaConfiguration.INSTANCE.getCatalogTitle());
        this.dumpOption("maxbeforepaginate", StanzaConfiguration.INSTANCE.getMaxBeforePaginate());
        this.dumpOption("maxbeforesplit", StanzaConfiguration.INSTANCE.getMaxBeforeSplit());
        this.dumpOption("booksinrecent", StanzaConfiguration.INSTANCE.getBooksInRecentAdditions());
        this.dumpOption("includeformat", StanzaConfiguration.INSTANCE.getIncludedFormatsList());
        this.dumpOption("nobandwithoptimize", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.saveBandwith()));
        this.dumpOption("nogeneratehtml", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateHtml()));
        this.dumpOption("nogeneratehtmlfiles", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateHtmlDownloads()));
        this.dumpOption("nogeneratefiles", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateDownloads()));
        this.dumpOption("thumbnailheight", StanzaConfiguration.INSTANCE.getThumbnailHeight());
        this.dumpOption("splittagson", StanzaConfiguration.INSTANCE.getSplitTagsOn());
        this.dumpOption("includeemptybooks", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getIncludeBooksWithNoFile()));
        this.dumpOption("cryptfilenames", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getCryptFilenames()));
        this.dumpOption("noshowseriesinauthorcatalog", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.getShowSeriesInAuthorCatalog()));
        this.dumpOption("noexternallinks", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateExternalLinks()));
        this.dumpOption("nocrosslinks", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateCrossLinks()));
        this.dumpOption("tagstogenerate", StanzaConfiguration.INSTANCE.getTagsToGenerate());
        this.dumpOption("tagstoexclude", StanzaConfiguration.INSTANCE.getTagsToExclude());
        this.dumpOption("maxsummarylength", StanzaConfiguration.INSTANCE.getMaxSummaryLength());
        this.dumpOption("nogenerateratings", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateRatings()));
        this.dumpOption("nogenerateallbooks", LocalizationHelper.INSTANCE.getYesOrNo(!StanzaConfiguration.INSTANCE.generateAllbooks()));
        this.dumpOption("databaseFolder", StanzaConfiguration.INSTANCE.getDatabaseFolder());
        this.dumpOption("targetFolder", StanzaConfiguration.INSTANCE.getTargetFolder());
        this.dumpOption("copyToDatabaseFolder", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getCopyToDatabaseFolder()));
        this.dumpOption("browseByCover", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getBrowseByCover()));
        this.dumpOption("splitByAuthorInitialGoToBooks", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getSplitByAuthorInitialGoToBooks()));
        this.dumpOption("maxCoverSize", StanzaConfiguration.INSTANCE.getMaxCoverSize());
        this.dumpOption("IncludeOnlyOneFile", LocalizationHelper.INSTANCE.getYesOrNo(StanzaConfiguration.INSTANCE.getIncludeOnlyOneFile()));
        this.dumpOption("CompatibilityTrick", LocalizationHelper.INSTANCE.getEnumConstantHumanName(StanzaConfiguration.INSTANCE.getCompatibilityTrick()));
    }

    public void startCreateMainCatalog() {
    }

    public void endCreateMainCatalog(String where, long timeInHtml) {
        if (timeInHtml > 1000L) {
            logger.info(Localization.Main.getText("info.html.donein", timeInHtml / 1000L));
        }
        logger.info(Localization.Main.getText("info.step.done", where));
    }

    public void startReadDatabase() {
        logger.info(Localization.Main.getText("info.step.database"));
    }

    public void endReadDatabase(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateTags() {
        logger.info(Localization.Main.getText("info.step.tags"));
    }

    public void endCreateTags(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateAuthors() {
        logger.info(Localization.Main.getText("info.step.authors"));
    }

    public void endCreateAuthors(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateSeries() {
        logger.info(Localization.Main.getText("info.step.series"));
    }

    public void endCreateSeries(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateRecent() {
        logger.info(Localization.Main.getText("info.step.recent"));
    }

    public void endCreateRecent(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateRated() {
        logger.info(Localization.Main.getText("info.step.rated"));
    }

    public void endCreateRated(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateAllbooks() {
        logger.info(Localization.Main.getText("info.step.allbooks"));
    }

    public void endCreateAllbooks(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCreateThumbnails() {
        logger.info(Localization.Main.getText("info.step.thumbnails"));
    }

    public void endCreateThumbnails(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void startCopyLibToTarget() {
        logger.info(Localization.Main.getText("info.step.copylib"));
    }

    public void startCopyCatToTarget() {
        logger.info(Localization.Main.getText("info.step.copycat"));
    }

    public void setMaxScale(long maxScale) {
        this.to20 = 20.0 / (double)maxScale;
    }

    public void incPosition() {
        ++this.position;
        int newPos = (int)((double)this.position * this.to20);
        if (newPos > this.pos) {
            logger.info(Helper.pad((String)"", (char)'*', (int)newPos));
            this.pos = newPos;
        }
    }

    public void endCopyLibToTarget(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void endCopyCatToTarget(long milliseconds) {
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
    }

    public void errorOccured(String message, Throwable error) {
        logger.error(message, error);
    }
}

