/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.CompatibilityTrick;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.Constants;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JDOM {
    INSTANCE;

    private static final Logger logger;
    private JDOMFactory factory;
    private XMLOutputter outputter;
    private TransformerFactory transformerFactory;
    private Transformer catalogTransformer;
    private Transformer mainTransformer;

    private void setParametersOnCatalog(Transformer catalogTransformer) {
        double dh = StanzaConfiguration.INSTANCE.getThumbnailHeight();
        double dw = 0.6666666865348816 * dh;
        long lh = (long)Math.floor(dh);
        long lw = (long)Math.floor(dw);
        catalogTransformer.setParameter("thumbWidth", lw);
        catalogTransformer.setParameter("thumbHeight", lh);
        catalogTransformer.setParameter("generateDownloads", Boolean.toString(StanzaConfiguration.INSTANCE.generateHtmlDownloads()).toLowerCase());
        catalogTransformer.setParameter("libraryTitle", StanzaConfiguration.INSTANCE.getCatalogTitle());
        catalogTransformer.setParameter("i18n.backToMain", Localization.Main.getText("i18n.backToMain"));
        catalogTransformer.setParameter("i18n.downloads", Localization.Main.getText("i18n.downloads"));
        catalogTransformer.setParameter("i18n.links", Localization.Main.getText("i18n.links"));
        catalogTransformer.setParameter("i18n.downloadfile", Localization.Main.getText("i18n.downloadfile"));
        catalogTransformer.setParameter("i18n.summarysection", Localization.Main.getText("i18n.summarysection"));
        catalogTransformer.setParameter("i18n.downloadsection", Localization.Main.getText("i18n.downloadsection"));
        catalogTransformer.setParameter("i18n.relatedsection", Localization.Main.getText("i18n.relatedsection"));
        catalogTransformer.setParameter("i18n.linksection", Localization.Main.getText("i18n.linksection"));
        String dateGenerated = DateFormat.getDateInstance(2, new Locale(StanzaConfiguration.INSTANCE.getLanguage())).format(new Date());
        catalogTransformer.setParameter("i18n.dateGenerated", Localization.Main.getText("i18n.dateGenerated", dateGenerated));
        catalogTransformer.setParameter("browseByCover", Boolean.toString(StanzaConfiguration.INSTANCE.getBrowseByCover()).toLowerCase());
    }

    public Transformer getCatalogTransformer() {
        if (this.catalogTransformer == null) {
            try {
                this.catalogTransformer = this.getTransformerFactory().newTransformer(new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getXsltFilename())));
                this.setParametersOnCatalog(this.catalogTransformer);
            }
            catch (TransformerConfigurationException e) {
                logger.error("error while configuring catalog transformer", e);
            }
        }
        return this.catalogTransformer;
    }

    private String getXsltFilename() {
        if (StanzaConfiguration.INSTANCE.getCompatibilityTrick() == CompatibilityTrick.TROOK) {
            return "catalog-TROOK.xsl";
        }
        return "catalog.xsl";
    }

    public Transformer getMainCatalogTransformer() {
        if (this.mainTransformer == null) {
            try {
                this.mainTransformer = this.getTransformerFactory().newTransformer(new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getXsltFilename())));
                this.setParametersOnCatalog(this.mainTransformer);
                this.mainTransformer.setParameter("programName", "calibre2opds");
                this.mainTransformer.setParameter("programVersion", "2.3 cr1" + Constants.BZR_VERSION);
                this.mainTransformer.setParameter("i18n.intro.line1", Localization.Main.getText("intro.line1"));
                this.mainTransformer.setParameter("intro.goal", Localization.Main.getText("intro.goal"));
                this.mainTransformer.setParameter("intro.wiki.title", Localization.Main.getText("intro.wiki.title"));
                this.mainTransformer.setParameter("intro.wiki.url", Localization.Main.getText("intro.wiki.url"));
                this.mainTransformer.setParameter("intro.team.title", Localization.Main.getText("intro.team.title"));
                this.mainTransformer.setParameter("intro.team.list1", Localization.Main.getText("intro.team.list1"));
                this.mainTransformer.setParameter("intro.team.list2", Localization.Main.getText("intro.team.list2"));
                this.mainTransformer.setParameter("intro.team.list3", Localization.Main.getText("intro.team.list3"));
                this.mainTransformer.setParameter("intro.team.list4", Localization.Main.getText("intro.team.list4"));
                this.mainTransformer.setParameter("intro.thanks.1", Localization.Main.getText("intro.thanks.1"));
                this.mainTransformer.setParameter("intro.thanks.2", Localization.Main.getText("intro.thanks.2"));
            }
            catch (TransformerConfigurationException e) {
                logger.error("error while configuring catalog transformer", e);
            }
        }
        return this.mainTransformer;
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public JDOMFactory getFactory() {
        if (this.factory == null) {
            this.factory = new DefaultJDOMFactory();
        }
        return this.factory;
    }

    public XMLOutputter getOutputter() {
        if (this.outputter == null) {
            this.outputter = new XMLOutputter(Format.getPrettyFormat());
        }
        return this.outputter;
    }

    public Element element(String name, Namespace namespace) {
        Element result = this.getFactory().element(name);
        result.setNamespace(namespace.getJdomNamespace());
        result.addNamespaceDeclaration(Namespace.Opds.getJdomNamespace());
        return result;
    }

    public Element element(String name) {
        return this.element(name, Namespace.Atom);
    }

    static {
        logger = Logger.getLogger(JDOM.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Namespace {
        Atom("", "http://www.w3.org/2005/Atom"),
        Opds("opds", "http://opds-spec.org/2010/catalog"),
        Xhtml("xhtml", "http://www.w3.org/1999/xhtml");

        private org.jdom.Namespace jdomNamespace;

        private Namespace(String prefix, String uri) {
            this.jdomNamespace = org.jdom.Namespace.getNamespace((String)prefix, (String)uri);
        }

        public org.jdom.Namespace getJdomNamespace() {
            return this.jdomNamespace;
        }
    }
}

