/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

public class HtmlManager {
    private static final Logger logger = Logger.getLogger(HtmlManager.class);
    private long timeInHtml = 0L;

    public long getTimeInHtml() {
        return this.timeInHtml;
    }

    public void generateHtmlFromXml(Document document, File outputFile) throws IOException {
        this.generateHtmlFromXml(document, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateHtmlFromXml(Document document, File outputFile, boolean mainCatalog) throws IOException {
        if (StanzaConfiguration.INSTANCE.generateHtml()) {
            FileOutputStream fos = null;
            try {
                long now = System.currentTimeMillis();
                JDOMSource source = new JDOMSource(document);
                String xmlFilename = outputFile.getAbsolutePath();
                File htmlFile = new File(this.getHtmlFilenameFromXmlFilename(xmlFilename));
                fos = new FileOutputStream(htmlFile);
                StreamResult streamResult = new StreamResult(fos);
                try {
                    Transformer transformer = mainCatalog ? JDOM.INSTANCE.getMainCatalogTransformer() : JDOM.INSTANCE.getCatalogTransformer();
                    transformer.transform((Source)source, streamResult);
                }
                catch (TransformerException e) {
                    logger.error(Localization.Main.getText("error.cannotTransform", outputFile.getAbsolutePath()), e);
                }
                this.timeInHtml += System.currentTimeMillis() - now;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    private String getHtmlFilenameFromXmlFilename(String xmlFilename) {
        String htmlFilename = xmlFilename.substring(0, xmlFilename.length() - 4) + ".html";
        return htmlFilename;
    }
}

