/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.CompatibilityTrick;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.Breadcrumb;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.tools.Helper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FeedHelper {
    INSTANCE;


    public String urlEncode(String s) {
        return this.urlEncode(s, false);
    }

    public String urlEncode(String s, boolean doNotEncodeSlashes) {
        try {
            String result = s;
            if (doNotEncodeSlashes) {
                result = result.replace("/", "HERELIESASLASH_ICIUNSLASH");
            }
            result = URLEncoder.encode(result, "utf-8");
            result = result.replace("+", "%20");
            if (doNotEncodeSlashes) {
                result = result.replace("HERELIESASLASH_ICIUNSLASH", "/");
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private Element getIcon(String icon) {
        return this.getLinkElement(icon, "image/png", "http://opds-spec.org/thumbnail", null);
    }

    private Element getFeedAuthorElement() {
        return this.getFeedAuthorElement("David Pierron", "http://wiki.mobileread.com/wiki/Calibre2opds", "dpierron+calibre2opds@gmail.com");
    }

    public Element getFeedAuthorElement(String name, String uri, String email) {
        Element author = JDOM.INSTANCE.element("author");
        if (Helper.isNotNullOrEmpty((Object)author)) {
            author.addContent((Content)JDOM.INSTANCE.element("name").addContent(name));
        }
        if (Helper.isNotNullOrEmpty((Object)uri)) {
            author.addContent((Content)JDOM.INSTANCE.element("uri").addContent(uri));
        }
        if (Helper.isNotNullOrEmpty((Object)email)) {
            author.addContent((Content)JDOM.INSTANCE.element("email").addContent(email));
        }
        return author;
    }

    private Element getUpdatedTag() {
        Calendar c = Calendar.getInstance();
        return this.getUpdatedTag(c);
    }

    Element getUpdatedTag(long timeInMilli) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMilli);
        return this.getUpdatedTag(c);
    }

    private Element getUpdatedTag(Calendar c) {
        StringBuffer result = new StringBuffer();
        result.append(c.get(1));
        result.append('-');
        result.append(c.get(2));
        result.append('-');
        result.append(c.get(5));
        result.append('T');
        result.append(c.get(10));
        result.append(':');
        result.append(c.get(12));
        result.append(':');
        result.append(c.get(13));
        result.append('Z');
        return JDOM.INSTANCE.element("updated").addContent(result.toString());
    }

    String getLinkType(boolean forEntry) {
        if (StanzaConfiguration.INSTANCE.getCompatibilityTrick() == CompatibilityTrick.TROOK) {
            return "application/atom+xml";
        }
        if (forEntry) {
            return "application/atom+xml;type=entry;profile=opds-catalog";
        }
        return "application/atom+xml;type=feed;profile=opds-catalog";
    }

    String getLinkTypeForEntry() {
        return this.getLinkType(true);
    }

    String getLinkTypeForFeed() {
        return this.getLinkType(false);
    }

    Element getRelatedHtmlLinkElement(String url, String title) {
        return this.getRelatedLinkElement(url, "text/html", title);
    }

    Element getRelatedXmlLinkElement(String url, String title) {
        return this.getXmlLinkElement(url, "related", title);
    }

    Element getXmlLinkElement(String url, String relation, String title) {
        return this.getLinkElement(url, this.getLinkTypeForFeed(), relation, title);
    }

    private Element getRelatedLinkElement(String url, String urlType, String title) {
        return this.getLinkElement(url, urlType, "related", title);
    }

    public Element getFullEntryStanzaLinkElement(String url) {
        return this.getLinkElement(url, this.getLinkTypeForEntry(), null, null);
    }

    public Element getFullEntryLinkElement(String url) {
        return this.getLinkElement(url, this.getLinkTypeForEntry(), "alternate", null);
    }

    Element getLinkElement(String url, String urlType, String urlRelation, String title) {
        Element link = JDOM.INSTANCE.element("link");
        link.setAttribute("href", url);
        if (Helper.isNotNullOrEmpty((Object)urlType)) {
            link.setAttribute("type", urlType);
        }
        if (Helper.isNotNullOrEmpty((Object)urlRelation)) {
            link.setAttribute("rel", urlRelation);
        }
        if (Helper.isNotNullOrEmpty((Object)title)) {
            link.setAttribute("title", title);
        }
        return link;
    }

    Element getNext(String filename, String title) {
        return this.getXmlLinkElement(filename, "next", title);
    }

    Element getEntry(String pTitle, String urn, String filename, String pSummary, String icon) {
        return this.getAtomElement("entry", pTitle, urn, filename, pSummary, false, icon);
    }

    public Element getFeed(String pTitle, String urn, String pSummary) {
        return this.getFeed(null, pTitle, urn, pSummary);
    }

    Element getFeed(Breadcrumbs breadcrumbs, String pTitle, String urn, String pSummary) {
        Element result = this.getAtomElement("feed", pTitle, urn, null, pSummary, true, null);
        if (breadcrumbs != null) {
            for (Breadcrumb breadcrumb : breadcrumbs) {
                result.addContent((Content)this.getXmlLinkElement(breadcrumb.url, "breadcrumb", breadcrumb.title));
            }
        }
        if (!StanzaConfiguration.INSTANCE.saveBandwith()) {
            Element updated = this.getUpdatedTag();
            result.addContent((Content)updated);
        }
        result.addContent((Content)this.getXmlLinkElement("../catalog.xml", "start", Localization.Main.getText("home.title")));
        return result;
    }

    private Element getAtomElement(String pElement, String pTitle, String urn, String filename, String pSummary, boolean includeAuthor, String icon) {
        return this.getAtomElement(pElement, pTitle, urn, filename, this.getLinkTypeForFeed(), pSummary, includeAuthor, icon);
    }

    public Element getAtomElement(String pElement, String pTitle, String urn, String url, String urlType, String pSummary, boolean includeAuthor, String icon) {
        return this.getAtomElement(pElement, pTitle, urn, url, urlType, null, pSummary, includeAuthor, icon);
    }

    public Element getAtomElement(String elementName, String title, String id, String url, String urlType, String urlRelation, String content, boolean includeAuthor, String icon) {
        Element element = JDOM.INSTANCE.element(elementName);
        Element titleElement = JDOM.INSTANCE.element("title").addContent(title);
        element.addContent((Content)titleElement);
        Element idElement = JDOM.INSTANCE.element("id").addContent(id);
        element.addContent((Content)idElement);
        if (!StanzaConfiguration.INSTANCE.saveBandwith()) {
            Element updated = this.getUpdatedTag();
            element.addContent((Content)updated);
        }
        if (Helper.isNotNullOrEmpty((Object)content)) {
            Element contentElement = JDOM.INSTANCE.element("content").addContent(content);
            contentElement.setAttribute("type", "text");
            element.addContent((Content)contentElement);
        }
        if (Helper.isNotNullOrEmpty((Object)url)) {
            element.addContent((Content)this.getLinkElement(url, urlType, urlRelation, null));
        }
        if (Helper.isNotNullOrEmpty((Object)icon)) {
            element.addContent((Content)this.getIcon(icon));
        }
        if (includeAuthor) {
            element.addContent((Content)this.getFeedAuthorElement());
        }
        return element;
    }
}

