/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.cache.CachedFile;
import com.gmail.dpierron.calibre.configuration.DeviceMode;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogManager {
    private File catalogFolder;
    private List<CachedFile> listOfFilesToCopy = new Vector<CachedFile>();
    private List<String> listOfFilesPathsToCopy = new Vector<String>();
    private Map<String, String> mapOfCatalogFolderNames = new HashMap<String, String>();
    private List<File> bookEntriesFiles = new Vector<File>();

    public void setDestinationFolder(File destinationFolder) {
        this.catalogFolder = new File(destinationFolder, this.getCatalogFolderName());
        if (!this.catalogFolder.exists()) {
            this.catalogFolder.mkdirs();
        }
    }

    public File getCatalogFolder() {
        return this.catalogFolder;
    }

    public String getCatalogFolderName() {
        if (StanzaConfiguration.INSTANCE.getDeviceMode() == DeviceMode.Nook) {
            return "_catalog";
        }
        return StanzaConfiguration.INSTANCE.getCatalogFolderName();
    }

    public List<String> getListOfFilesPathsToCopy() {
        return this.listOfFilesPathsToCopy;
    }

    void addFileToTheMapOfFilesToCopy(CachedFile file) {
        String databasePath = StanzaConfiguration.INSTANCE.getDatabaseFolder().getAbsolutePath();
        int databasePathLength = databasePath.length() + 1;
        if (file == null) {
            return;
        }
        if (this.listOfFilesToCopy.contains(file)) {
            return;
        }
        String filePath = file.getAbsolutePath();
        if (!filePath.startsWith(databasePath)) {
            return;
        }
        String relativePath = filePath.substring(databasePathLength);
        this.listOfFilesPathsToCopy.add(relativePath);
        this.listOfFilesToCopy.add(file);
    }

    public String getCatalogFileUrlInItsSubfolder(String catalogFileName) {
        return this.getCatalogFileUrlInItsSubfolder(catalogFileName, true);
    }

    public String getCatalogFileUrlInItsSubfolder(String catalogFileName, boolean weAreAlsoInASubFolder) {
        String catalogFolderName = this.mapOfCatalogFolderNames.get(catalogFileName);
        if (Helper.isNullOrEmpty((Object)catalogFolderName)) {
            this.storeCatalogFileInSubfolder(catalogFileName);
            catalogFolderName = this.mapOfCatalogFolderNames.get(catalogFileName);
        }
        return (weAreAlsoInASubFolder ? "../" : "") + FeedHelper.INSTANCE.urlEncode(catalogFolderName) + "/" + FeedHelper.INSTANCE.urlEncode(catalogFileName);
    }

    String getFolderName(String pCatalogFileName) {
        if (Helper.isNullOrEmpty((Object)pCatalogFileName)) {
            return "";
        }
        String catalogFileName = pCatalogFileName;
        int pos = catalogFileName.lastIndexOf(46);
        if (pos > -1) {
            catalogFileName = catalogFileName.substring(0, pos);
        } else {
            System.out.println("");
        }
        if (catalogFileName.length() >= 32 && !catalogFileName.substring(0, 32).contains("_")) {
            return catalogFileName.substring(0, 32);
        }
        if (catalogFileName.length() >= 24 && !catalogFileName.substring(0, 24).contains("_")) {
            return catalogFileName.substring(0, 24);
        }
        if (catalogFileName.length() >= 16 && !catalogFileName.substring(0, 16).contains("_")) {
            return catalogFileName.substring(0, 16);
        }
        if (catalogFileName.length() >= 8 && !catalogFileName.substring(0, 8).contains("_")) {
            return catalogFileName.substring(0, 8);
        }
        pos = catalogFileName.lastIndexOf(95);
        if (pos < 0) {
            return "";
        }
        return catalogFileName.substring(0, pos);
    }

    public File storeCatalogFileInSubfolder(String catalogFileName) {
        String folderName = this.mapOfCatalogFolderNames.get(catalogFileName);
        if (folderName == null) {
            folderName = this.getFolderName(catalogFileName);
            File folder = new File(this.getCatalogFolder(), folderName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        this.mapOfCatalogFolderNames.put(catalogFileName, folderName);
        File result = new File(new File(this.getCatalogFolder(), folderName), catalogFileName);
        return result;
    }

    public boolean addBookEntryFile(File bookEntry) {
        if (this.bookEntriesFiles.contains(bookEntry)) {
            return false;
        }
        this.bookEntriesFiles.add(bookEntry);
        return true;
    }
}

