/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.cache.CachedFile;
import com.gmail.dpierron.calibre.cache.CachedFileManager;
import com.gmail.dpierron.calibre.configuration.DeviceMode;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.database.DatabaseManager;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.opds.AllBooksSubCatalog;
import com.gmail.dpierron.calibre.opds.AuthorsSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.CatalogCallbackInterface;
import com.gmail.dpierron.calibre.opds.CatalogContext;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.RatingsSubCatalog;
import com.gmail.dpierron.calibre.opds.RecentBooksSubCatalog;
import com.gmail.dpierron.calibre.opds.RemoveFilteredOutBooks;
import com.gmail.dpierron.calibre.opds.SeriesSubCatalog;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.TagSubCatalog;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class Catalog {
    private static final String TROOK_FOLDER_EXTENSION = ".library";
    final String catalogFolderName = StanzaConfiguration.INSTANCE.getCatalogFolderName();
    private File destinationFolder;
    private CatalogCallbackInterface callback;

    public Catalog() {
    }

    public Catalog(CatalogCallbackInterface callback) {
        this();
        this.callback = callback;
        CatalogContext.INSTANCE.setCallback(callback);
    }

    private void merge(File src, File dst, boolean checkDates) throws IOException {
        if (src == null || dst == null) {
            return;
        }
        if (!src.exists()) {
            return;
        }
        CatalogContext.INSTANCE.getCallback().incPosition();
        if (src.isDirectory()) {
            if (!dst.exists()) {
                dst.mkdirs();
            }
            if (!dst.isDirectory()) {
                return;
            }
            File[] sourceFiles = src.listFiles();
            Vector<File> targetNotInSourceFiles = new Vector<File>(Arrays.asList(dst.listFiles()));
            for (int i = 0; i < sourceFiles.length; ++i) {
                File sourceFile = sourceFiles[i];
                String fileName = sourceFile.getName();
                File destFile = new File(dst, fileName);
                if (destFile.exists()) {
                    targetNotInSourceFiles.remove(destFile);
                }
                this.merge(sourceFile, destFile, checkDates);
            }
            for (File file : targetNotInSourceFiles) {
                Helper.delete((File)file);
            }
        } else {
            boolean copy = false;
            if (!dst.exists()) {
                copy = true;
            } else if (checkDates && src.lastModified() > dst.lastModified()) {
                copy = true;
            }
            if (copy) {
                Helper.copy((File)src, (File)dst);
            }
        }
    }

    private Element getAboutEntry() {
        String title = Localization.Main.getText("about.title", "calibre2opds 2.3 cr1");
        String urn = "urn:calibre2opds:about";
        String url = "http://wiki.mobileread.com/wiki/Calibre2opds";
        String summary = Localization.Main.getText("about.summary");
        return FeedHelper.INSTANCE.getAtomElement("entry", title, urn, url, "text/html", summary, true, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAIAAAAC64paAAAACXBIWXMAAA7EAAAOxAGVKw4bAAACm0lEQVR4nIXQzW5cRRAF4FM/1+OYQGRkIiVSBEKCp2bLNnt4gzwCwow8TiY4ZDz2/N6+3V11WCALBAZqV6X6Skcll2++g5ioA8hMZCp79HbY3fexMDtUTM1MBxc1U5+Jm+ugOjhJIIUBgSqIZKeCyOi1kCEQqFAV7jqYZ1iehJNOV4IiAIQiCBCdEEJFeqsRQUJV3DSiDeEYPJPOkAwHRZlIFQpBgC7SQTWN3murSIog1OhGr9HdMxgDh3AlCCDxRwJJAgChCiWzNERCmAaYh6c3zT7LYeg2eEYoVCRFJJMkIoJsoPTsUzmQAGiKSrjSzNxGMxWKc2r0gQYIyCSS0RmhQQPGXUmhCIShSQPVFJFouVpuvW7uTp48hamoEIgMsEc2RrgNdSyZCWS0BEJAtqy7cvXzZr7c+g/fvz775NOLF188//Ll+cV5KBQMBBCDShlL60FmtGBEtDjeHq9+2S/24y7Sf3zz3lzOTi4/P/OvXp1/8+2rF1+/tNNBjBG91nbYFQh6773k4fa4fHdcjOUIHAC7mM1qz2PNu0OfL7fz+c36+tcng5ydWtTpw7v1arVtpZdD3d6Vt8vjfJzuyZsaq9rs+elJJ8eIffQScWi5XI+Lq4+OfPbU16vt4u19rbHft9WqXh7Lx+RvtU+ZENpsNowZEwiFqwZYIvY159dr7/HZTH5arKca+31cHab3PTY1KIQQgMlgEzmSh+Smc5fZhRRU4vpm92zmN7fHXYnNxEWr25YpAAgAgNngQQSZZCI7OSYPmSmAyO3dKORuyg8R656BPyUA50PzMCOATqxbL2RNPQUSWPfs5F8lAMe/19gSg2hSgCn/Lv8HU1h6mGhkUB5Z+C8MIIhEAgQe0Y5Hbz7Uw2v1H5EB4HcxBixwKNtXgQAAAABJRU5ErkJggg==");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMainCatalog() throws IOException {
        File targetCatalogFolder;
        String[] resources;
        CachedFileManager.INSTANCE.initialize();
        CatalogContext.INSTANCE.initialize();
        CatalogContext.INSTANCE.setCallback(this.callback);
        File calibreLibraryFolder = StanzaConfiguration.INSTANCE.getDatabaseFolder();
        if (!DatabaseManager.INSTANCE.databaseExists()) {
            CatalogContext.INSTANCE.getCallback().errorOccured(Localization.Main.getText("error.nodatabase", calibreLibraryFolder), null);
            return;
        }
        File temp = File.createTempFile("calibre2opds", "");
        String tempPath = temp.getAbsolutePath();
        temp.delete();
        this.destinationFolder = new File(tempPath);
        if (StanzaConfiguration.INSTANCE.getDeviceMode() == DeviceMode.Nook) {
            this.destinationFolder = new File(this.destinationFolder, StanzaConfiguration.INSTANCE.getCatalogFolderName() + TROOK_FOLDER_EXTENSION);
        }
        this.destinationFolder.mkdirs();
        CatalogContext.INSTANCE.getCatalogManager().setDestinationFolder(this.destinationFolder);
        CatalogContext.INSTANCE.getCallback().dumpOptions();
        CatalogContext.INSTANCE.getCallback().startReadDatabase();
        long now = System.currentTimeMillis();
        DataModel.INSTANCE.reset();
        RemoveFilteredOutBooks.INSTANCE.runOnDataModel();
        List<Book> books = DataModel.INSTANCE.getListOfBooks();
        if (Helper.isNullOrEmpty(books)) {
            return;
        }
        DataModel.INSTANCE.preloadDataModel();
        CatalogContext.INSTANCE.getCallback().endReadDatabase(System.currentTimeMillis() - now);
        String filename = SecureFileManager.INSTANCE.encode("catalog.xml");
        File outputFile = new File(CatalogContext.INSTANCE.getCatalogManager().getCatalogFolder(), filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            Element entry;
            fos = new FileOutputStream(outputFile);
            String title = Localization.Main.getText("home.title");
            String urn = "calibre:catalog";
            String summary = Localization.Main.getText("main.summary", "calibre2opds 2.3 cr1", Summarizer.INSTANCE.getBookWord(books.size()));
            Element main = FeedHelper.INSTANCE.getFeed(title, urn, summary);
            Breadcrumbs breadcrumbs = Breadcrumbs.newBreadcrumbs(title, "../" + filename);
            if (StanzaConfiguration.INSTANCE.getIncludeAboutLink() && (entry = this.getAboutEntry()) != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().startCreateAuthors();
            now = System.currentTimeMillis();
            entry = new AuthorsSubCatalog(books).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateAuthors(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateTags();
            now = System.currentTimeMillis();
            entry = TagSubCatalog.getTagSubCatalog(books).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateTags(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateSeries();
            now = System.currentTimeMillis();
            entry = new SeriesSubCatalog(books).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateSeries(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateRecent();
            now = System.currentTimeMillis();
            entry = new RecentBooksSubCatalog(books).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateRecent(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateRated();
            now = System.currentTimeMillis();
            if (StanzaConfiguration.INSTANCE.generateRatings() && (entry = new RatingsSubCatalog(books).getSubCatalogEntry(breadcrumbs)) != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateRated(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateAllbooks();
            now = System.currentTimeMillis();
            if (StanzaConfiguration.INSTANCE.generateAllbooks() && (entry = new AllBooksSubCatalog(books).getSubCatalogEntry(breadcrumbs)) != null) {
                main.addContent((Content)entry);
            }
            CatalogContext.INSTANCE.getCallback().endCreateAllbooks(System.currentTimeMillis() - now);
            CatalogContext.INSTANCE.getCallback().startCreateThumbnails();
            now = System.currentTimeMillis();
            CatalogContext.INSTANCE.getThumbnailManager().generateThumbnails();
            CatalogContext.INSTANCE.getCallback().endCreateThumbnails(System.currentTimeMillis() - now);
            document.addContent((Content)main);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        CatalogContext.INSTANCE.getHtmlManager().generateHtmlFromXml(document, outputFile, true);
        for (String resource : resources = new String[]{"catalog.css", "oval-red-left.gif", "oval-red-right.gif", "bg_button_a.gif", "bg_button_span.gif", "bc_bg.png", "bc_separator.png", "home.png", "default_thumbnail.png"}) {
            File resourceFile = new File(this.destinationFolder, CatalogContext.INSTANCE.getCatalogManager().getCatalogFolderName() + "/" + resource);
            InputStream resourceStream = JDOM.class.getResourceAsStream(resource);
            Helper.copy((InputStream)resourceStream, (File)resourceFile);
        }
        long maxScale = 0L;
        if (StanzaConfiguration.INSTANCE.getTargetFolder() != null) {
            maxScale += Helper.count((File)CatalogContext.INSTANCE.getCatalogManager().getCatalogFolder());
        }
        if (StanzaConfiguration.INSTANCE.getCopyToDatabaseFolder()) {
            maxScale += Helper.count((File)CatalogContext.INSTANCE.getCatalogManager().getCatalogFolder());
        }
        if (StanzaConfiguration.INSTANCE.getTargetFolder() != null) {
            maxScale += (long)CatalogContext.INSTANCE.getCatalogManager().getListOfFilesPathsToCopy().size();
        }
        CatalogContext.INSTANCE.getCallback().setMaxScale(maxScale);
        CatalogContext.INSTANCE.getCallback().startCopyLibToTarget();
        if (StanzaConfiguration.INSTANCE.getTargetFolder() != null) {
            File targetFolder = StanzaConfiguration.INSTANCE.getTargetFolder();
            if (StanzaConfiguration.INSTANCE.getDeviceMode() == DeviceMode.Nook) {
                targetFolder = new File(targetFolder, StanzaConfiguration.INSTANCE.getCatalogFolderName() + TROOK_FOLDER_EXTENSION);
            }
            now = System.currentTimeMillis();
            for (String pathToCopy : CatalogContext.INSTANCE.getCatalogManager().getListOfFilesPathsToCopy()) {
                CachedFile sourceFile = CachedFile.getCachedFile(StanzaConfiguration.INSTANCE.getDatabaseFolder(), pathToCopy);
                CachedFile targetFile = CachedFile.getCachedFile(targetFolder, pathToCopy);
                this.merge(sourceFile, targetFile, true);
            }
            TreeSet<File> usefulTargetFiles = new TreeSet<File>();
            Vector<String> sourceFiles = new Vector<String>(CatalogContext.INSTANCE.getCatalogManager().getListOfFilesPathsToCopy());
            for (String sourceFile : sourceFiles) {
                for (File targetFile = new File(targetFolder, sourceFile); targetFile != null; targetFile = targetFile.getParentFile()) {
                    usefulTargetFiles.add(targetFile);
                }
            }
            ArrayList existingTargetFiles = Helper.listFilesIn((File)targetFolder);
            String targetCatalogFolderPath = new File(targetFolder, CatalogContext.INSTANCE.getCatalogManager().getCatalogFolderName()).getAbsolutePath();
            String calibreFolderPath = StanzaConfiguration.INSTANCE.getDatabaseFolder().getAbsolutePath();
            for (File existingTargetFile : existingTargetFiles) {
                if (usefulTargetFiles.contains(existingTargetFile) || existingTargetFile.getAbsolutePath().startsWith(targetCatalogFolderPath) || existingTargetFile.getAbsolutePath().startsWith(calibreFolderPath)) continue;
                Helper.delete((File)existingTargetFile);
            }
        }
        CatalogContext.INSTANCE.getCallback().endCopyLibToTarget(System.currentTimeMillis() - now);
        CatalogContext.INSTANCE.getCallback().startCopyCatToTarget();
        now = System.currentTimeMillis();
        if (StanzaConfiguration.INSTANCE.getTargetFolder() != null) {
            File targetFolder = StanzaConfiguration.INSTANCE.getTargetFolder();
            if (StanzaConfiguration.INSTANCE.getDeviceMode() == DeviceMode.Nook) {
                targetFolder = new File(targetFolder, StanzaConfiguration.INSTANCE.getCatalogFolderName() + TROOK_FOLDER_EXTENSION);
            }
            targetCatalogFolder = new File(targetFolder, CatalogContext.INSTANCE.getCatalogManager().getCatalogFolderName());
            this.merge(CatalogContext.INSTANCE.getCatalogManager().getCatalogFolder(), targetCatalogFolder, true);
        }
        if (StanzaConfiguration.INSTANCE.getCopyToDatabaseFolder()) {
            File targetFolder = StanzaConfiguration.INSTANCE.getDatabaseFolder();
            targetCatalogFolder = new File(targetFolder, CatalogContext.INSTANCE.getCatalogManager().getCatalogFolderName());
            this.merge(CatalogContext.INSTANCE.getCatalogManager().getCatalogFolder(), targetCatalogFolder, true);
        }
        Helper.delete((File)this.destinationFolder);
        CatalogContext.INSTANCE.getCallback().endCopyCatToTarget(System.currentTimeMillis() - now);
        SecureFileManager.INSTANCE.save();
        String where = null;
        if (StanzaConfiguration.INSTANCE.getDeviceMode() == DeviceMode.Nook) {
            where = Localization.Main.getText("info.step.done.nook");
        } else if (StanzaConfiguration.INSTANCE.getTargetFolder() != null) {
            where = StanzaConfiguration.INSTANCE.getTargetFolder().getAbsolutePath();
        }
        if (StanzaConfiguration.INSTANCE.getCopyToDatabaseFolder()) {
            where = where != null ? where + " " + Localization.Main.getText("info.step.done.andYourDb") : StanzaConfiguration.INSTANCE.getDatabaseFolder().getAbsolutePath();
        }
        if (where == null) {
            where = outputFile.getParent();
        }
        CatalogContext.INSTANCE.getCallback().endCreateMainCatalog(where, CatalogContext.INSTANCE.getHtmlManager().getTimeInHtml());
    }
}

