/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.cache.CachedFile;
import com.gmail.dpierron.calibre.configuration.CompatibilityTrick;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.DateRange;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.SubCatalog;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.i18n.LocalizationHelper;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooksSubCatalog
extends SubCatalog {
    private static final DateFormat PUBLICATIONDATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private static final Logger logger = Logger.getLogger(BooksSubCatalog.class);

    public BooksSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public BooksSubCatalog(List<Book> books) {
        super(books);
    }

    void sortBooksByTitle(List<Book> books) {
        Collections.sort(books, new Comparator<Book>(){

            @Override
            public int compare(Book o1, Book o2) {
                String title1 = o1 == null ? "" : o1.getTitleForSort(StanzaConfiguration.INSTANCE.getBookLanguageTag());
                String title2 = o2 == null ? "" : o2.getTitleForSort(StanzaConfiguration.INSTANCE.getBookLanguageTag());
                return title1.compareTo(title2);
            }
        });
    }

    Element getListOfBooks(Breadcrumbs pBreadcrumbs, List<Book> books, int from, String pTitle, String summary, String urn, String pFilename, SplitOption splitOption, String icon, Option ... options) throws IOException {
        return this.getListOfBooks(pBreadcrumbs, books, from, pTitle, summary, urn, pFilename, splitOption, icon, (List<Element>)null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element getListOfBooks(Breadcrumbs pBreadcrumbs, List<Book> books, int from, String title, String summary, String urn, String pFilename, SplitOption splitOption, String icon, List<Element> firstElements, Option ... options) throws IOException {
        Element entry;
        boolean willSplitByDate;
        int catalogSize = books.size();
        Map<String, List<Book>> mapOfBooksByLetter = null;
        Map<DateRange, List<Book>> mapOfBooksByDate = null;
        boolean willSplitByLetter = splitOption != SplitOption.Paginate && catalogSize > StanzaConfiguration.INSTANCE.getMaxBeforeSplit() && !StanzaConfiguration.INSTANCE.getBrowseByCoverWithoutSplit();
        boolean bl = willSplitByDate = splitOption == SplitOption.SplitByDate;
        if (logger.isDebugEnabled()) {
            logger.debug("listing books from=" + from + ", title=" + title);
        }
        if (willSplitByDate) {
            if (logger.isDebugEnabled()) {
                logger.debug("splitting list of books by date");
            }
            mapOfBooksByDate = DataModel.splitBooksByDate(books);
            catalogSize = 0;
        } else if (willSplitByLetter) {
            if (logger.isDebugEnabled()) {
                logger.debug("splitting list of books by letter");
            }
            mapOfBooksByLetter = DataModel.splitBooksByLetter(books, StanzaConfiguration.INSTANCE.getBookLanguageTag());
            catalogSize = 0;
        }
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        int maxPages = Summarizer.INSTANCE.getPageNumber(catalogSize);
        String filename = SecureFileManager.INSTANCE.decode(pFilename);
        if (from > 0) {
            int pos = filename.lastIndexOf(".xml");
            if (pos >= 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + "_" + pageNumber;
        }
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        filename = SecureFileManager.INSTANCE.encode(filename);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            List<Object> result;
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            if (willSplitByDate) {
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                result = this.getListOfBooksSplitByDate(breadcrumbs, mapOfBooksByDate, title, urn, pFilename, SplitOption.Paginate, icon, options);
            } else if (willSplitByLetter) {
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                result = this.getListOfBooksSplitByLetter(breadcrumbs, mapOfBooksByLetter, title, urn, pFilename, null, icon, options);
            } else {
                result = new Vector();
                for (int i = from; i < books.size(); ++i) {
                    Breadcrumbs breadcrumbs;
                    Element entry2;
                    if (i - from >= StanzaConfiguration.INSTANCE.getMaxBeforePaginate()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("making a nextpage link");
                        }
                        Element nextLink = this.getListOfBooks(pBreadcrumbs, books, i, title, summary, urn, pFilename, splitOption, icon, options);
                        result.add(nextLink);
                        break;
                    }
                    Book book = books.get(i);
                    if (logger.isTraceEnabled()) {
                        logger.trace("adding book to the list : " + book);
                    }
                    if ((entry2 = this.getBookEntry(breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename)), book, options)) == null) continue;
                    result.add(entry2);
                }
            }
            if (Helper.isNotNullOrEmpty(firstElements)) {
                feed.addContent(firstElements);
            }
            feed.addContent(result);
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        if (from > 0) {
            String titleNext = pageNumber != maxPages ? Localization.Main.getText("title.nextpage", pageNumber, maxPages) : Localization.Main.getText("title.lastpage");
            entry = FeedHelper.INSTANCE.getNext(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename), titleNext);
        } else {
            entry = FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, icon);
        }
        return entry;
    }

    private List<Element> getListOfBooksSplitByLetter(Breadcrumbs pBreadcrumbs, Map<String, List<Book>> mapOfBooksByLetter, String baseTitle, String baseUrn, String baseFilename, SplitOption splitOption, String icon, Option ... options) throws IOException {
        if (Helper.isNullOrEmpty(mapOfBooksByLetter)) {
            return null;
        }
        String sTitle = baseTitle;
        if (Helper.isNotNullOrEmpty((Object)sTitle)) {
            sTitle = sTitle + ", ";
        }
        Vector<Element> result = new Vector<Element>(mapOfBooksByLetter.keySet().size());
        TreeSet<String> letters = new TreeSet<String>(mapOfBooksByLetter.keySet());
        for (String letter : letters) {
            String baseFilenameCleanedUp = SecureFileManager.INSTANCE.decode(baseFilename);
            int pos = baseFilenameCleanedUp.indexOf(".xml");
            if (pos > -1) {
                baseFilenameCleanedUp = baseFilenameCleanedUp.substring(0, pos);
            }
            String letterFilename = baseFilenameCleanedUp + "_" + letter + ".xml";
            letterFilename = SecureFileManager.INSTANCE.encode(letterFilename);
            String letterUrn = baseUrn + ":" + letter;
            List<Book> booksInThisLetter = mapOfBooksByLetter.get(letter);
            String letterTitle = letter.equals("_") ? Localization.Main.getText("splitByLetter.book.other") : Localization.Main.getText("splitByLetter.letter", Localization.Main.getText("bookword.title"), letter);
            String summary = Summarizer.INSTANCE.summarizeBooks(booksInThisLetter);
            Element element = null;
            if (booksInThisLetter.size() > 0) {
                element = this.getListOfBooks(pBreadcrumbs, booksInThisLetter, 0, letterTitle, summary, letterUrn, letterFilename, SplitOption.Paginate, icon, options);
            }
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private List<Element> getListOfBooksSplitByDate(Breadcrumbs pBreadcrumbs, Map<DateRange, List<Book>> mapOfBooksByDate, String baseTitle, String baseUrn, String baseFilename, SplitOption splitOption, String icon, Option ... options) throws IOException {
        if (Helper.isNullOrEmpty(mapOfBooksByDate)) {
            return null;
        }
        String sTitle = baseTitle;
        if (Helper.isNotNullOrEmpty((Object)sTitle)) {
            sTitle = sTitle + ", ";
        }
        Vector<Element> result = new Vector<Element>(mapOfBooksByDate.keySet().size());
        TreeSet<DateRange> ranges = new TreeSet<DateRange>(mapOfBooksByDate.keySet());
        for (DateRange range : ranges) {
            String rangeFilenameCleanedUp = SecureFileManager.INSTANCE.decode(baseFilename);
            int pos = rangeFilenameCleanedUp.indexOf(".xml");
            if (pos > -1) {
                rangeFilenameCleanedUp = rangeFilenameCleanedUp.substring(0, pos);
            }
            String rangeFilename = rangeFilenameCleanedUp + "_" + (Object)((Object)range) + ".xml";
            rangeFilename = SecureFileManager.INSTANCE.encode(rangeFilename);
            String rangeUrn = baseUrn + ":" + (Object)((Object)range);
            String rangeTitle = range == DateRange.ONEDAY ? DateFormat.getDateInstance(2).format(new Date()) : LocalizationHelper.INSTANCE.getEnumConstantHumanName(range);
            List<Book> booksInThisRange = mapOfBooksByDate.get((Object)range);
            String summary = Summarizer.INSTANCE.summarizeBooks(booksInThisRange);
            Element element = null;
            if (booksInThisRange.size() > 0) {
                element = this.getListOfBooks(pBreadcrumbs, booksInThisRange, 0, rangeTitle, summary, rangeUrn, rangeFilename, splitOption, icon, options);
            }
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getBookEntry(Breadcrumbs pBreadcrumbs, Book book, Option ... options) throws IOException {
        String filename = "book_" + book.getId() + ".xml";
        String title = Option.contains(options, Option.INCLUDE_SERIE_NUMBER) ? book.getTitleWithSerieNumber() : (Option.contains(options, Option.INCLUDE_TIMESTAMP) ? book.getTitleWithTimestamp() : (!Option.contains(options, Option.DONOTINCLUDE_RATING) && !StanzaConfiguration.INSTANCE.suppressRatingsInTitles() ? book.getTitleWithRating(Localization.Main.getText("bookentry.rated"), LocalizationHelper.INSTANCE.getEnumConstantHumanName(book.getRating())) : book.getTitle()));
        String urn = "calibre:book:" + book.getId();
        String summary = book.getShortComment(StanzaConfiguration.INSTANCE.getMaxSummaryLength());
        filename = SecureFileManager.INSTANCE.encode(filename);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        if (this.getCatalogManager().addBookEntryFile(outputFile)) {
            FileOutputStream fos = null;
            Document document = new Document();
            try {
                fos = new FileOutputStream(outputFile);
                Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
                feed.addContent((Content)this.getBookFullEntry(book));
                document.addContent((Content)feed);
                JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        }
        String trueFilename = this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename);
        Element result = FeedHelper.INSTANCE.getAtomElement("entry", title, urn, null, null, null, null, false, null);
        result.addContent((Content)FeedHelper.INSTANCE.getUpdatedTag(book.getLatestFileModifiedDate()));
        if (book.hasAuthor()) {
            Element author = JDOM.INSTANCE.element("author").addContent((Content)JDOM.INSTANCE.element("name").addContent(book.getListOfAuthors())).addContent((Content)JDOM.INSTANCE.element("uri").addContent("author_" + book.getMainAuthor().getId() + ".xml"));
            result.addContent((Content)author);
        }
        if (Helper.isNotNullOrEmpty((Object)book.getListOfAuthors())) {
            Element summaryElement = JDOM.INSTANCE.element("summary").addContent(book.getListOfAuthors());
            result.addContent((Content)summaryElement);
        }
        boolean includeCover = StanzaConfiguration.INSTANCE.getCompatibilityTrick() != CompatibilityTrick.ALDIKO;
        this.addCoverLink(book, result, includeCover);
        result.addContent((Content)FeedHelper.INSTANCE.getFullEntryLinkElement(trueFilename));
        if (StanzaConfiguration.INSTANCE.getCompatibilityTrick() == CompatibilityTrick.STANZA) {
            result.addContent((Content)FeedHelper.INSTANCE.getFullEntryStanzaLinkElement(trueFilename));
        }
        return result;
    }

    private Element getBookFullEntry(Book book) {
        String data;
        Element entry = JDOM.INSTANCE.element("entry");
        String sTitle = book.getTitle();
        Element title = JDOM.INSTANCE.element("title").addContent(sTitle);
        entry.addContent((Content)title);
        Element id = JDOM.INSTANCE.element("id").addContent("urn:book:" + book.getUuid());
        entry.addContent((Content)id);
        if (book.hasAuthor()) {
            Element author = JDOM.INSTANCE.element("author").addContent((Content)JDOM.INSTANCE.element("name").addContent(book.getListOfAuthors())).addContent((Content)JDOM.INSTANCE.element("uri").addContent("author_" + book.getMainAuthor().getId() + ".xml"));
            entry.addContent((Content)author);
        }
        Element updated = FeedHelper.INSTANCE.getUpdatedTag(book.getLatestFileModifiedDate());
        entry.addContent((Content)updated);
        Element content = JDOM.INSTANCE.element("content").setAttribute("type", "text/html");
        boolean hasContent = false;
        if (Helper.isNotNullOrEmpty(book.getTags())) {
            content.addContent((Content)JDOM.INSTANCE.element("strong").addContent(Localization.Main.getText("content.tags"))).addContent(Helper.concatenateList((String)", ", book.getTags())).addContent((Content)JDOM.INSTANCE.element("br"));
            hasContent = true;
        }
        if (Helper.isNotNullOrEmpty((Object)book.getSeries())) {
            data = Localization.Main.getText("content.series.data", book.getSerieIndex(), book.getSeries().getName());
            content.addContent((Content)JDOM.INSTANCE.element("strong").addContent(Localization.Main.getText("content.series"))).addContent(data).addContent((Content)JDOM.INSTANCE.element("br"));
            hasContent = true;
        }
        if (Helper.isNotNullOrEmpty((Object)book.getPublisher())) {
            data = Localization.Main.getText("content.publisher.data", book.getPublisher().getName(), PUBLICATIONDATE_FORMAT.format(book.getPublicationDate()));
            content.addContent((Content)JDOM.INSTANCE.element("strong").addContent(Localization.Main.getText("content.publisher"))).addContent(data).addContent((Content)JDOM.INSTANCE.element("br"));
            hasContent = true;
        }
        if (Helper.isNotNullOrEmpty((Object)book.getComment())) {
            content.addContent((Content)JDOM.INSTANCE.element("strong").addContent(Localization.Main.getText("content.summary"))).addContent(book.getComment()).addContent((Content)JDOM.INSTANCE.element("br"));
            hasContent = true;
        }
        if (hasContent) {
            entry.addContent((Content)content);
        }
        if (StanzaConfiguration.INSTANCE.generateDownloads()) {
            for (EBookFile file : book.getFiles()) {
                this.getCatalogManager().addFileToTheMapOfFilesToCopy(file.getFile());
                entry.addContent((Content)FeedHelper.INSTANCE.getLinkElement("../../" + FeedHelper.INSTANCE.urlEncode(book.getPath(), true) + "/" + FeedHelper.INSTANCE.urlEncode(file.getName() + file.getExtension(), true), file.getFormat().getMime(), "http://opds-spec.org/acquisition", Localization.Main.getText("bookentry.download", file.getFormat())));
                if (!StanzaConfiguration.INSTANCE.getIncludeOnlyOneFile()) continue;
                break;
            }
        }
        this.addCoverLink(book, entry, true);
        if (StanzaConfiguration.INSTANCE.generateCrossLinks()) {
            int nbBooks;
            int nbBooks2;
            if (book.getSeries() != null && DataModel.INSTANCE.getMapOfBooksBySerie().get(book.getSeries()).size() > 1) {
                entry.addContent((Content)FeedHelper.INSTANCE.getRelatedXmlLinkElement(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(SecureFileManager.INSTANCE.encode("serie_" + book.getSeries().getId() + ".xml")), Localization.Main.getText("bookentry.series", book.getSerieIndex(), book.getSeries().getName())));
            }
            if (book.hasAuthor()) {
                for (Author author : book.getAuthors()) {
                    nbBooks2 = DataModel.INSTANCE.getMapOfBooksByAuthor().get(author).size();
                    entry.addContent((Content)FeedHelper.INSTANCE.getRelatedXmlLinkElement(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(SecureFileManager.INSTANCE.encode("author_" + author.getId() + ".xml")), Localization.Main.getText("bookentry.author", Summarizer.INSTANCE.getBookWord(nbBooks2), author.getName())));
                }
            }
            if (Helper.isNotNullOrEmpty(book.getTags())) {
                for (Tag tag : book.getTags()) {
                    nbBooks2 = DataModel.INSTANCE.getMapOfBooksByTag().get(tag).size();
                    if (nbBooks2 <= 1) continue;
                    entry.addContent((Content)FeedHelper.INSTANCE.getRelatedXmlLinkElement(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(SecureFileManager.INSTANCE.encode("tag_" + tag.getId() + ".xml")), Localization.Main.getText("bookentry.tags", Summarizer.INSTANCE.getBookWord(nbBooks2), tag.getName())));
                }
            }
            if (StanzaConfiguration.INSTANCE.generateRatings() && book.getRating() != BookRating.NOTRATED && (nbBooks = DataModel.INSTANCE.getMapOfBooksByRating().get((Object)book.getRating()).size()) > 1) {
                entry.addContent((Content)FeedHelper.INSTANCE.getRelatedXmlLinkElement(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(SecureFileManager.INSTANCE.encode("rated_" + book.getRating().getId() + ".xml")), Localization.Main.getText("bookentry.ratings", Summarizer.INSTANCE.getBookWord(nbBooks), LocalizationHelper.INSTANCE.getEnumConstantHumanName(book.getRating()))));
            }
        }
        if (StanzaConfiguration.INSTANCE.generateExternalLinks()) {
            if (Helper.isNotNullOrEmpty((Object)book.getIsbn())) {
                entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://www.goodreads.com/book/isbn/{0}", book.getIsbn()), Localization.Main.getText("bookentry.goodreads")));
                entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://www.goodreads.com/review/isbn/{0}", book.getIsbn()), Localization.Main.getText("bookentry.goodreads.review")));
            } else {
                entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://www.goodreads.com/book/title/{0}", book.getIsbn()), Localization.Main.getText("bookentry.goodreads")));
            }
            if (book.hasAuthor()) {
                for (Author author : book.getAuthors()) {
                    entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://www.goodreads.com/book/author/{0}", FeedHelper.INSTANCE.urlEncode(author.getName())), Localization.Main.getText("bookentry.goodreads.author", author.getName())));
                }
            }
            entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://{0}.wikipedia.org/wiki/{1}", StanzaConfiguration.INSTANCE.getWikipediaLanguage(), FeedHelper.INSTANCE.urlEncode(book.getTitle())), Localization.Main.getText("bookentry.wikipedia")));
            if (book.hasAuthor()) {
                for (Author author : book.getAuthors()) {
                    entry.addContent((Content)FeedHelper.INSTANCE.getRelatedHtmlLinkElement(MessageFormat.format("http://{0}.wikipedia.org/wiki/{1}", StanzaConfiguration.INSTANCE.getWikipediaLanguage(), FeedHelper.INSTANCE.urlEncode(author.getName())), Localization.Main.getText("bookentry.wikipedia.author", author.getName())));
                }
            }
        }
        return entry;
    }

    private void addCoverLink(Book book, Element entry, boolean includeCover) {
        CachedFile coverFile = CachedFile.getCachedFile(book.getBookFolder(), "cover.jpg");
        if (coverFile.exists()) {
            this.getCatalogManager().addFileToTheMapOfFilesToCopy(coverFile);
            if (includeCover) {
                entry.addContent((Content)FeedHelper.INSTANCE.getLinkElement("../../" + FeedHelper.INSTANCE.urlEncode(book.getPath(), true) + "/cover.jpg", "image/jpeg", "http://opds-spec.org/cover", null));
            }
            String thumbnailUri = this.getThumbnailManager().getThumbnailUri(book);
            entry.addContent((Content)FeedHelper.INSTANCE.getLinkElement(thumbnailUri, "image/jpeg", "http://opds-spec.org/thumbnail", null));
            CachedFile thumbnailFile = CachedFile.getCachedFile(book.getBookFolder(), this.getThumbnailManager().getThumbnailFilename(book));
            this.getCatalogManager().addFileToTheMapOfFilesToCopy(thumbnailFile);
            if (!thumbnailFile.exists() || this.getThumbnailManager().hasThumbnailSizeChanged() || thumbnailFile.lastModified() < coverFile.lastModified()) {
                this.getThumbnailManager().setThumbnailToGenerate(thumbnailFile, coverFile);
            }
        }
    }
}

