/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.opds.AllBooksSubCatalog;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.FeedHelper;
import com.gmail.dpierron.calibre.opds.JDOM;
import com.gmail.dpierron.calibre.opds.SeriesSubCatalog;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.Summarizer;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorsSubCatalog
extends BooksSubCatalog {
    private List<Author> authors;
    private Map<Author, List<Book>> mapOfBooksByAuthor;
    private Map<Author, List<Series>> mapOfSeriesByAuthor;
    private Map<Author, List<Book>> mapOfBooksNotInSerieByAuthor;

    public AuthorsSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
    }

    public AuthorsSubCatalog(List<Book> books) {
        super(books);
    }

    List<Author> getAuthors() {
        if (this.authors == null) {
            this.authors = new Vector<Author>();
            for (Book book : this.getBooks()) {
                for (Author author : book.getAuthors()) {
                    if (this.authors.contains(author)) continue;
                    this.authors.add(author);
                }
            }
            Collections.sort(this.authors, new Comparator<Author>(){

                @Override
                public int compare(Author o1, Author o2) {
                    String name1 = o1 == null ? "" : o1.getNameForSort();
                    String name2 = o2 == null ? "" : o2.getNameForSort();
                    return name1.compareTo(name2);
                }
            });
        }
        return this.authors;
    }

    public Map<Author, List<Book>> getMapOfBooksByAuthor() {
        if (this.mapOfBooksByAuthor == null) {
            this.mapOfBooksByAuthor = new HashMap<Author, List<Book>>();
            for (Book book : this.getBooks()) {
                for (Author author : book.getAuthors()) {
                    List<Book> books = this.mapOfBooksByAuthor.get(author);
                    if (books == null) {
                        books = new Vector<Book>();
                        this.mapOfBooksByAuthor.put(author, books);
                    }
                    books.add(book);
                }
            }
        }
        return this.mapOfBooksByAuthor;
    }

    public Map<Author, List<Series>> getMapOfSeriesByAuthor() {
        if (this.mapOfSeriesByAuthor == null) {
            this.computeMapOfSeriesByAuthor();
        }
        return this.mapOfSeriesByAuthor;
    }

    public Map<Author, List<Book>> getMapOfBooksNotInSeriesByAuthor() {
        if (this.mapOfBooksNotInSerieByAuthor == null) {
            this.computeMapOfSeriesByAuthor();
        }
        return this.mapOfBooksNotInSerieByAuthor;
    }

    private void computeMapOfSeriesByAuthor() {
        this.mapOfSeriesByAuthor = new HashMap<Author, List<Series>>();
        this.mapOfBooksNotInSerieByAuthor = new HashMap<Author, List<Book>>();
        for (Book book : this.getBooks()) {
            for (Author author : book.getAuthors()) {
                Series serie = book.getSeries();
                if (serie != null) {
                    List<Series> series = this.mapOfSeriesByAuthor.get(author);
                    if (series == null) {
                        series = new Vector<Series>();
                        this.mapOfSeriesByAuthor.put(author, series);
                    }
                    if (series.contains(serie)) continue;
                    series.add(serie);
                    continue;
                }
                List<Book> books = this.mapOfBooksNotInSerieByAuthor.get(author);
                if (books == null) {
                    books = new Vector<Book>();
                    this.mapOfBooksNotInSerieByAuthor.put(author, books);
                }
                if (books.contains(book)) continue;
                books.add(book);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getListOfAuthors(Breadcrumbs pBreadcrumbs, List<Author> authors, int from, String title, String summary, String urn, String pFilename, SplitOption splitOption) throws IOException {
        Element entry;
        int catalogSize;
        boolean willSplit;
        Map<String, List<Author>> mapOfAuthorsByLetter = null;
        boolean bl = willSplit = splitOption != SplitOption.Paginate && authors.size() > StanzaConfiguration.INSTANCE.getMaxBeforeSplit();
        if (willSplit) {
            mapOfAuthorsByLetter = DataModel.splitAuthorsByLetter(authors);
            catalogSize = 0;
        } else {
            catalogSize = authors.size();
        }
        int pageNumber = Summarizer.INSTANCE.getPageNumber(from + 1);
        int maxPages = Summarizer.INSTANCE.getPageNumber(catalogSize);
        String filename = SecureFileManager.INSTANCE.decode(pFilename);
        if (from > 0) {
            int pos = filename.lastIndexOf(".xml");
            if (pos >= 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + "_" + pageNumber;
        }
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        filename = SecureFileManager.INSTANCE.encode(filename);
        File outputFile = this.getCatalogManager().storeCatalogFileInSubfolder(filename);
        FileOutputStream fos = null;
        Document document = new Document();
        try {
            List<Object> result;
            fos = new FileOutputStream(outputFile);
            Element feed = FeedHelper.INSTANCE.getFeed(pBreadcrumbs, title, urn, summary);
            if (willSplit) {
                Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                result = this.getListOfAuthorsSplitByLetter(breadcrumbs, mapOfAuthorsByLetter, title, urn, pFilename);
            } else {
                result = new Vector();
                for (int i = from; i < authors.size(); ++i) {
                    if (i - from >= StanzaConfiguration.INSTANCE.getMaxBeforePaginate()) {
                        Element nextLink = this.getListOfAuthors(pBreadcrumbs, authors, i, title, summary, urn, pFilename, splitOption);
                        result.add(nextLink);
                        break;
                    }
                    Author author = authors.get(i);
                    Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
                    Element entry2 = this.getAuthor(breadcrumbs, author, urn);
                    if (entry2 == null) continue;
                    result.add(entry2);
                }
            }
            feed.addContent(result);
            document.addContent((Content)feed);
            JDOM.INSTANCE.getOutputter().output(document, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.getHtmlManager().generateHtmlFromXml(document, outputFile);
        if (from > 0) {
            String titleNext = pageNumber != maxPages ? Localization.Main.getText("title.nextpage", pageNumber, maxPages) : Localization.Main.getText("title.lastpage");
            entry = FeedHelper.INSTANCE.getNext(this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename), titleNext);
        } else {
            entry = FeedHelper.INSTANCE.getEntry(title, urn, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename, pBreadcrumbs.size() > 1), summary, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ3SURBVDjLpZNtSNNRFIcNKunF1rZWBMJqKaSiX9RP1dClsjldA42slW0q5oxZiuHrlqllLayoaJa2jbm1Lc3QUZpKFmmaTMsaRp+kMgjBheSmTL2//kqMBJlFHx44XM7vOfdyuH4A/P6HFQ9zo7cpa/mM6RvCrVDzaVDy6C5JJKv6rwSnIhlFd0R0Up/GwF2KWyl01CTSkM/dQoQRzAurCjRCGnRUUE2FaoSL0HExiYVzsQwcj6RNrSqo4W5Gh6Yc4+1qDDTkIy+GhYK4nTgdz0H2PrrHUJzs71NQn86enPn+CVN9GnzruoYR63mMPbkC59gQzDl7pt7rc9f7FNyUhPY6Bx9gwt4E9zszhWWpdg6ZcS8j3O7zCTuEpnXB+3MNZkUUZu0NmHE8XsL91oSWwiiEc3MeseLrN6woYCWa/Zl8ozyQ3w3Hl2lYy0SwlCUvsVi/Gv2JwITnYPDun2Hy6jYuEzAF1jUBCVYpO6kXo+NuGMeBAgcgfwNkvgBOPgUqXgKvP7rBFvRhE1crp8Vq1noFYSlacVyqGk0D86gbART9BDk9BFnPCNJbCY5aCFL1Cyhtp0RWAp74MsKSrkq9guHyvfMTtmLc1togpZoyqYmyNoITzVTYRJCiXYBIQ3CwFqi83o3JDhX6C0M8XsGIMoQ4OyuRlq1DdZcLkmbgGDX1iIEKNxAcbgTEOqC4ZRaJ6Ub86K7CYFEo8Qo+GBQlQyXBczLZpbloaQ9k1NUz/kD2myBBKxRZpa5hVcQslalatoUxizxAVVrN3CW21bFj9F858Q9dnIRmDyeuybM71uxmH9BNBB1q6zybV7H9s1Ue4PM3/gu/AEbfqfWy2twsAAAAAElFTkSuQmCC");
        }
        return entry;
    }

    private List<Element> getListOfAuthorsSplitByLetter(Breadcrumbs pBreadcrumbs, Map<String, List<Author>> mapOfAuthorsByLetter, String baseTitle, String baseUrn, String baseFilename) throws IOException {
        if (Helper.isNullOrEmpty(mapOfAuthorsByLetter)) {
            return null;
        }
        String sTitle = baseTitle;
        if (Helper.isNotNullOrEmpty((Object)sTitle)) {
            sTitle = sTitle + ", ";
        }
        Vector<Element> result = new Vector<Element>(mapOfAuthorsByLetter.keySet().size());
        TreeSet<String> letters = new TreeSet<String>(mapOfAuthorsByLetter.keySet());
        for (String letter : letters) {
            String baseFilenameCleanedUp = SecureFileManager.INSTANCE.decode(baseFilename);
            int pos = baseFilenameCleanedUp.indexOf(".xml");
            if (pos > -1) {
                baseFilenameCleanedUp = baseFilenameCleanedUp.substring(0, pos);
            }
            String letterFilename = baseFilenameCleanedUp + "_" + letter + ".xml";
            letterFilename = SecureFileManager.INSTANCE.encode(letterFilename);
            String letterUrn = baseUrn + ":" + letter;
            List<Author> authorsInThisLetter = mapOfAuthorsByLetter.get(letter);
            Collections.sort(authorsInThisLetter);
            int itemsCount = authorsInThisLetter.size();
            String letterTitle = letter.equals("_") ? Localization.Main.getText("splitByLetter.author.other") : Localization.Main.getText("splitByLetter.letter", Localization.Main.getText("authorword.title"), letter);
            Element element = null;
            if (itemsCount > 0) {
                String summary = Summarizer.INSTANCE.summarizeAuthors(authorsInThisLetter);
                element = this.getListOfAuthors(pBreadcrumbs, authorsInThisLetter, 0, letterTitle, summary, letterUrn, letterFilename, SplitOption.Paginate);
                if (StanzaConfiguration.INSTANCE.getSplitByAuthorInitialGoToBooks()) {
                    Vector<Book> books = new Vector<Book>();
                    for (Author author : authorsInThisLetter) {
                        books.addAll((Collection)this.getMapOfBooksByAuthor().get(author));
                    }
                    element = this.getListOfBooks(pBreadcrumbs, books, 0, letterTitle, summary, letterUrn, letterFilename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAIASURBVDjLpVPPaxNREJ6Vt01caH4oWk1T0ZKlGIo9RG+BUsEK4kEP/Q8qPXnpqRdPBf8A8Wahhx7FQ0GF9FJ6UksqwfTSBDGyB5HkkphC9tfb7jfbtyQQTx142byZ75v5ZnZWC4KALmICPy+2DkvKIX2f/POz83LxCL7nrz+WPNcll49DrhM9v7xdO9JW330DuXrrqkFSgig5iR2Cfv3t3gNxOnv5BwU+eZ5HuON5/PMPJZKJ+yKQfpW0S7TxdC6WJaWkyvff1LDaFRAeLZj05MHsiPTS6hua0PUqtwC5sHq9zv9RYWl+nu5cETcnJ1M0M5WlWq3GsX6/T+VymRzHDluZiGYAAsw0TQahV8uyyGq1qFgskm0bHIO/1+sx1rFtchJhArwEyIQ1Gg2WD2A6nWawHQJVDIWgIJfLhQowTIeE9D0mKAU8qPC0220afsWFQoH93W6X7yCDJ+DEBeBmsxnPIJVKxWQVUwry+XyUwBlKMKwA8jqdDhOVCqVAzQDVvXAXhOdGBFgymYwrGoZBmUyGjxCCdF0fSahaFdgoTHRxfTveMCXvWfkuE3Y+f40qhgT/nMitupzApdvT18bu+YeDQwY9Xl4aG9/d/URiMBhQq/dvZMeVghtT17lSZW9/rAKsvPa/r9Fc2dw+Pe0/xI6kM9mT5vtXy+Nw2kU/5zOGRpvuMIu0YAAAAABJRU5ErkJggg==", new Option[0]);
                }
            }
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private Element getAuthor(Breadcrumbs pBreadcrumbs, Author author, String baseurn) throws IOException {
        List<Element> firstElements = null;
        List<Book> books = null;
        List<Book> booksByThisAuthor = this.getMapOfBooksByAuthor().get(author);
        if (Helper.isNullOrEmpty(booksByThisAuthor)) {
            return null;
        }
        String basename = "author_";
        String filename = this.getFilenamePrefix(pBreadcrumbs) + basename + author.getId() + ".xml";
        filename = SecureFileManager.INSTANCE.encode(filename);
        String title = author.getSort();
        String urn = baseurn + ":" + author.getId();
        String summary = Summarizer.INSTANCE.summarizeBooks(this.getMapOfBooksByAuthor().get(author));
        boolean areThereSeries = false;
        for (Book book : booksByThisAuthor) {
            if (book.getSeries() == null) continue;
            areThereSeries = true;
            break;
        }
        if (StanzaConfiguration.INSTANCE.getShowSeriesInAuthorCatalog() && areThereSeries) {
            firstElements = new SeriesSubCatalog(this.stuffToFilterOut, this.getMapOfBooksByAuthor().get(author)).getContentOfListOfSeries(pBreadcrumbs, title, summary, urn, filename);
            books = this.getMapOfBooksNotInSeriesByAuthor().get(author);
            if (books == null) {
                books = new Vector<Book>();
            }
            Breadcrumbs breadcrumbs = Breadcrumbs.addBreadcrumb(pBreadcrumbs, title, this.getCatalogManager().getCatalogFileUrlInItsSubfolder(filename));
            Element entry = new AllBooksSubCatalog(this.stuffToFilterOut, this.getMapOfBooksByAuthor().get(author)).getSubCatalogEntry(breadcrumbs);
            if (entry != null) {
                firstElements.add(0, entry);
            }
        } else {
            books = this.getMapOfBooksByAuthor().get(author);
            if (Helper.isNullOrEmpty(books)) {
                return null;
            }
            summary = Summarizer.INSTANCE.summarizeBooks(books);
        }
        this.sortBooksByTitle(books);
        Element result = this.getListOfBooks(pBreadcrumbs, books, 0, title, summary, urn, filename, null, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ3SURBVDjLpZNtSNNRFIcNKunF1rZWBMJqKaSiX9RP1dClsjldA42slW0q5oxZiuHrlqllLayoaJa2jbm1Lc3QUZpKFmmaTMsaRp+kMgjBheSmTL2//kqMBJlFHx44XM7vOfdyuH4A/P6HFQ9zo7cpa/mM6RvCrVDzaVDy6C5JJKv6rwSnIhlFd0R0Up/GwF2KWyl01CTSkM/dQoQRzAurCjRCGnRUUE2FaoSL0HExiYVzsQwcj6RNrSqo4W5Gh6Yc4+1qDDTkIy+GhYK4nTgdz0H2PrrHUJzs71NQn86enPn+CVN9GnzruoYR63mMPbkC59gQzDl7pt7rc9f7FNyUhPY6Bx9gwt4E9zszhWWpdg6ZcS8j3O7zCTuEpnXB+3MNZkUUZu0NmHE8XsL91oSWwiiEc3MeseLrN6woYCWa/Zl8ozyQ3w3Hl2lYy0SwlCUvsVi/Gv2JwITnYPDun2Hy6jYuEzAF1jUBCVYpO6kXo+NuGMeBAgcgfwNkvgBOPgUqXgKvP7rBFvRhE1crp8Vq1noFYSlacVyqGk0D86gbART9BDk9BFnPCNJbCY5aCFL1Cyhtp0RWAp74MsKSrkq9guHyvfMTtmLc1togpZoyqYmyNoITzVTYRJCiXYBIQ3CwFqi83o3JDhX6C0M8XsGIMoQ4OyuRlq1DdZcLkmbgGDX1iIEKNxAcbgTEOqC4ZRaJ6Ub86K7CYFEo8Qo+GBQlQyXBczLZpbloaQ9k1NUz/kD2myBBKxRZpa5hVcQslalatoUxizxAVVrN3CW21bFj9F858Q9dnIRmDyeuybM71uxmH9BNBB1q6zybV7H9s1Ue4PM3/gu/AEbfqfWy2twsAAAAAElFTkSuQmCC", firstElements, new Option[0]);
        return result;
    }

    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getAuthors())) {
            return null;
        }
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_authors.xml");
        String title = Localization.Main.getText("authors.title");
        String urn = "calibre:authors";
        String summary = "";
        if (this.getAuthors().size() > 1) {
            summary = Localization.Main.getText("authors.alphabetical", this.authors.size());
        } else if (this.getAuthors().size() == 1) {
            summary = Localization.Main.getText("authors.alphabetical.single");
        }
        return this.getListOfAuthors(pBreadcrumbs, this.getAuthors(), 0, title, summary, urn, filename, null);
    }
}

