/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Option;
import com.gmail.dpierron.calibre.opds.BooksSubCatalog;
import com.gmail.dpierron.calibre.opds.Breadcrumbs;
import com.gmail.dpierron.calibre.opds.SplitOption;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.secure.SecureFileManager;
import com.gmail.dpierron.tools.Helper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllBooksSubCatalog
extends BooksSubCatalog {
    public AllBooksSubCatalog(List<Book> books) {
        super(books);
        this.sortBooks();
    }

    public AllBooksSubCatalog(Set<Object> stuffToFilterOut, List<Book> books) {
        super(stuffToFilterOut, books);
        this.sortBooks();
    }

    private void sortBooks() {
        this.sortBooksByTitle(this.getBooks());
    }

    @Override
    public Element getSubCatalogEntry(Breadcrumbs pBreadcrumbs) throws IOException {
        if (Helper.isNullOrEmpty(this.getBooks())) {
            return null;
        }
        String filename = SecureFileManager.INSTANCE.encode(pBreadcrumbs.getFilename() + "_books.xml");
        String title = Localization.Main.getText("allbooks.title");
        String urn = "calibre:books";
        String summary = "";
        if (this.getBooks().size() > 1) {
            summary = Localization.Main.getText("allbooks.alphabetical", this.getBooks().size());
        } else if (this.getBooks().size() == 1) {
            summary = Localization.Main.getText("allbooks.alphabetical.single");
        }
        return this.getListOfBooks(pBreadcrumbs, this.getBooks(), 0, title, summary, urn, filename, SplitOption.SplitByLetter, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAIASURBVDjLpVPPaxNREJ6Vt01caH4oWk1T0ZKlGIo9RG+BUsEK4kEP/Q8qPXnpqRdPBf8A8Wahhx7FQ0GF9FJ6UksqwfTSBDGyB5HkkphC9tfb7jfbtyQQTx142byZ75v5ZnZWC4KALmICPy+2DkvKIX2f/POz83LxCL7nrz+WPNcll49DrhM9v7xdO9JW330DuXrrqkFSgig5iR2Cfv3t3gNxOnv5BwU+eZ5HuON5/PMPJZKJ+yKQfpW0S7TxdC6WJaWkyvff1LDaFRAeLZj05MHsiPTS6hua0PUqtwC5sHq9zv9RYWl+nu5cETcnJ1M0M5WlWq3GsX6/T+VymRzHDluZiGYAAsw0TQahV8uyyGq1qFgskm0bHIO/1+sx1rFtchJhArwEyIQ1Gg2WD2A6nWawHQJVDIWgIJfLhQowTIeE9D0mKAU8qPC0220afsWFQoH93W6X7yCDJ+DEBeBmsxnPIJVKxWQVUwry+XyUwBlKMKwA8jqdDhOVCqVAzQDVvXAXhOdGBFgymYwrGoZBmUyGjxCCdF0fSahaFdgoTHRxfTveMCXvWfkuE3Y+f40qhgT/nMitupzApdvT18bu+YeDQwY9Xl4aG9/d/URiMBhQq/dvZMeVghtT17lSZW9/rAKsvPa/r9Fc2dw+Pe0/xI6kM9mT5vtXy+Nw2kU/5zOGRpvuMIu0YAAAAABJRU5ErkJggg==", new Option[0]);
    }
}

