/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.gui;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.tools.Helper;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProfileManagerDialog
extends JDialog {
    private JButton cmdDelete;
    private JButton cmdRename;
    private JList lstProfiles;
    private JPanel pnlButtons;
    private JScrollPane scrProfiles;

    public ProfileManagerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void loadProfiles() {
        DefaultListModel<String> listOfProfiles = new DefaultListModel<String>();
        for (String profile : StanzaConfiguration.DEFAULT.getExistingConfigurations()) {
            if ("default".equalsIgnoreCase(profile)) continue;
            listOfProfiles.addElement(profile);
        }
        this.lstProfiles.setModel(listOfProfiles);
    }

    private void renameProfile(int index) {
        File profileFile;
        if (index < 0 || index >= this.lstProfiles.getModel().getSize()) {
            return;
        }
        String profile = (String)this.lstProfiles.getModel().getElementAt(index);
        String newProfile = JOptionPane.showInputDialog(Localization.Main.getText("gui.profile.rename.msg", profile), (Object)profile);
        if ("default".equalsIgnoreCase(newProfile)) {
            return;
        }
        if (Helper.isNotNullOrEmpty((Object)newProfile) && !newProfile.equals(profile) && (profileFile = new File(StanzaConfiguration.DEFAULT.getConfigurationDirectory(), profile + ".PROFILE.XML")).exists()) {
            profileFile.renameTo(new File(StanzaConfiguration.DEFAULT.getConfigurationDirectory(), newProfile + ".PROFILE.XML"));
            this.loadProfiles();
        }
    }

    private void deleteProfile(int index) {
        File profileFile;
        if (index < 0 || index >= this.lstProfiles.getModel().getSize()) {
            return;
        }
        String profile = (String)this.lstProfiles.getModel().getElementAt(index);
        int result = JOptionPane.showConfirmDialog(this, Localization.Main.getText("gui.profile.delete.msg", profile), null, 2, 3);
        if (result != 2 && (profileFile = new File(StanzaConfiguration.DEFAULT.getConfigurationDirectory(), profile + ".PROFILE.XML")).exists()) {
            profileFile.delete();
            this.loadProfiles();
        }
    }

    private void initComponents() {
        this.scrProfiles = new JScrollPane();
        this.lstProfiles = new JList();
        this.loadProfiles();
        this.pnlButtons = new JPanel();
        this.cmdRename = new JButton();
        this.cmdDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Localization.Main.getText("gui.menu.profiles.manage"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.scrProfiles.setViewportView(this.lstProfiles);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.scrProfiles, gridBagConstraints);
        this.cmdRename.setText(Localization.Main.getText("gui.profile.rename"));
        this.cmdRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProfileManagerDialog.this.cmdRenameActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdRename);
        this.cmdDelete.setText(Localization.Main.getText("gui.profile.delete"));
        this.cmdDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProfileManagerDialog.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void cmdRenameActionPerformed(ActionEvent evt) {
        this.renameProfile(this.lstProfiles.getSelectedIndex());
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        this.deleteProfile(this.lstProfiles.getSelectedIndex());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProfileManagerDialog dialog = new ProfileManagerDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

