/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.gui;

import com.gmail.dpierron.calibre.configuration.CompatibilityTrick;
import com.gmail.dpierron.calibre.configuration.DeviceMode;
import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.calibre.database.DatabaseManager;
import com.gmail.dpierron.calibre.gui.BareBonesBrowserLaunch;
import com.gmail.dpierron.calibre.gui.GenerateCatalogDialog;
import com.gmail.dpierron.calibre.gui.ProfileManagerDialog;
import com.gmail.dpierron.calibre.opds.Catalog;
import com.gmail.dpierron.calibre.opds.Constants;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.calibre.opds.i18n.LocalizationHelper;
import com.gmail.dpierron.tools.Helper;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class Mainframe
extends JFrame {
    GenerateCatalogDialog catalogDialog;
    private JComboBox cboCompatibilityTrick;
    private JComboBox cboLang;
    private JCheckBox chkBrowseByCover;
    private JCheckBox chkBrowseByCoverWithoutSplit;
    private JCheckBox chkCopyToDatabaseFolder;
    private JCheckBox chkCryptFilenames;
    private JCheckBox chkDontsplittags;
    private JCheckBox chkIncludeAboutLink;
    private JCheckBox chkIncludeOnlyOneFile;
    private JCheckBox chkIncludeemptybooks;
    private JCheckBox chkNoShowSeries;
    private JCheckBox chkNobandwithoptimize;
    private JCheckBox chkNogenerateallbooks;
    private JCheckBox chkNogeneratecrosslinks;
    private JCheckBox chkNogenerateexternallinks;
    private JCheckBox chkNogeneratefiles;
    private JCheckBox chkNogeneratehtml;
    private JCheckBox chkNogeneratehtmlfiles;
    private JCheckBox chkNogenerateratings;
    private JCheckBox chkSplitByAuthorInitialGoToBooks;
    private JCheckBox chkSupressRatings;
    private JButton cmdCancel;
    private JButton cmdGenerate;
    private JButton cmdReset;
    private JButton cmdSave;
    private JButton cmdSetDatabaseFolder;
    private JButton cmdSetTargetFolder;
    private JMenuBar jMenuBar1;
    private JLabel lblBookLanguageTag;
    private JLabel lblBooksinrecent;
    private JLabel lblBottom0;
    private JLabel lblBrowseByCover;
    private JLabel lblBrowseByCoverWithoutSplit;
    private JLabel lblCatalogFolder;
    private JLabel lblCatalogTitle;
    private JLabel lblCompatibilityTrick;
    private JLabel lblCopyToDatabaseFolder;
    private JLabel lblCryptFilenames;
    private JLabel lblDatabaseFolder;
    private JLabel lblDeviceDropbox;
    private JLabel lblDeviceMode1;
    private JLabel lblDeviceMode2;
    private JLabel lblDeviceNAS;
    private JLabel lblDeviceNook;
    private JLabel lblDonate;
    private JLabel lblIncludeAboutLink;
    private JLabel lblIncludeOnlyOneFile;
    private JLabel lblIncludeemptybooks;
    private JLabel lblIncludeformat;
    private JLabel lblLang;
    private JLabel lblMaxCoverSize;
    private JLabel lblMaxbeforepaginate;
    private JLabel lblMaxbeforesplit;
    private JLabel lblMaxsummarylength;
    private JLabel lblMinBooksToMakeDeepLevel;
    private JLabel lblNoShowSeries;
    private JLabel lblNobandwithoptimize;
    private JLabel lblNogenerateallbooks;
    private JLabel lblNogeneratecrosslinks;
    private JLabel lblNogenerateexternallinks;
    private JLabel lblNogeneratefiles;
    private JLabel lblNogeneratehtml;
    private JLabel lblNogeneratehtmlfiles;
    private JLabel lblNogenerateratings;
    private JLabel lblRevision;
    private JLabel lblSplitByAuthorInitialGoToBooks;
    private JLabel lblSplittagson;
    private JLabel lblSupressRatings;
    private JLabel lblTagsToMakeDeep;
    private JLabel lblTagstoexclude;
    private JLabel lblTagstogenerate;
    private JLabel lblTargetFolder;
    private JLabel lblThumbnailheight;
    private JLabel lblTitle;
    private JLabel lblWikilang;
    private JMenu mnuFile;
    private JMenuItem mnuFileExit;
    private JMenuItem mnuFileGenerateCatalogs;
    private JMenuItem mnuFileSave;
    private JMenu mnuHelp;
    private JMenuItem mnuHelpAbout;
    private JMenuItem mnuHelpDonate;
    private JMenuItem mnuHelpWiki;
    private JMenu mnuProfiles;
    private JPanel pnlAdvancedOptions;
    private JPanel pnlBottom;
    private JPanel pnlButtons;
    private JPanel pnlGenerationOptions;
    private JPanel pnlMain;
    private JPanel pnlMainOptions;
    private JPanel pnlSplitTagsOn;
    private JPanel pnlTitle;
    private JTabbedPane tabOptionsTabs;
    private JTextField txtBookLanguageTag;
    private JTextField txtBooksinrecent;
    private JTextField txtCatalogFolder;
    private JTextField txtCatalogTitle;
    private JTextField txtDatabaseFolder;
    private JTextField txtIncludeformat;
    private JTextField txtMaxCoverSize;
    private JTextField txtMaxbeforepaginate;
    private JTextField txtMaxbeforesplit;
    private JTextField txtMaxsummarylength;
    private JTextField txtMinBooksToMakeDeepLevel;
    private JTextField txtSplittagson;
    private JTextField txtTagsToMakeDeep;
    private JTextField txtTagstoexclude;
    private JTextField txtTagstogenerate;
    private JTextField txtTargetFolder;
    private JTextField txtThumbnailheight;
    private JTextField txtWikilang;

    public Mainframe() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.loadValues();
        if (StanzaConfiguration.INSTANCE.wasReset()) {
            String msg = Localization.Main.getText("gui.reset.warning");
            JOptionPane.showMessageDialog(this, msg, "", 2);
        }
    }

    private void computeBrowseByCoverWithoutSplitVisibility() {
        boolean visible = this.chkBrowseByCover.isSelected();
        this.chkBrowseByCoverWithoutSplit.setVisible(visible);
        this.lblBrowseByCoverWithoutSplit.setVisible(visible);
    }

    private void actOnDontsplittagsActionPerformed() {
        this.actOnDontsplittagsActionPerformed(this.chkDontsplittags.isSelected());
    }

    private void actOnDontsplittagsActionPerformed(boolean dontsplit) {
        if (dontsplit) {
            this.txtSplittagson.setText(null);
        }
        this.txtSplittagson.setEnabled(!dontsplit);
        this.chkDontsplittags.setSelected(dontsplit);
    }

    private void adaptInterfaceToDeviceSpecificMode(DeviceMode mode) {
        LineBorder RED_BORDER = new LineBorder(Color.red);
        switch (mode) {
            case Nook: {
                this.lblDeviceDropbox.setBorder(null);
                this.lblDeviceNAS.setBorder(null);
                this.lblDeviceNook.setBorder(RED_BORDER);
                this.lblDeviceMode1.setText(Localization.Main.getText("config.devicemode.nook.description1"));
                this.lblDeviceMode2.setText(Localization.Main.getText("config.devicemode.nook.description2"));
                break;
            }
            case Nas: {
                this.lblDeviceDropbox.setBorder(null);
                this.lblDeviceNook.setBorder(null);
                this.lblDeviceNAS.setBorder(RED_BORDER);
                this.lblDeviceMode1.setText(Localization.Main.getText("config.devicemode.nas.description1"));
                this.lblDeviceMode2.setText(Localization.Main.getText("config.devicemode.nas.description2"));
                break;
            }
            default: {
                this.lblDeviceNAS.setBorder(null);
                this.lblDeviceNook.setBorder(null);
                this.lblDeviceDropbox.setBorder(RED_BORDER);
                this.lblDeviceMode1.setText(Localization.Main.getText("config.devicemode.dropbox.description1"));
                this.lblDeviceMode2.setText(Localization.Main.getText("config.devicemode.dropbox.description2") + " ");
            }
        }
        this.cmdCancel.setEnabled(true);
        this.mnuFileExit.setEnabled(true);
        this.cmdGenerate.setEnabled(true);
        this.mnuFileGenerateCatalogs.setEnabled(true);
        this.cmdReset.setEnabled(true);
        this.cmdSave.setEnabled(true);
        this.mnuFileSave.setEnabled(true);
    }

    private void setDeviceSpecificMode(DeviceMode mode) {
        StanzaConfiguration.INSTANCE.setDeviceMode(mode);
        this.adaptInterfaceToDeviceSpecificMode(mode);
        this.loadValues();
    }

    private void changeLanguage() {
        StanzaConfiguration.INSTANCE.setLanguage((String)this.cboLang.getSelectedItem());
        Localization.Main.reloadLocalizations();
        Localization.Enum.reloadLocalizations();
        this.translateTexts();
        this.pack();
    }

    private void about() {
        String intro_goal = Localization.Main.getText("intro.goal");
        String intro_wiki_title = Localization.Main.getText("intro.wiki.title");
        String intro_wiki_url = Localization.Main.getText("intro.wiki.url");
        String intro_team_title = Localization.Main.getText("intro.team.title");
        String intro_team_list1 = Localization.Main.getText("intro.team.list1");
        String intro_team_list2 = Localization.Main.getText("intro.team.list2");
        String intro_team_list3 = Localization.Main.getText("intro.team.list3");
        String intro_team_list4 = Localization.Main.getText("intro.team.list4");
        String intro_thanks_1 = Localization.Main.getText("intro.thanks.1");
        String intro_thanks_2 = Localization.Main.getText("intro.thanks.2");
        String message = "<html>" + intro_goal + "<br>" + intro_wiki_title + intro_wiki_url + "<br>" + intro_team_title + "<br><ul>" + "<li>" + intro_team_list1 + "<li>" + intro_team_list2 + "<li>" + intro_team_list3 + "<li>" + intro_team_list4 + "</ul><br>" + intro_thanks_1 + "<br>" + intro_thanks_2 + "</html>";
        JOptionPane.showMessageDialog(this, message, Localization.Main.getText("gui.menu.help.about"), 1);
    }

    private void donate() {
        String message = Localization.Main.getText("gui.confirm.donate");
        int result = JOptionPane.showConfirmDialog(this, message, "", 0);
        if (result != 0) {
            return;
        }
        BareBonesBrowserLaunch.openURL("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=LJJYRJBYCW8EU");
    }

    private void help() {
        BareBonesBrowserLaunch.openURL("http://wiki.mobileread.com/wiki/Calibre2opds");
    }

    private void generateCatalog() {
        String message = Localization.Main.getText("gui.confirm.generate");
        int result = JOptionPane.showConfirmDialog(this, message, "", 0);
        if (result != 0) {
            return;
        }
        this.storeValues();
        this.catalogDialog = new GenerateCatalogDialog((Frame)this, true);
        final Catalog catalog = new Catalog(this.catalogDialog);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    catalog.createMainCatalog();
                    Mainframe.this.catalogEnded(null);
                }
                catch (Exception e) {
                    Mainframe.this.catalogEnded(e);
                }
            }
        };
        new Thread(runnable).start();
        this.catalogDialog.setVisible(true);
    }

    synchronized void catalogEnded(final Exception e) {
        if (this.catalogDialog == null) {
            return;
        }
        this.catalogDialog.setVisible(false);
        this.catalogDialog = null;
        if (e != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    String s = Helper.getStackTrace((Throwable)e);
                    s = e.getMessage() + "\n" + s;
                    System.out.println(s);
                    JOptionPane.showMessageDialog(Mainframe.this, s, e.getClass().getName(), 0);
                }
            };
            new Thread(runnable).start();
        }
    }

    private void setProfile(String profileName) {
        StanzaConfiguration.INSTANCE.setCurrentConfigurationAndLoad(profileName);
        this.loadValues();
    }

    private void saveNewProfile() {
        String newProfileName = JOptionPane.showInputDialog(Localization.Main.getText("gui.profile.new"));
        if ("default".equalsIgnoreCase(newProfileName)) {
            return;
        }
        StanzaConfiguration.INSTANCE.setCurrentConfigurationAndSave(newProfileName);
        this.loadValues();
    }

    private void loadProfiles() {
        this.mnuProfiles.removeAll();
        JMenuItem mnuProfileNew = new JMenuItem();
        mnuProfileNew.setText(Localization.Main.getText("gui.menu.profiles.new"));
        mnuProfileNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mainframe.this.saveNewProfile();
            }
        });
        this.mnuProfiles.add(mnuProfileNew);
        JMenuItem mnuProfileManage = new JMenuItem();
        mnuProfileManage.setText(Localization.Main.getText("gui.menu.profiles.manage"));
        mnuProfileManage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileManagerDialog dialog = new ProfileManagerDialog((Frame)Mainframe.this, true);
                dialog.setLocationRelativeTo(Mainframe.this);
                dialog.setVisible(true);
                Mainframe.this.loadProfiles();
            }
        });
        this.mnuProfiles.add(mnuProfileManage);
        this.mnuProfiles.add(new JSeparator());
        List<String> profiles = StanzaConfiguration.INSTANCE.getExistingConfigurations();
        for (String profileName : profiles) {
            JCheckBoxMenuItem mnuProfileItem = new JCheckBoxMenuItem();
            mnuProfileItem.setText(profileName);
            ActionListener listener = new ActionListener(){
                String profile;

                public void actionPerformed(ActionEvent evt) {
                    Mainframe.this.setProfile(this.profile);
                }

                public ActionListener setProfile(String profile) {
                    this.profile = profile;
                    return this;
                }
            }.setProfile(profileName);
            mnuProfileItem.addActionListener(listener);
            mnuProfileItem.setSelected(StanzaConfiguration.INSTANCE.getCurrentConfiguration().equalsIgnoreCase(profileName));
            this.mnuProfiles.add(mnuProfileItem);
        }
    }

    private void loadValues() {
        InputVerifier iv = new InputVerifier(){

            public boolean verify(JComponent input) {
                if (!(input instanceof JTextField)) {
                    return false;
                }
                try {
                    Integer.parseInt(((JTextField)input).getText());
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
        this.cboLang.setModel(new DefaultComboBoxModel<String>(LocalizationHelper.INSTANCE.getAvailableLocalizations()));
        this.cboLang.setSelectedItem(StanzaConfiguration.INSTANCE.getLanguage());
        File f = StanzaConfiguration.INSTANCE.getDatabaseFolder();
        if (f == null || !f.exists()) {
            f = new File(".");
        }
        this.txtDatabaseFolder.setText(f.getAbsolutePath());
        this.cmdSetDatabaseFolder.setEnabled(!StanzaConfiguration.INSTANCE.isDatabaseFolderReadOnly());
        this.txtDatabaseFolder.setEnabled(!StanzaConfiguration.INSTANCE.isDatabaseFolderReadOnly());
        this.lblDatabaseFolder.setEnabled(!StanzaConfiguration.INSTANCE.isDatabaseFolderReadOnly());
        f = StanzaConfiguration.INSTANCE.getTargetFolder();
        if (f == null || !f.exists()) {
            this.txtTargetFolder.setText("");
        } else {
            this.txtTargetFolder.setText(f.getAbsolutePath());
        }
        this.cmdSetTargetFolder.setEnabled(!StanzaConfiguration.INSTANCE.isTargetFolderReadOnly());
        this.txtTargetFolder.setEnabled(!StanzaConfiguration.INSTANCE.isTargetFolderReadOnly());
        this.lblTargetFolder.setEnabled(!StanzaConfiguration.INSTANCE.isTargetFolderReadOnly());
        this.chkCopyToDatabaseFolder.setSelected(StanzaConfiguration.INSTANCE.getCopyToDatabaseFolder());
        this.chkCopyToDatabaseFolder.setEnabled(!StanzaConfiguration.INSTANCE.isCopyToDatabaseFolderReadOnly());
        this.lblCopyToDatabaseFolder.setEnabled(!StanzaConfiguration.INSTANCE.isCopyToDatabaseFolderReadOnly());
        this.txtWikilang.setText(StanzaConfiguration.INSTANCE.getWikipediaLanguage());
        this.txtWikilang.setEnabled(!StanzaConfiguration.INSTANCE.isWikipediaLanguageReadOnly());
        this.lblWikilang.setEnabled(!StanzaConfiguration.INSTANCE.isWikipediaLanguageReadOnly());
        this.txtCatalogFolder.setText(StanzaConfiguration.INSTANCE.getCatalogFolderName());
        this.txtCatalogFolder.setEnabled(!StanzaConfiguration.INSTANCE.isCatalogFolderNameReadOnly());
        this.lblCatalogFolder.setEnabled(!StanzaConfiguration.INSTANCE.isCatalogFolderNameReadOnly());
        this.txtCatalogTitle.setText(StanzaConfiguration.INSTANCE.getCatalogTitle());
        this.txtCatalogTitle.setEnabled(!StanzaConfiguration.INSTANCE.isCatalogTitleReadOnly());
        this.lblCatalogTitle.setEnabled(!StanzaConfiguration.INSTANCE.isCatalogTitleReadOnly());
        this.txtThumbnailheight.setText("" + StanzaConfiguration.INSTANCE.getThumbnailHeight());
        this.txtThumbnailheight.setInputVerifier(iv);
        this.txtThumbnailheight.setEnabled(!StanzaConfiguration.INSTANCE.isThumbnailHeightReadOnly());
        this.lblThumbnailheight.setEnabled(!StanzaConfiguration.INSTANCE.isThumbnailHeightReadOnly());
        this.txtMaxCoverSize.setText("" + StanzaConfiguration.INSTANCE.getMaxCoverSize());
        this.txtMaxCoverSize.setInputVerifier(iv);
        this.txtMaxCoverSize.setEnabled(!StanzaConfiguration.INSTANCE.isMaxCoverSizeReadOnly());
        this.lblMaxCoverSize.setEnabled(!StanzaConfiguration.INSTANCE.isMaxCoverSizeReadOnly());
        this.txtIncludeformat.setText(StanzaConfiguration.INSTANCE.getIncludedFormatsList());
        this.txtIncludeformat.setEnabled(!StanzaConfiguration.INSTANCE.isIncludedFormatsListReadOnly());
        this.lblIncludeformat.setEnabled(!StanzaConfiguration.INSTANCE.isIncludedFormatsListReadOnly());
        this.txtMaxbeforepaginate.setText("" + StanzaConfiguration.INSTANCE.getMaxBeforePaginate());
        this.txtMaxbeforepaginate.setInputVerifier(iv);
        this.txtMaxbeforepaginate.setEnabled(!StanzaConfiguration.INSTANCE.isMaxBeforePaginateReadOnly());
        this.lblMaxbeforepaginate.setEnabled(!StanzaConfiguration.INSTANCE.isMaxBeforePaginateReadOnly());
        this.txtMaxbeforesplit.setText("" + StanzaConfiguration.INSTANCE.getMaxBeforeSplit());
        this.txtMaxbeforesplit.setInputVerifier(iv);
        this.txtMaxbeforesplit.setEnabled(!StanzaConfiguration.INSTANCE.isMaxBeforeSplitReadOnly());
        this.lblMaxbeforesplit.setEnabled(!StanzaConfiguration.INSTANCE.isMaxBeforeSplitReadOnly());
        this.txtBooksinrecent.setText("" + StanzaConfiguration.INSTANCE.getBooksInRecentAdditions());
        this.txtBooksinrecent.setInputVerifier(iv);
        this.txtBooksinrecent.setEnabled(!StanzaConfiguration.INSTANCE.isBooksInRecentAdditionsReadOnly());
        this.lblBooksinrecent.setEnabled(!StanzaConfiguration.INSTANCE.isBooksInRecentAdditionsReadOnly());
        this.txtMaxsummarylength.setText("" + StanzaConfiguration.INSTANCE.getMaxSummaryLength());
        this.txtMaxsummarylength.setInputVerifier(iv);
        this.txtMaxsummarylength.setEnabled(!StanzaConfiguration.INSTANCE.isMaxSummaryLengthReadOnly());
        this.lblMaxsummarylength.setEnabled(!StanzaConfiguration.INSTANCE.isMaxSummaryLengthReadOnly());
        this.txtSplittagson.setText(StanzaConfiguration.INSTANCE.getSplitTagsOn());
        this.txtSplittagson.setEnabled(!StanzaConfiguration.INSTANCE.isSplitTagsOnReadOnly());
        this.lblSplittagson.setEnabled(!StanzaConfiguration.INSTANCE.isSplitTagsOnReadOnly());
        this.chkDontsplittags.setEnabled(!StanzaConfiguration.INSTANCE.isSplitTagsOnReadOnly());
        this.actOnDontsplittagsActionPerformed(Helper.isNullOrEmpty((Object)StanzaConfiguration.INSTANCE.getSplitTagsOn()));
        this.chkIncludeemptybooks.setSelected(StanzaConfiguration.INSTANCE.getIncludeBooksWithNoFile());
        this.chkIncludeemptybooks.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeBooksWithNoFileReadOnly());
        this.lblIncludeemptybooks.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeBooksWithNoFileReadOnly());
        this.chkIncludeOnlyOneFile.setSelected(StanzaConfiguration.INSTANCE.getIncludeOnlyOneFile());
        this.chkIncludeOnlyOneFile.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeOnlyOneFileReadOnly());
        this.lblIncludeOnlyOneFile.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeOnlyOneFileReadOnly());
        this.chkNobandwithoptimize.setSelected(!StanzaConfiguration.INSTANCE.saveBandwith());
        this.chkNobandwithoptimize.setEnabled(!StanzaConfiguration.INSTANCE.isSaveBandwithReadOnly());
        this.lblNobandwithoptimize.setEnabled(!StanzaConfiguration.INSTANCE.isSaveBandwithReadOnly());
        this.chkNogeneratehtml.setSelected(!StanzaConfiguration.INSTANCE.generateHtml());
        this.chkNogeneratehtml.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateHtmlReadOnly());
        this.lblNogeneratehtml.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateHtmlReadOnly());
        this.chkNogeneratehtmlfiles.setSelected(!StanzaConfiguration.INSTANCE.generateHtmlDownloads());
        this.chkNogeneratehtmlfiles.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateHtmlDownloadsReadOnly());
        this.lblNogeneratehtmlfiles.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateHtmlDownloadsReadOnly());
        this.chkSupressRatings.setSelected(StanzaConfiguration.INSTANCE.suppressRatingsInTitles());
        this.chkSupressRatings.setEnabled(!StanzaConfiguration.INSTANCE.isSupressRatingsInTitlesReadyOnly());
        this.lblSupressRatings.setEnabled(!StanzaConfiguration.INSTANCE.isSupressRatingsInTitlesReadyOnly());
        this.chkBrowseByCover.setSelected(StanzaConfiguration.INSTANCE.getBrowseByCover());
        this.chkBrowseByCover.setEnabled(!StanzaConfiguration.INSTANCE.isBrowseByCoverReadOnly());
        this.lblBrowseByCover.setEnabled(!StanzaConfiguration.INSTANCE.isBrowseByCoverReadOnly());
        this.chkBrowseByCoverWithoutSplit.setSelected(StanzaConfiguration.INSTANCE.getBrowseByCoverWithoutSplit());
        this.chkBrowseByCoverWithoutSplit.setEnabled(!StanzaConfiguration.INSTANCE.isBrowseByCoverWithoutSplitReadOnly());
        this.lblBrowseByCoverWithoutSplit.setEnabled(!StanzaConfiguration.INSTANCE.isBrowseByCoverWithoutSplitReadOnly());
        this.chkIncludeAboutLink.setSelected(StanzaConfiguration.INSTANCE.getIncludeAboutLink());
        this.chkIncludeAboutLink.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeAboutLinkReadOnly());
        this.lblIncludeAboutLink.setEnabled(!StanzaConfiguration.INSTANCE.isIncludeAboutLinkReadOnly());
        this.chkNogeneratefiles.setSelected(!StanzaConfiguration.INSTANCE.generateDownloads());
        this.chkNogeneratefiles.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateDownloadsReadOnly());
        this.lblNogeneratefiles.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateDownloadsReadOnly());
        this.chkCryptFilenames.setSelected(StanzaConfiguration.INSTANCE.getCryptFilenames());
        this.chkCryptFilenames.setEnabled(!StanzaConfiguration.INSTANCE.isCryptFilenamesReadOnly());
        this.lblCryptFilenames.setEnabled(!StanzaConfiguration.INSTANCE.isCryptFilenamesReadOnly());
        this.chkNoShowSeries.setSelected(!StanzaConfiguration.INSTANCE.getShowSeriesInAuthorCatalog());
        this.chkNoShowSeries.setEnabled(!StanzaConfiguration.INSTANCE.isShowSeriesInAuthorCatalogReadOnly());
        this.lblNoShowSeries.setEnabled(!StanzaConfiguration.INSTANCE.isShowSeriesInAuthorCatalogReadOnly());
        this.chkSplitByAuthorInitialGoToBooks.setSelected(StanzaConfiguration.INSTANCE.getSplitByAuthorInitialGoToBooks());
        this.chkNoShowSeries.setEnabled(!StanzaConfiguration.INSTANCE.isSplitByAuthorInitialGoToBooksReadOnly());
        this.lblNoShowSeries.setEnabled(!StanzaConfiguration.INSTANCE.isSplitByAuthorInitialGoToBooksReadOnly());
        this.txtBookLanguageTag.setText("" + StanzaConfiguration.INSTANCE.getBookLanguageTag());
        this.txtBookLanguageTag.setEnabled(!StanzaConfiguration.INSTANCE.isBookLanguageTagReadOnly());
        this.lblBookLanguageTag.setEnabled(!StanzaConfiguration.INSTANCE.isBookLanguageTagReadOnly());
        this.txtTagstogenerate.setText("" + StanzaConfiguration.INSTANCE.getTagsToGenerate());
        this.txtTagstogenerate.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToGenerateReadOnly());
        this.lblTagstogenerate.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToGenerateReadOnly());
        this.txtTagstoexclude.setText("" + StanzaConfiguration.INSTANCE.getTagsToExclude());
        this.txtTagstoexclude.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToExcludeReadOnly());
        this.lblTagstoexclude.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToExcludeReadOnly());
        this.chkNogeneratecrosslinks.setSelected(!StanzaConfiguration.INSTANCE.generateCrossLinks());
        this.chkNogeneratecrosslinks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateCrossLinksReadOnly());
        this.lblNogeneratecrosslinks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateCrossLinksReadOnly());
        this.chkNogenerateexternallinks.setSelected(!StanzaConfiguration.INSTANCE.generateExternalLinks());
        this.chkNogenerateexternallinks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateExternalLinksReadOnly());
        this.lblNogenerateexternallinks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateExternalLinksReadOnly());
        this.chkNogenerateratings.setSelected(!StanzaConfiguration.INSTANCE.generateRatings());
        this.chkNogenerateratings.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateRatingsReadOnly());
        this.lblNogenerateratings.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateRatingsReadOnly());
        this.chkNogenerateallbooks.setSelected(!StanzaConfiguration.INSTANCE.generateAllbooks());
        this.chkNogenerateallbooks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateAllbooksReadOnly());
        this.lblNogenerateallbooks.setEnabled(!StanzaConfiguration.INSTANCE.isGenerateAllbooksReadOnly());
        this.txtTagsToMakeDeep.setText("" + StanzaConfiguration.INSTANCE.getTagsToMakeDeep());
        this.txtTagsToMakeDeep.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToMakeDeepReadOnly());
        this.lblTagsToMakeDeep.setEnabled(!StanzaConfiguration.INSTANCE.isTagsToMakeDeepReadOnly());
        this.txtMinBooksToMakeDeepLevel.setText("" + StanzaConfiguration.INSTANCE.getMinBooksToMakeDeepLevel());
        this.txtMinBooksToMakeDeepLevel.setInputVerifier(iv);
        this.txtMinBooksToMakeDeepLevel.setEnabled(!StanzaConfiguration.INSTANCE.isMinBooksToMakeDeepLevelReadOnly());
        this.lblMinBooksToMakeDeepLevel.setEnabled(!StanzaConfiguration.INSTANCE.isMinBooksToMakeDeepLevelReadOnly());
        this.cboCompatibilityTrick.setModel(new DefaultComboBoxModel<CompatibilityTrick>(CompatibilityTrick.values()));
        this.cboCompatibilityTrick.setSelectedItem((Object)StanzaConfiguration.INSTANCE.getCompatibilityTrick());
        this.adaptInterfaceToDeviceSpecificMode(StanzaConfiguration.INSTANCE.getDeviceMode());
        this.computeBrowseByCoverWithoutSplitVisibility();
        this.changeLanguage();
        this.loadProfiles();
        this.pack();
    }

    private int getValue(JTextField field) {
        try {
            int i = Integer.parseInt(field.getText());
            return i;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void resetValues() {
        String lang = StanzaConfiguration.INSTANCE.getLanguage();
        StanzaConfiguration.INSTANCE.reset();
        this.loadValues();
        StanzaConfiguration.INSTANCE.setLanguage(lang);
        this.changeLanguage();
    }

    private void storeValues() {
        String s;
        StanzaConfiguration.INSTANCE.setLanguage("" + this.cboLang.getSelectedItem());
        StanzaConfiguration.INSTANCE.setCompatibilityTrick(CompatibilityTrick.valueOf("" + this.cboCompatibilityTrick.getSelectedItem()));
        File f = new File(this.txtDatabaseFolder.getText());
        if (f.exists()) {
            StanzaConfiguration.INSTANCE.setDatabaseFolder(f);
        }
        if (Helper.isNotNullOrEmpty((Object)(s = this.txtTargetFolder.getText()))) {
            f = new File(s);
            if (f.exists()) {
                StanzaConfiguration.INSTANCE.setTargetFolder(f);
            }
        } else {
            StanzaConfiguration.INSTANCE.setTargetFolder(null);
        }
        StanzaConfiguration.INSTANCE.setCopyToDatabaseFolder(this.chkCopyToDatabaseFolder.isSelected());
        StanzaConfiguration.INSTANCE.setWikipediaLanguage(this.txtWikilang.getText());
        StanzaConfiguration.INSTANCE.setCatalogFolderName(this.txtCatalogFolder.getText());
        StanzaConfiguration.INSTANCE.setCatalogTitle(this.txtCatalogTitle.getText());
        int i = this.getValue(this.txtThumbnailheight);
        if (i > -1) {
            StanzaConfiguration.INSTANCE.setThumbnailHeight(i);
        }
        if ((i = this.getValue(this.txtMaxCoverSize)) > -1) {
            StanzaConfiguration.INSTANCE.setMaxCoverSize(i);
        }
        StanzaConfiguration.INSTANCE.setIncludedFormatsList(this.txtIncludeformat.getText());
        i = this.getValue(this.txtMaxbeforepaginate);
        if (i > -1) {
            StanzaConfiguration.INSTANCE.setMaxBeforePaginate(i);
        }
        if ((i = this.getValue(this.txtMaxbeforesplit)) > -1) {
            StanzaConfiguration.INSTANCE.setMaxBeforeSplit(i);
        }
        if ((i = this.getValue(this.txtBooksinrecent)) > -1) {
            StanzaConfiguration.INSTANCE.setBooksInRecentAdditions(i);
        }
        if ((i = this.getValue(this.txtMaxsummarylength)) > -1) {
            StanzaConfiguration.INSTANCE.setMaxSummaryLength(i);
        }
        StanzaConfiguration.INSTANCE.setSplitTagsOn(this.txtSplittagson.getText());
        StanzaConfiguration.INSTANCE.setIncludeBooksWithNoFile(this.chkIncludeemptybooks.isSelected());
        StanzaConfiguration.INSTANCE.setIncludeOnlyOneFile(this.chkIncludeOnlyOneFile.isSelected());
        StanzaConfiguration.INSTANCE.setSaveBandwith(!this.chkNobandwithoptimize.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateHtml(!this.chkNogeneratehtml.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateHtmlDownloads(!this.chkNogeneratehtmlfiles.isSelected());
        StanzaConfiguration.INSTANCE.setSuppressRatingsInTitles(this.chkSupressRatings.isSelected());
        StanzaConfiguration.INSTANCE.setBrowseByCover(this.chkBrowseByCover.isSelected());
        StanzaConfiguration.INSTANCE.setBrowseByCoverWithoutSplit(this.chkBrowseByCoverWithoutSplit.isSelected());
        StanzaConfiguration.INSTANCE.setIncludeAboutLink(this.chkIncludeAboutLink.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateDownloads(!this.chkNogeneratefiles.isSelected());
        StanzaConfiguration.INSTANCE.setBookLanguageTag(this.txtBookLanguageTag.getText());
        StanzaConfiguration.INSTANCE.setCryptFilenames(this.chkCryptFilenames.isSelected());
        StanzaConfiguration.INSTANCE.setShowSeriesInAuthorCatalog(!this.chkNoShowSeries.isSelected());
        StanzaConfiguration.INSTANCE.setSplitByAuthorInitialGoToBooks(this.chkSplitByAuthorInitialGoToBooks.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateCrossLinks(!this.chkNogeneratecrosslinks.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateExternalLinks(!this.chkNogenerateexternallinks.isSelected());
        StanzaConfiguration.INSTANCE.setTagsToGenerate(this.txtTagstogenerate.getText());
        StanzaConfiguration.INSTANCE.setTagsToExclude(this.txtTagstoexclude.getText());
        StanzaConfiguration.INSTANCE.setGenerateRatings(!this.chkNogenerateratings.isSelected());
        StanzaConfiguration.INSTANCE.setGenerateAllbooks(!this.chkNogenerateallbooks.isSelected());
        StanzaConfiguration.INSTANCE.setTagsToMakeDeep(this.txtTagsToMakeDeep.getText());
        i = this.getValue(this.txtMinBooksToMakeDeepLevel);
        if (i > -1) {
            StanzaConfiguration.INSTANCE.setMinBooksToMakeDeepLevel(i);
        }
    }

    private void translateTexts() {
        String title = Localization.Main.getText("gui.title", "calibre2opds 2.3 cr1");
        this.lblTitle.setText(title);
        this.setTitle(title);
        this.lblBottom0.setText(Localization.Main.getText("gui.label.clickToDescribe"));
        this.lblBottom0.setFont(this.lblBottom0.getFont().deriveFont(1));
        this.cmdCancel.setText(Localization.Main.getText("gui.close"));
        this.cmdSave.setText(Localization.Main.getText("gui.save"));
        this.cmdGenerate.setText(Localization.Main.getText("gui.generate"));
        this.cmdReset.setText(Localization.Main.getText("gui.reset"));
        this.tabOptionsTabs.setTitleAt(0, Localization.Main.getText("gui.tab1"));
        this.tabOptionsTabs.setTitleAt(1, Localization.Main.getText("gui.tab2"));
        this.tabOptionsTabs.setTitleAt(2, Localization.Main.getText("gui.tab3"));
        this.lblDeviceDropbox.setToolTipText(Localization.Main.getText("config.devicemode.dropbox.description1") + " " + Localization.Main.getText("config.devicemode.dropbox.description2"));
        this.lblDeviceNAS.setToolTipText(Localization.Main.getText("config.devicemode.nas.description1") + " " + Localization.Main.getText("config.devicemode.nas.description2"));
        this.lblDeviceNook.setToolTipText(Localization.Main.getText("config.devicemode.nook.description1") + " " + Localization.Main.getText("config.devicemode.nook.description2"));
        this.adaptInterfaceToDeviceSpecificMode(StanzaConfiguration.INSTANCE.getDeviceMode());
        this.lblLang.setText(Localization.Main.getText("config.lang.label"));
        this.lblLang.setToolTipText(Localization.Main.getText("config.lang.description"));
        this.lblCompatibilityTrick.setText(Localization.Main.getText("config.CompatibilityTrick.label"));
        this.lblCompatibilityTrick.setToolTipText(Localization.Main.getText("config.CompatibilityTrick.description"));
        this.lblDatabaseFolder.setText(Localization.Main.getText("config.databaseFolder.label"));
        this.lblDatabaseFolder.setToolTipText(Localization.Main.getText("config.databaseFolder.description"));
        this.lblTargetFolder.setText(Localization.Main.getText("config.targetFolder.label"));
        this.lblTargetFolder.setToolTipText(Localization.Main.getText("config.targetFolder.description"));
        this.lblCopyToDatabaseFolder.setText(Localization.Main.getText("config.copyToDatabaseFolder.label"));
        this.lblCopyToDatabaseFolder.setToolTipText(Localization.Main.getText("config.copyToDatabaseFolder.description"));
        this.lblCatalogFolder.setText(Localization.Main.getText("config.catalogFolder.label"));
        this.lblCatalogFolder.setToolTipText(Localization.Main.getText("config.catalogFolder.description"));
        this.lblCatalogTitle.setText(Localization.Main.getText("config.catalogTitle.label"));
        this.lblCatalogTitle.setToolTipText(Localization.Main.getText("config.catalogTitle.description"));
        this.lblSplittagson.setText(Localization.Main.getText("config.splittagson.label"));
        this.lblSplittagson.setToolTipText(Localization.Main.getText("config.splittagson.description"));
        this.chkDontsplittags.setText(Localization.Main.getText("config.splittagson.splitbyletter"));
        this.lblBookLanguageTag.setText(Localization.Main.getText("config.booklanguagetag.label"));
        this.lblBookLanguageTag.setToolTipText(Localization.Main.getText("config.booklanguagetag.description"));
        this.lblTagstogenerate.setText(Localization.Main.getText("config.tagstogenerate.label"));
        this.lblTagstogenerate.setToolTipText(Localization.Main.getText("config.tagstogenerate.description"));
        this.lblTagstoexclude.setText(Localization.Main.getText("config.tagstoexclude.label"));
        this.lblTagstoexclude.setToolTipText(Localization.Main.getText("config.tagstoexclude.description"));
        this.lblWikilang.setText(Localization.Main.getText("config.wikilang.label"));
        this.lblWikilang.setToolTipText(Localization.Main.getText("config.wikilang.description"));
        this.lblCryptFilenames.setText(Localization.Main.getText("config.cryptfilenames.label"));
        this.lblCryptFilenames.setToolTipText(Localization.Main.getText("config.cryptfilenames.description"));
        this.lblNogeneratehtml.setText(Localization.Main.getText("config.nogeneratehtml.label"));
        this.lblNogeneratehtml.setToolTipText(Localization.Main.getText("config.nogeneratehtml.description"));
        this.lblNogeneratehtmlfiles.setText(Localization.Main.getText("config.nogeneratehtmlfiles.label"));
        this.lblNogeneratehtmlfiles.setToolTipText(Localization.Main.getText("config.nogeneratehtmlfiles.description"));
        this.lblBrowseByCover.setText(Localization.Main.getText("config.browseByCover.label"));
        this.lblBrowseByCover.setToolTipText(Localization.Main.getText("config.browseByCover.description"));
        this.lblBrowseByCoverWithoutSplit.setText(Localization.Main.getText("config.browseByCoverWithoutSplit.label"));
        this.lblBrowseByCoverWithoutSplit.setToolTipText(Localization.Main.getText("config.browseByCoverWithoutSplit.description"));
        this.lblIncludeAboutLink.setText(Localization.Main.getText("config.includeAboutLink.label"));
        this.lblIncludeAboutLink.setToolTipText(Localization.Main.getText("config.includeAboutLink.description"));
        this.lblNogeneratefiles.setText(Localization.Main.getText("config.nogeneratefiles.label"));
        this.lblNogeneratefiles.setToolTipText(Localization.Main.getText("config.nogeneratefiles.description"));
        this.lblNogenerateexternallinks.setText(Localization.Main.getText("config.noexternallinks.label"));
        this.lblNogenerateexternallinks.setToolTipText(Localization.Main.getText("config.noexternallinks.description"));
        this.lblNogeneratecrosslinks.setText(Localization.Main.getText("config.nocrosslinks.label"));
        this.lblNogeneratecrosslinks.setToolTipText(Localization.Main.getText("config.nocrosslinks.description"));
        this.lblNobandwithoptimize.setText(Localization.Main.getText("config.nobandwithoptimize.label"));
        this.lblNobandwithoptimize.setToolTipText(Localization.Main.getText("config.nobandwithoptimize.description"));
        this.lblNogenerateratings.setText(Localization.Main.getText("config.nogenerateratings.label"));
        this.lblNogenerateratings.setToolTipText(Localization.Main.getText("config.nogenerateratings.description"));
        this.lblSupressRatings.setText(Localization.Main.getText("config.SuppressRatingsInTitles.label"));
        this.lblSupressRatings.setToolTipText(Localization.Main.getText("config.SuppressRatingsInTitles.description"));
        this.lblNogenerateallbooks.setText(Localization.Main.getText("config.nogenerateallbooks.label"));
        this.lblNogenerateallbooks.setToolTipText(Localization.Main.getText("config.nogenerateallbooks.description"));
        this.lblIncludeformat.setText(Localization.Main.getText("config.includeformat.label"));
        this.lblIncludeformat.setToolTipText(Localization.Main.getText("config.includeformat.description"));
        this.lblMaxbeforepaginate.setText(Localization.Main.getText("config.maxbeforepaginate.label"));
        this.lblMaxbeforepaginate.setToolTipText(Localization.Main.getText("config.maxbeforepaginate.description"));
        this.lblMaxbeforesplit.setText(Localization.Main.getText("config.maxbeforesplit.label"));
        this.lblMaxbeforesplit.setToolTipText(Localization.Main.getText("config.maxbeforesplit.description"));
        this.lblBooksinrecent.setText(Localization.Main.getText("config.booksinrecent.label"));
        this.lblBooksinrecent.setToolTipText(Localization.Main.getText("config.booksinrecent.description"));
        this.lblMaxsummarylength.setText(Localization.Main.getText("config.maxsummarylength.label"));
        this.lblMaxsummarylength.setToolTipText(Localization.Main.getText("config.maxsummarylength.description"));
        this.lblIncludeemptybooks.setText(Localization.Main.getText("config.includeemptybooks.label"));
        this.lblIncludeemptybooks.setToolTipText(Localization.Main.getText("config.includeemptybooks.description"));
        this.lblIncludeOnlyOneFile.setText(Localization.Main.getText("config.IncludeOnlyOneFile.label"));
        this.lblIncludeOnlyOneFile.setToolTipText(Localization.Main.getText("config.IncludeOnlyOneFile.description"));
        this.lblNoShowSeries.setText(Localization.Main.getText("config.noshowseriesinauthorcatalog.label"));
        this.lblNoShowSeries.setToolTipText(Localization.Main.getText("config.noshowseriesinauthorcatalog.description"));
        this.lblSplitByAuthorInitialGoToBooks.setText(Localization.Main.getText("config.splitByAuthorInitialGoToBooks.label"));
        this.lblSplitByAuthorInitialGoToBooks.setToolTipText(Localization.Main.getText("config.splitByAuthorInitialGoToBooks.description"));
        this.lblThumbnailheight.setText(Localization.Main.getText("config.thumbnailheight.label"));
        this.lblThumbnailheight.setToolTipText(Localization.Main.getText("config.thumbnailheight.description"));
        this.lblMaxCoverSize.setText(Localization.Main.getText("config.maxCoverSize.label"));
        this.lblMaxCoverSize.setToolTipText(Localization.Main.getText("config.maxCoverSize.description"));
        this.lblMaxCoverSize.setVisible(false);
        this.txtMaxCoverSize.setVisible(false);
        this.lblTagsToMakeDeep.setText(Localization.Main.getText("config.tagsToMakeDeep.label"));
        this.lblTagsToMakeDeep.setToolTipText(Localization.Main.getText("config.tagsToMakeDeep.description"));
        this.lblMinBooksToMakeDeepLevel.setText(Localization.Main.getText("config.minBooksToMakeDeepLevel.label"));
        this.lblMinBooksToMakeDeepLevel.setToolTipText(Localization.Main.getText("config.minBooksToMakeDeepLevel.description"));
        this.mnuFile.setText(Localization.Main.getText("gui.menu.file"));
        this.mnuFileSave.setText(Localization.Main.getText("gui.save"));
        this.mnuFileGenerateCatalogs.setText(Localization.Main.getText("gui.generate"));
        this.mnuFileExit.setText(Localization.Main.getText("gui.close"));
        this.mnuHelp.setText(Localization.Main.getText("gui.menu.help"));
        this.mnuHelpAbout.setText(Localization.Main.getText("gui.menu.help.about"));
        this.mnuHelpWiki.setText(Localization.Main.getText("gui.menu.help.wiki"));
    }

    private void popupExplanation(JLabel label) {
        String popup = null;
        if (label == this.lblLang) {
            popup = Localization.Main.getText("config.lang.description");
        } else if (label == this.lblCompatibilityTrick) {
            popup = Localization.Main.getText("config.CompatibilityTrick.description");
        } else if (label == this.lblDatabaseFolder) {
            popup = Localization.Main.getText("config.databaseFolder.description");
        } else if (label == this.lblTargetFolder) {
            popup = Localization.Main.getText("config.targetFolder.description");
        } else if (label == this.lblCopyToDatabaseFolder) {
            popup = Localization.Main.getText("config.copyToDatabaseFolder.description");
        } else if (label == this.lblCatalogFolder) {
            popup = Localization.Main.getText("config.catalogFolder.description");
        } else if (label == this.lblCatalogTitle) {
            popup = Localization.Main.getText("config.catalogTitle.description");
        } else if (label == this.lblSplittagson) {
            popup = Localization.Main.getText("config.splittagson.description");
        } else if (label == this.lblBookLanguageTag) {
            popup = Localization.Main.getText("config.booklanguagetag.description");
        } else if (label == this.lblTagstogenerate) {
            popup = Localization.Main.getText("config.tagstogenerate.description");
        } else if (label == this.lblTagstoexclude) {
            popup = Localization.Main.getText("config.tagstoexclude.description");
        } else if (label == this.lblWikilang) {
            popup = Localization.Main.getText("config.wikilang.description");
        } else if (label == this.lblCryptFilenames) {
            popup = Localization.Main.getText("config.cryptfilenames.description");
        } else if (label == this.lblNogeneratehtml) {
            popup = Localization.Main.getText("config.nogeneratehtml.description");
        } else if (label == this.lblNogeneratehtmlfiles) {
            popup = Localization.Main.getText("config.nogeneratehtmlfiles.description");
        } else if (label == this.lblBrowseByCover) {
            popup = Localization.Main.getText("config.browseByCover.description");
        } else if (label == this.lblBrowseByCoverWithoutSplit) {
            popup = Localization.Main.getText("config.browseByCoverWithoutSplit.description");
        } else if (label == this.lblIncludeAboutLink) {
            popup = Localization.Main.getText("config.includeAboutLink.description");
        } else if (label == this.lblNogeneratefiles) {
            popup = Localization.Main.getText("config.nogeneratefiles.description");
        } else if (label == this.lblNogenerateexternallinks) {
            popup = Localization.Main.getText("config.noexternallinks.description");
        } else if (label == this.lblNogeneratecrosslinks) {
            popup = Localization.Main.getText("config.nocrosslinks.description");
        } else if (label == this.lblNobandwithoptimize) {
            popup = Localization.Main.getText("config.nobandwithoptimize.description");
        } else if (label == this.lblIncludeformat) {
            popup = Localization.Main.getText("config.includeformat.description");
        } else if (label == this.lblMaxbeforepaginate) {
            popup = Localization.Main.getText("config.maxbeforepaginate.description");
        } else if (label == this.lblMaxbeforesplit) {
            popup = Localization.Main.getText("config.maxbeforesplit.description");
        } else if (label == this.lblBooksinrecent) {
            popup = Localization.Main.getText("config.booksinrecent.description");
        } else if (label == this.lblMaxsummarylength) {
            popup = Localization.Main.getText("config.maxsummarylength.description");
        } else if (label == this.lblIncludeemptybooks) {
            popup = Localization.Main.getText("config.includeemptybooks.description");
        } else if (label == this.lblIncludeOnlyOneFile) {
            popup = Localization.Main.getText("config.IncludeOnlyOneFile.description");
        } else if (label == this.lblNoShowSeries) {
            popup = Localization.Main.getText("config.noshowseriesinauthorcatalog.description");
        } else if (label == this.lblSplitByAuthorInitialGoToBooks) {
            popup = Localization.Main.getText("config.splitByAuthorInitialGoToBooks.description");
        } else if (label == this.lblThumbnailheight) {
            popup = Localization.Main.getText("config.thumbnailheight.description");
        } else if (label == this.lblMaxCoverSize) {
            popup = Localization.Main.getText("config.maxCoverSize.description");
        } else if (label == this.lblTagsToMakeDeep) {
            popup = Localization.Main.getText("config.tagsToMakeDeep.description");
        } else if (label == this.lblMinBooksToMakeDeepLevel) {
            popup = Localization.Main.getText("config.minBooksToMakeDeepLevel.description");
        }
        if (Helper.isNotNullOrEmpty((Object)popup)) {
            JOptionPane.showMessageDialog(this, popup, Localization.Main.getText("gui.description"), 1);
        }
    }

    private void showSetDatabaseFolderDialog() {
        int result;
        JDirectoryChooser chooser = new JDirectoryChooser();
        chooser.setShowingCreateDirectory(false);
        File f = StanzaConfiguration.INSTANCE.getDatabaseFolder();
        if (f != null && f.exists()) {
            chooser.setCurrentDirectory(f);
        }
        if ((result = chooser.showOpenDialog(this)) == 1) {
            return;
        }
        f = chooser.getSelectedFile();
        if (this.setDatabaseFolder(f.getAbsolutePath())) {
            this.txtDatabaseFolder.setText(f.getAbsolutePath());
        }
    }

    private boolean setDatabaseFolder(String targetFolder) {
        File newFolder = new File(targetFolder);
        if (newFolder.exists()) {
            File oldFolder = StanzaConfiguration.INSTANCE.getDatabaseFolder();
            StanzaConfiguration.INSTANCE.setDatabaseFolder(newFolder);
            if (DatabaseManager.INSTANCE.databaseExists()) {
                JOptionPane.showMessageDialog(this, Localization.Main.getText("info.databasefolderset", targetFolder), null, 1);
                return true;
            }
            StanzaConfiguration.INSTANCE.setDatabaseFolder(oldFolder);
        }
        JOptionPane.showMessageDialog(this, Localization.Main.getText("error.nodatabase", targetFolder), null, 0);
        return false;
    }

    private void showSetTargetFolderDialog() {
        JDirectoryChooser chooser = new JDirectoryChooser();
        chooser.setShowingCreateDirectory(true);
        File f = StanzaConfiguration.INSTANCE.getTargetFolder();
        if (f != null && f.exists()) {
            chooser.setCurrentDirectory(f);
        } else {
            f = StanzaConfiguration.INSTANCE.getDatabaseFolder();
            if (f != null && f.exists()) {
                chooser.setCurrentDirectory(f);
            }
        }
        int result = chooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        f = chooser.getSelectedFile();
        if (this.setTargetFolder(f.getAbsolutePath())) {
            this.txtTargetFolder.setText(f.getAbsolutePath());
        }
    }

    private boolean setTargetFolder(String targetFolder) {
        File newFolder = new File(targetFolder);
        if (!newFolder.exists()) {
            String message = Localization.Main.getText("error.targetdoesnotexist", targetFolder);
            int result = JOptionPane.showConfirmDialog(this, message, "", 0);
            if (result != 0) {
                return false;
            }
            newFolder.mkdirs();
        }
        JOptionPane.showMessageDialog(this, Localization.Main.getText("info.targetfolderset", targetFolder), null, 1);
        return true;
    }

    private void saveConfiguration() {
        this.storeValues();
        String message = Localization.Main.getText("gui.info.saved");
        int result = JOptionPane.showConfirmDialog(this, message, "", 0);
        if (result != 0) {
            return;
        }
        System.exit(0);
    }

    private void cancelDialog() {
        System.exit(0);
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.lblDeviceDropbox = new JLabel();
        this.lblDeviceNAS = new JLabel();
        this.lblDeviceNook = new JLabel();
        this.lblDeviceMode1 = new JLabel();
        this.lblDeviceMode2 = new JLabel();
        this.lblDonate = new JLabel();
        this.tabOptionsTabs = new JTabbedPane();
        this.pnlMainOptions = new JPanel();
        this.lblLang = new JLabel();
        this.cboLang = new JComboBox();
        this.lblDatabaseFolder = new JLabel();
        this.txtDatabaseFolder = new JTextField();
        this.cmdSetDatabaseFolder = new JButton();
        this.lblTargetFolder = new JLabel();
        this.txtTargetFolder = new JTextField();
        this.cmdSetTargetFolder = new JButton();
        this.lblCatalogFolder = new JLabel();
        this.txtCatalogFolder = new JTextField();
        this.lblCatalogTitle = new JLabel();
        this.txtCatalogTitle = new JTextField();
        this.lblSplittagson = new JLabel();
        this.pnlSplitTagsOn = new JPanel();
        this.txtSplittagson = new JTextField();
        this.chkDontsplittags = new JCheckBox();
        this.lblBookLanguageTag = new JLabel();
        this.txtBookLanguageTag = new JTextField();
        this.lblTagstogenerate = new JLabel();
        this.txtTagstogenerate = new JTextField();
        this.lblTagstoexclude = new JLabel();
        this.txtTagstoexclude = new JTextField();
        this.lblWikilang = new JLabel();
        this.txtWikilang = new JTextField();
        this.chkCopyToDatabaseFolder = new JCheckBox();
        this.lblCopyToDatabaseFolder = new JLabel();
        this.lblCompatibilityTrick = new JLabel();
        this.cboCompatibilityTrick = new JComboBox();
        this.pnlGenerationOptions = new JPanel();
        this.lblCryptFilenames = new JLabel();
        this.chkCryptFilenames = new JCheckBox();
        this.lblNogeneratehtml = new JLabel();
        this.chkNogeneratehtml = new JCheckBox();
        this.lblNogeneratehtmlfiles = new JLabel();
        this.chkNogeneratehtmlfiles = new JCheckBox();
        this.lblBrowseByCover = new JLabel();
        this.chkBrowseByCover = new JCheckBox();
        this.lblBrowseByCoverWithoutSplit = new JLabel();
        this.chkBrowseByCoverWithoutSplit = new JCheckBox();
        this.lblIncludeAboutLink = new JLabel();
        this.chkIncludeAboutLink = new JCheckBox();
        this.lblNogeneratefiles = new JLabel();
        this.chkNogeneratefiles = new JCheckBox();
        this.lblNogenerateexternallinks = new JLabel();
        this.chkNogenerateexternallinks = new JCheckBox();
        this.lblNogeneratecrosslinks = new JLabel();
        this.chkNogeneratecrosslinks = new JCheckBox();
        this.lblNobandwithoptimize = new JLabel();
        this.chkNobandwithoptimize = new JCheckBox();
        this.lblNogenerateratings = new JLabel();
        this.chkNogenerateratings = new JCheckBox();
        this.lblNogenerateallbooks = new JLabel();
        this.chkNogenerateallbooks = new JCheckBox();
        this.lblSupressRatings = new JLabel();
        this.chkSupressRatings = new JCheckBox();
        this.pnlAdvancedOptions = new JPanel();
        this.lblIncludeformat = new JLabel();
        this.txtIncludeformat = new JTextField();
        this.lblMaxbeforepaginate = new JLabel();
        this.txtMaxbeforepaginate = new JTextField();
        this.lblMaxbeforesplit = new JLabel();
        this.txtMaxbeforesplit = new JTextField();
        this.lblBooksinrecent = new JLabel();
        this.txtBooksinrecent = new JTextField();
        this.lblMaxsummarylength = new JLabel();
        this.txtMaxsummarylength = new JTextField();
        this.lblIncludeemptybooks = new JLabel();
        this.chkIncludeemptybooks = new JCheckBox();
        this.lblNoShowSeries = new JLabel();
        this.chkNoShowSeries = new JCheckBox();
        this.lblThumbnailheight = new JLabel();
        this.txtThumbnailheight = new JTextField();
        this.lblSplitByAuthorInitialGoToBooks = new JLabel();
        this.chkSplitByAuthorInitialGoToBooks = new JCheckBox();
        this.lblTagsToMakeDeep = new JLabel();
        this.txtTagsToMakeDeep = new JTextField();
        this.lblMinBooksToMakeDeepLevel = new JLabel();
        this.txtMinBooksToMakeDeepLevel = new JTextField();
        this.txtMaxCoverSize = new JTextField();
        this.lblMaxCoverSize = new JLabel();
        this.lblIncludeOnlyOneFile = new JLabel();
        this.chkIncludeOnlyOneFile = new JCheckBox();
        this.pnlBottom = new JPanel();
        this.lblBottom0 = new JLabel();
        this.pnlButtons = new JPanel();
        this.cmdCancel = new JButton();
        this.cmdReset = new JButton();
        this.cmdSave = new JButton();
        this.cmdGenerate = new JButton();
        this.pnlTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.lblRevision = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mnuFileSave = new JMenuItem();
        this.mnuFileGenerateCatalogs = new JMenuItem();
        this.mnuFileExit = new JMenuItem();
        this.mnuProfiles = new JMenu();
        this.mnuHelp = new JMenu();
        this.mnuHelpDonate = new JMenuItem();
        this.mnuHelpWiki = new JMenuItem();
        this.mnuHelpAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle(Localization.Main.getText("gui.title"));
        this.pnlMain.setLayout(new GridBagLayout());
        this.lblDeviceDropbox.setIcon(new ImageIcon(this.getClass().getResource("/calibre-icon.gif")));
        this.lblDeviceDropbox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.lblDeviceDropboxMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pnlMain.add((Component)this.lblDeviceDropbox, gridBagConstraints);
        this.lblDeviceNAS.setIcon(new ImageIcon(this.getClass().getResource("/nas.png")));
        this.lblDeviceNAS.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.lblDeviceNASMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pnlMain.add((Component)this.lblDeviceNAS, gridBagConstraints);
        this.lblDeviceNook.setIcon(new ImageIcon(this.getClass().getResource("/nook.png")));
        this.lblDeviceNook.setMinimumSize(null);
        this.lblDeviceNook.setPreferredSize(null);
        this.lblDeviceNook.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.lblDeviceNookMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pnlMain.add((Component)this.lblDeviceNook, gridBagConstraints);
        this.lblDeviceMode1.setHorizontalAlignment(2);
        this.lblDeviceMode1.setText(Localization.Main.getText("gui.label.clickToDescribe"));
        this.lblDeviceMode1.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        this.pnlMain.add((Component)this.lblDeviceMode1, gridBagConstraints);
        this.lblDeviceMode2.setHorizontalAlignment(2);
        this.lblDeviceMode2.setText(Localization.Main.getText("gui.label.clickToDescribe"));
        this.lblDeviceMode2.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.pnlMain.add((Component)this.lblDeviceMode2, gridBagConstraints);
        this.lblDonate.setIcon(new ImageIcon(this.getClass().getResource("/donate.gif")));
        this.lblDonate.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.lblDonateMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pnlMain.add((Component)this.lblDonate, gridBagConstraints);
        this.pnlMainOptions.setLayout(new GridBagLayout());
        this.lblLang.setText(Localization.Main.getText("config.lang.label"));
        this.lblLang.setToolTipText(Localization.Main.getText("config.lang.description"));
        this.lblLang.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblLang, gridBagConstraints);
        this.cboLang.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboLang.setPreferredSize(new Dimension(100, 20));
        this.cboLang.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cboLangActionPerformed(evt);
            }
        });
        this.cboLang.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Mainframe.this.cboLangVetoableChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.cboLang, gridBagConstraints);
        this.lblDatabaseFolder.setText(Localization.Main.getText("config.databaseFolder.label"));
        this.lblDatabaseFolder.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblDatabaseFolder, gridBagConstraints);
        this.txtDatabaseFolder.setText("txtDatabaseFolder");
        this.txtDatabaseFolder.setPreferredSize(new Dimension(400, 20));
        this.txtDatabaseFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.txtDatabaseFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtDatabaseFolder, gridBagConstraints);
        this.cmdSetDatabaseFolder.setText("...");
        this.cmdSetDatabaseFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdSetDatabaseFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.cmdSetDatabaseFolder, gridBagConstraints);
        this.lblTargetFolder.setText(Localization.Main.getText("config.targetFolder.label"));
        this.lblTargetFolder.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblTargetFolder, gridBagConstraints);
        this.txtTargetFolder.setText("txtTargetFolder");
        this.txtTargetFolder.setPreferredSize(new Dimension(400, 20));
        this.txtTargetFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.txtTargetFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtTargetFolder, gridBagConstraints);
        this.cmdSetTargetFolder.setText("...");
        this.cmdSetTargetFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdSetTargetFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.cmdSetTargetFolder, gridBagConstraints);
        this.lblCatalogFolder.setText(Localization.Main.getText("config.catalogFolder.label"));
        this.lblCatalogFolder.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblCatalogFolder, gridBagConstraints);
        this.txtCatalogFolder.setText("txtCatalogFolder");
        this.txtCatalogFolder.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtCatalogFolder, gridBagConstraints);
        this.lblCatalogTitle.setText(Localization.Main.getText("config.catalogTitle.label"));
        this.lblCatalogTitle.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblCatalogTitle, gridBagConstraints);
        this.txtCatalogTitle.setText("txtCatalogTitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtCatalogTitle, gridBagConstraints);
        this.lblSplittagson.setText(Localization.Main.getText("config.splittagson.label"));
        this.lblSplittagson.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblSplittagson, gridBagConstraints);
        this.pnlSplitTagsOn.setLayout(new GridBagLayout());
        this.txtSplittagson.setText("txtSplittagson");
        this.txtSplittagson.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlSplitTagsOn.add((Component)this.txtSplittagson, gridBagConstraints);
        this.chkDontsplittags.setText(Localization.Main.getText("config.splittagson.splitbyletter"));
        this.chkDontsplittags.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.chkDontsplittagsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlSplitTagsOn.add((Component)this.chkDontsplittags, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlMainOptions.add((Component)this.pnlSplitTagsOn, gridBagConstraints);
        this.lblBookLanguageTag.setText(Localization.Main.getText("config.booklanguagetag.label"));
        this.lblBookLanguageTag.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblBookLanguageTag, gridBagConstraints);
        this.txtBookLanguageTag.setText("txtBookLanguageTag");
        this.txtBookLanguageTag.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtBookLanguageTag, gridBagConstraints);
        this.lblTagstogenerate.setText(Localization.Main.getText("config.tagstogenerate.label"));
        this.lblTagstogenerate.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblTagstogenerate, gridBagConstraints);
        this.txtTagstogenerate.setText("txtTagstogenerate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtTagstogenerate, gridBagConstraints);
        this.lblTagstoexclude.setText(Localization.Main.getText("config.tagstoexclude.label"));
        this.lblTagstoexclude.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblTagstoexclude, gridBagConstraints);
        this.txtTagstoexclude.setText("txtTagstoexclude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtTagstoexclude, gridBagConstraints);
        this.lblWikilang.setText(Localization.Main.getText("config.wikilang.label"));
        this.lblWikilang.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblWikilang, gridBagConstraints);
        this.txtWikilang.setText("txtWikilang");
        this.txtWikilang.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.txtWikilang, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMainOptions.add((Component)this.chkCopyToDatabaseFolder, gridBagConstraints);
        this.lblCopyToDatabaseFolder.setText(Localization.Main.getText("config.copyToDatabaseFolder.label"));
        this.lblCopyToDatabaseFolder.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMainOptions.add((Component)this.lblCopyToDatabaseFolder, gridBagConstraints);
        this.lblCompatibilityTrick.setText(Localization.Main.getText("config.CompatibilityTrick.label"));
        this.lblCompatibilityTrick.setToolTipText(Localization.Main.getText("config.CompatibilityTrick.description"));
        this.lblCompatibilityTrick.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.pnlMainOptions.add((Component)this.lblCompatibilityTrick, gridBagConstraints);
        this.cboCompatibilityTrick.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboCompatibilityTrick.setPreferredSize(new Dimension(100, 20));
        this.cboCompatibilityTrick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cboCompatibilityTrickActionPerformed(evt);
            }
        });
        this.cboCompatibilityTrick.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Mainframe.this.cboCompatibilityTrickVetoableChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.pnlMainOptions.add((Component)this.cboCompatibilityTrick, gridBagConstraints);
        this.tabOptionsTabs.addTab(Localization.Main.getText("gui.tab1"), this.pnlMainOptions);
        this.pnlGenerationOptions.setLayout(new GridBagLayout());
        this.lblCryptFilenames.setText(Localization.Main.getText("config.cryptfilenames.label"));
        this.lblCryptFilenames.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblCryptFilenames, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkCryptFilenames, gridBagConstraints);
        this.lblNogeneratehtml.setText(Localization.Main.getText("config.nogeneratehtml.label"));
        this.lblNogeneratehtml.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogeneratehtml, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogeneratehtml, gridBagConstraints);
        this.lblNogeneratehtmlfiles.setText(Localization.Main.getText("config.nogeneratehtmlfiles.label"));
        this.lblNogeneratehtmlfiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogeneratehtmlfiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogeneratehtmlfiles, gridBagConstraints);
        this.lblBrowseByCover.setText(Localization.Main.getText("config.browseByCover.label"));
        this.lblBrowseByCover.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblBrowseByCover, gridBagConstraints);
        this.chkBrowseByCover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.chkBrowseByCoverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkBrowseByCover, gridBagConstraints);
        this.lblBrowseByCoverWithoutSplit.setText(Localization.Main.getText("config.browseByCoverWithoutSplit.label"));
        this.lblBrowseByCoverWithoutSplit.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblBrowseByCoverWithoutSplit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkBrowseByCoverWithoutSplit, gridBagConstraints);
        this.lblIncludeAboutLink.setText(Localization.Main.getText("config.includeAboutLink.label"));
        this.lblIncludeAboutLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblIncludeAboutLink, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkIncludeAboutLink, gridBagConstraints);
        this.lblNogeneratefiles.setText(Localization.Main.getText("config.nogeneratefiles.label"));
        this.lblNogeneratefiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogeneratefiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogeneratefiles, gridBagConstraints);
        this.lblNogenerateexternallinks.setText(Localization.Main.getText("config.noexternallinks.label"));
        this.lblNogenerateexternallinks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogenerateexternallinks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogenerateexternallinks, gridBagConstraints);
        this.lblNogeneratecrosslinks.setText(Localization.Main.getText("config.nocrosslinks.label"));
        this.lblNogeneratecrosslinks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogeneratecrosslinks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogeneratecrosslinks, gridBagConstraints);
        this.lblNobandwithoptimize.setText(Localization.Main.getText("config.nobandwithoptimize.label"));
        this.lblNobandwithoptimize.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNobandwithoptimize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNobandwithoptimize, gridBagConstraints);
        this.lblNogenerateratings.setText(Localization.Main.getText("config.nogenerateratings.label"));
        this.lblNogenerateratings.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogenerateratings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogenerateratings, gridBagConstraints);
        this.lblNogenerateallbooks.setText(Localization.Main.getText("config.nogenerateallbooks.label"));
        this.lblNogenerateallbooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblNogenerateallbooks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkNogenerateallbooks, gridBagConstraints);
        this.lblSupressRatings.setText(Localization.Main.getText("config.SuppressRatingsInTitles.label"));
        this.lblSupressRatings.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.lblSupressRatings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlGenerationOptions.add((Component)this.chkSupressRatings, gridBagConstraints);
        this.tabOptionsTabs.addTab(Localization.Main.getText("gui.tab2"), this.pnlGenerationOptions);
        this.pnlAdvancedOptions.setLayout(new GridBagLayout());
        this.lblIncludeformat.setText(Localization.Main.getText("config.includeformat.label"));
        this.lblIncludeformat.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblIncludeformat, gridBagConstraints);
        this.txtIncludeformat.setText("txtIncludeformat");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtIncludeformat, gridBagConstraints);
        this.lblMaxbeforepaginate.setText(Localization.Main.getText("config.maxbeforepaginate.label"));
        this.lblMaxbeforepaginate.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblMaxbeforepaginate, gridBagConstraints);
        this.txtMaxbeforepaginate.setText("txtMaxbeforepaginate");
        this.txtMaxbeforepaginate.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtMaxbeforepaginate, gridBagConstraints);
        this.lblMaxbeforesplit.setText(Localization.Main.getText("config.maxbeforesplit.label"));
        this.lblMaxbeforesplit.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblMaxbeforesplit, gridBagConstraints);
        this.txtMaxbeforesplit.setText("txtMaxbeforesplit");
        this.txtMaxbeforesplit.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtMaxbeforesplit, gridBagConstraints);
        this.lblBooksinrecent.setText(Localization.Main.getText("config.booksinrecent.label"));
        this.lblBooksinrecent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblBooksinrecent, gridBagConstraints);
        this.txtBooksinrecent.setText("txtBooksinrecent");
        this.txtBooksinrecent.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtBooksinrecent, gridBagConstraints);
        this.lblMaxsummarylength.setText(Localization.Main.getText("config.maxsummarylength.label"));
        this.lblMaxsummarylength.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblMaxsummarylength, gridBagConstraints);
        this.txtMaxsummarylength.setText("txtMaxsummarylength");
        this.txtMaxsummarylength.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtMaxsummarylength, gridBagConstraints);
        this.lblIncludeemptybooks.setText(Localization.Main.getText("config.includeemptybooks.label"));
        this.lblIncludeemptybooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblIncludeemptybooks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.chkIncludeemptybooks, gridBagConstraints);
        this.lblNoShowSeries.setText(Localization.Main.getText("config.noshowseriesinauthorcatalog.label"));
        this.lblNoShowSeries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblNoShowSeries, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.chkNoShowSeries, gridBagConstraints);
        this.lblThumbnailheight.setText(Localization.Main.getText("config.thumbnailheight.label"));
        this.lblThumbnailheight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblThumbnailheight, gridBagConstraints);
        this.txtThumbnailheight.setText("txtThumbnailheight");
        this.txtThumbnailheight.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtThumbnailheight, gridBagConstraints);
        this.lblSplitByAuthorInitialGoToBooks.setText(Localization.Main.getText("config.splitByAuthorInitialGoToBooks.label"));
        this.lblSplitByAuthorInitialGoToBooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblSplitByAuthorInitialGoToBooks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.chkSplitByAuthorInitialGoToBooks, gridBagConstraints);
        this.lblTagsToMakeDeep.setText(Localization.Main.getText("config.tagsToMakeDeep.label"));
        this.lblTagsToMakeDeep.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblTagsToMakeDeep, gridBagConstraints);
        this.txtTagsToMakeDeep.setText("txtTagsToMakeDeep");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtTagsToMakeDeep, gridBagConstraints);
        this.lblMinBooksToMakeDeepLevel.setText(Localization.Main.getText("config.minBooksToMakeDeepLevel.label"));
        this.lblMinBooksToMakeDeepLevel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblMinBooksToMakeDeepLevel, gridBagConstraints);
        this.txtMinBooksToMakeDeepLevel.setText("txtMaxsummarylength");
        this.txtMinBooksToMakeDeepLevel.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtMinBooksToMakeDeepLevel, gridBagConstraints);
        this.txtMaxCoverSize.setText("txtMaxCoverSize");
        this.txtMaxCoverSize.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.txtMaxCoverSize, gridBagConstraints);
        this.lblMaxCoverSize.setText(Localization.Main.getText("config.maxCoverSize.label"));
        this.lblMaxCoverSize.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblMaxCoverSize, gridBagConstraints);
        this.lblIncludeOnlyOneFile.setText(Localization.Main.getText("config.IncludeOnlyOneFile.label"));
        this.lblIncludeOnlyOneFile.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Mainframe.this.handleMouseClickOnLabel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.lblIncludeOnlyOneFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlAdvancedOptions.add((Component)this.chkIncludeOnlyOneFile, gridBagConstraints);
        this.tabOptionsTabs.addTab(Localization.Main.getText("gui.tab3"), this.pnlAdvancedOptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pnlMain.add((Component)this.tabOptionsTabs, gridBagConstraints);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.lblBottom0.setFont(new Font("Tahoma", 1, 11));
        this.lblBottom0.setHorizontalAlignment(0);
        this.lblBottom0.setText(Localization.Main.getText("gui.label.clickToDescribe"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlBottom.add((Component)this.lblBottom0, gridBagConstraints);
        this.cmdCancel.setText(Localization.Main.getText("gui.close"));
        this.cmdCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdCancelActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdCancel);
        this.cmdReset.setText(Localization.Main.getText("gui.reset"));
        this.cmdReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdResetActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdReset);
        this.cmdSave.setText(Localization.Main.getText("gui.save"));
        this.cmdSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdSaveActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdSave);
        this.cmdGenerate.setText(Localization.Main.getText("gui.generate"));
        this.cmdGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.cmdGenerateActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.cmdGenerate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlBottom.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlMain.add((Component)this.pnlBottom, gridBagConstraints);
        this.pnlTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Arial", 1, 18));
        this.lblTitle.setHorizontalAlignment(4);
        this.lblTitle.setText("calibre2opds 2.3 cr1");
        this.lblTitle.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.lblRevision.setFont(new Font("Georgia", 0, 10));
        this.lblRevision.setHorizontalAlignment(2);
        this.lblRevision.setText(Constants.BZR_VERSION);
        this.lblRevision.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 9, 5);
        this.pnlTitle.add((Component)this.lblRevision, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMain.add((Component)this.pnlTitle, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.mnuFile.setText(Localization.Main.getText("gui.menu.file"));
        this.mnuFileSave.setText(Localization.Main.getText("gui.save"));
        this.mnuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuFileSaveActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileSave);
        this.mnuFileGenerateCatalogs.setText(Localization.Main.getText("gui.generate"));
        this.mnuFileGenerateCatalogs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuFileGenerateCatalogsActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileGenerateCatalogs);
        this.mnuFileExit.setText(Localization.Main.getText("gui.close"));
        this.mnuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuFileExitActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileExit);
        this.jMenuBar1.add(this.mnuFile);
        this.mnuProfiles.setText(Localization.Main.getText("gui.menu.profiles"));
        this.jMenuBar1.add(this.mnuProfiles);
        this.mnuHelp.setText(Localization.Main.getText("gui.menu.help"));
        this.mnuHelpDonate.setText(Localization.Main.getText("gui.menu.help.donate"));
        this.mnuHelpDonate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuHelpDonateActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuHelpDonate);
        this.mnuHelpWiki.setText(Localization.Main.getText("gui.menu.help.wiki"));
        this.mnuHelpWiki.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuHelpWikiActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuHelpWiki);
        this.mnuHelpAbout.setText(Localization.Main.getText("gui.menu.help.about"));
        this.mnuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mainframe.this.mnuHelpAboutActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuHelpAbout);
        this.jMenuBar1.add(this.mnuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void lblDeviceNASMouseClicked(MouseEvent evt) {
        this.setDeviceSpecificMode(DeviceMode.Nas);
    }

    private void chkBrowseByCoverActionPerformed(ActionEvent evt) {
        this.computeBrowseByCoverWithoutSplitVisibility();
    }

    private void txtDatabaseFolderActionPerformed(ActionEvent evt) {
        this.setDatabaseFolder(this.txtDatabaseFolder.getText());
    }

    private void txtTargetFolderActionPerformed(ActionEvent evt) {
        this.setTargetFolder(this.txtTargetFolder.getText());
    }

    private void cboCompatibilityTrickActionPerformed(ActionEvent evt) {
    }

    private void cboCompatibilityTrickVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    private void cmdSetTargetFolderActionPerformed(ActionEvent evt) {
        this.showSetTargetFolderDialog();
    }

    private void cboLangVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.changeLanguage();
    }

    private void cboLangActionPerformed(ActionEvent evt) {
        this.changeLanguage();
    }

    private void chkDontsplittagsActionPerformed(ActionEvent evt) {
        this.actOnDontsplittagsActionPerformed();
    }

    private void cmdResetActionPerformed(ActionEvent evt) {
        this.resetValues();
    }

    private void mnuHelpAboutActionPerformed(ActionEvent evt) {
        this.about();
    }

    private void mnuHelpWikiActionPerformed(ActionEvent evt) {
        this.help();
    }

    private void mnuHelpDonateActionPerformed(ActionEvent evt) {
        this.donate();
    }

    private void mnuFileSaveActionPerformed(ActionEvent evt) {
        this.saveConfiguration();
    }

    private void mnuFileExitActionPerformed(ActionEvent evt) {
        this.cancelDialog();
    }

    private void mnuFileGenerateCatalogsActionPerformed(ActionEvent evt) {
        this.generateCatalog();
    }

    private void lblDeviceNookMouseClicked(MouseEvent evt) {
        this.setDeviceSpecificMode(DeviceMode.Nook);
    }

    private void lblDeviceDropboxMouseClicked(MouseEvent evt) {
        this.setDeviceSpecificMode(DeviceMode.Dropbox);
    }

    private void lblDonateMouseClicked(MouseEvent evt) {
        this.donate();
    }

    private void handleMouseClickOnLabel(MouseEvent evt) {
        this.popupExplanation((JLabel)evt.getSource());
    }

    private void cmdGenerateActionPerformed(ActionEvent evt) {
        this.generateCatalog();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.saveConfiguration();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.cancelDialog();
    }

    private void cmdSetDatabaseFolderActionPerformed(ActionEvent evt) {
        this.showSetDatabaseFolderDialog();
    }
}

