/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.gui;

import com.gmail.dpierron.calibre.opds.Catalog;
import com.gmail.dpierron.calibre.opds.CatalogCallbackInterface;
import com.gmail.dpierron.calibre.opds.Log4jCatalogCallback;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import com.gmail.dpierron.tools.Helper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class GenerateCatalogDialog
extends JDialog
implements CatalogCallbackInterface {
    private static final Logger logger = Logger.getLogger(Catalog.class);
    private Log4jCatalogCallback delegate = new Log4jCatalogCallback();
    int maxScale;
    double to30000;
    int pos;
    int position;
    private JCheckBox chkAllbooks;
    private JCheckBox chkAuthors;
    private JCheckBox chkCopyCatToTarget;
    private JCheckBox chkCopyLibToTarget;
    private JCheckBox chkDatabase;
    private JCheckBox chkFinished;
    private JCheckBox chkRated;
    private JCheckBox chkRecent;
    private JCheckBox chkSeries;
    private JCheckBox chkTags;
    private JCheckBox chkThumbnails;
    private JProgressBar jProgress;
    private JLabel lblAllbooks;
    private JLabel lblAuthors;
    private JLabel lblCopyCatToTarget;
    private JLabel lblCopyLibToTarget;
    private JLabel lblDatabase;
    private JLabel lblFinished;
    private JLabel lblRated;
    private JLabel lblRecent;
    private JLabel lblSeries;
    private JLabel lblTags;
    private JLabel lblThmbnails;

    public GenerateCatalogDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setLocationRelativeTo(parent);
        this.initComponents();
        this.translateTexts();
    }

    public void pack() {
        super.pack();
        Rectangle oldbounds = this.getBounds();
        oldbounds.width += 10;
        oldbounds.height += 10;
        this.setBounds(oldbounds);
    }

    private void translateTexts() {
        this.lblDatabase.setText(Localization.Main.getText("info.step.database"));
        this.lblTags.setText(Localization.Main.getText("info.step.tags"));
        this.lblAuthors.setText(Localization.Main.getText("info.step.authors"));
        this.lblSeries.setText(Localization.Main.getText("info.step.series"));
        this.lblRecent.setText(Localization.Main.getText("info.step.recent"));
        this.lblAllbooks.setText(Localization.Main.getText("info.step.allbooks"));
        this.lblThmbnails.setText(Localization.Main.getText("info.step.thumbnails"));
        this.lblCopyLibToTarget.setText(Localization.Main.getText("info.step.copylib"));
        this.lblCopyCatToTarget.setText(Localization.Main.getText("info.step.copycat"));
        this.lblFinished.setText(Localization.Main.getText("info.step.done.gui"));
    }

    public void dumpOptions() {
        this.delegate.dumpOptions();
    }

    private void boldFont(JLabel label, boolean bold) {
        label.setFont(this.lblDatabase.getFont().deriveFont(bold ? 1 : 0));
    }

    public void startCreateMainCatalog() {
        this.jProgress.setValue(0);
    }

    public void startReadDatabase() {
        this.jProgress.setValue(0);
        this.boldFont(this.lblDatabase, true);
        logger.info(Localization.Main.getText("info.step.database"));
    }

    public void endReadDatabase(long milliseconds) {
        this.jProgress.setValue(1);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkDatabase.setSelected(true);
        this.boldFont(this.lblDatabase, false);
    }

    public void startCreateTags() {
        logger.info(Localization.Main.getText("info.step.tags"));
        this.boldFont(this.lblTags, true);
    }

    public void endCreateTags(long milliseconds) {
        this.jProgress.setValue(2);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkTags.setSelected(true);
        this.boldFont(this.lblTags, false);
    }

    public void startCreateAuthors() {
        logger.info(Localization.Main.getText("info.step.authors"));
        this.boldFont(this.lblAuthors, true);
    }

    public void endCreateAuthors(long milliseconds) {
        this.jProgress.setValue(3);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkAuthors.setSelected(true);
        this.boldFont(this.lblAuthors, false);
    }

    public void startCreateSeries() {
        logger.info(Localization.Main.getText("info.step.series"));
        this.boldFont(this.lblSeries, true);
    }

    public void endCreateSeries(long milliseconds) {
        this.jProgress.setValue(4);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkSeries.setSelected(true);
        this.boldFont(this.lblSeries, false);
    }

    public void startCreateRecent() {
        logger.info(Localization.Main.getText("info.step.recent"));
        this.boldFont(this.lblRecent, true);
    }

    public void endCreateRecent(long milliseconds) {
        this.jProgress.setValue(5);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkRecent.setSelected(true);
        this.boldFont(this.lblRecent, false);
    }

    public void startCreateRated() {
        logger.info(Localization.Main.getText("info.step.rated"));
        this.boldFont(this.lblRated, true);
    }

    public void endCreateRated(long milliseconds) {
        this.jProgress.setValue(6);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkRated.setSelected(true);
        this.boldFont(this.lblRated, false);
    }

    public void startCreateAllbooks() {
        logger.info(Localization.Main.getText("info.step.allbooks"));
        this.boldFont(this.lblAllbooks, true);
    }

    public void endCreateAllbooks(long milliseconds) {
        this.jProgress.setValue(7);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkAllbooks.setSelected(true);
        this.boldFont(this.lblAllbooks, false);
    }

    public void startCreateThumbnails() {
        logger.info(Localization.Main.getText("info.step.thumbnails"));
        this.boldFont(this.lblThmbnails, true);
    }

    public void endCreateThumbnails(long milliseconds) {
        this.jProgress.setValue(8);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkThumbnails.setSelected(true);
        this.boldFont(this.lblThmbnails, false);
    }

    public void setMaxScale(long maxScale) {
        if (maxScale > 30000L) {
            this.to30000 = 30000.0 / (double)maxScale;
            this.maxScale = 30000;
        } else {
            this.maxScale = (int)maxScale;
        }
        this.jProgress.setMaximum(this.maxScale);
    }

    public void incPosition() {
        ++this.position;
        int newPos = this.to30000 > 0.0 ? (int)((double)this.position * this.to30000) : this.position;
        if (newPos > this.pos) {
            this.jProgress.setValue(newPos + 8);
            this.pos = newPos;
        }
    }

    public void startCopyLibToTarget() {
        logger.info(Localization.Main.getText("info.step.copylib"));
        this.boldFont(this.lblCopyLibToTarget, true);
    }

    public void endCopyLibToTarget(long milliseconds) {
        this.jProgress.setValue(this.jProgress.getValue() + 1);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkCopyLibToTarget.setSelected(true);
        this.boldFont(this.lblCopyLibToTarget, false);
    }

    public void startCopyCatToTarget() {
        logger.info(Localization.Main.getText("info.step.copycat"));
        this.boldFont(this.lblCopyCatToTarget, true);
    }

    public void endCopyCatToTarget(long milliseconds) {
        this.jProgress.setValue(this.maxScale + 10);
        logger.info(Localization.Main.getText("info.step.donein", milliseconds));
        this.chkCopyCatToTarget.setSelected(true);
        this.boldFont(this.lblCopyCatToTarget, false);
    }

    public void endCreateMainCatalog(String where, long timeInHtml) {
        this.jProgress.setValue(this.maxScale + 12);
        this.chkFinished.setSelected(true);
        String message = Localization.Main.getText("info.step.done", where);
        logger.info(message);
        int result = JOptionPane.showConfirmDialog(this, message, "", 0);
        if (result == 0) {
            System.exit(0);
        }
    }

    public void errorOccured(String message, Throwable error) {
        String msg;
        String title;
        if (error != null) {
            title = message;
            if (Helper.isNullOrEmpty((Object)title)) {
                title = error.getClass().getName();
            }
            msg = Helper.getStackTrace((Throwable)error);
        } else {
            msg = message;
            title = "";
        }
        JOptionPane.showMessageDialog(this, msg, title, 0);
        logger.error(message, error);
    }

    private void initComponents() {
        this.jProgress = new JProgressBar();
        this.lblDatabase = new JLabel();
        this.chkDatabase = new JCheckBox();
        this.lblTags = new JLabel();
        this.chkTags = new JCheckBox();
        this.lblAuthors = new JLabel();
        this.chkAuthors = new JCheckBox();
        this.lblSeries = new JLabel();
        this.chkSeries = new JCheckBox();
        this.lblRecent = new JLabel();
        this.chkRecent = new JCheckBox();
        this.lblRated = new JLabel();
        this.chkRated = new JCheckBox();
        this.lblAllbooks = new JLabel();
        this.chkAllbooks = new JCheckBox();
        this.lblFinished = new JLabel();
        this.chkFinished = new JCheckBox();
        this.lblThmbnails = new JLabel();
        this.chkThumbnails = new JCheckBox();
        this.lblCopyLibToTarget = new JLabel();
        this.chkCopyLibToTarget = new JCheckBox();
        this.lblCopyCatToTarget = new JLabel();
        this.chkCopyCatToTarget = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jProgress.setMaximum(61);
        this.jProgress.setPreferredSize(new Dimension(300, 19));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.getContentPane().add((Component)this.jProgress, gridBagConstraints);
        this.lblDatabase.setText(Localization.Main.getText("info.step.database"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblDatabase, gridBagConstraints);
        this.chkDatabase.setEnabled(false);
        this.chkDatabase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkDatabaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkDatabase, gridBagConstraints);
        this.lblTags.setText(Localization.Main.getText("info.step.tags"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblTags, gridBagConstraints);
        this.chkTags.setEnabled(false);
        this.chkTags.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkTagsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkTags, gridBagConstraints);
        this.lblAuthors.setText(Localization.Main.getText("info.step.authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblAuthors, gridBagConstraints);
        this.chkAuthors.setEnabled(false);
        this.chkAuthors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkAuthorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkAuthors, gridBagConstraints);
        this.lblSeries.setText(Localization.Main.getText("info.step.series"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblSeries, gridBagConstraints);
        this.chkSeries.setEnabled(false);
        this.chkSeries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkSeriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkSeries, gridBagConstraints);
        this.lblRecent.setText(Localization.Main.getText("info.step.recent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblRecent, gridBagConstraints);
        this.chkRecent.setEnabled(false);
        this.chkRecent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkRecentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkRecent, gridBagConstraints);
        this.lblRated.setText(Localization.Main.getText("info.step.rated"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblRated, gridBagConstraints);
        this.chkRated.setEnabled(false);
        this.chkRated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkRatedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkRated, gridBagConstraints);
        this.lblAllbooks.setText(Localization.Main.getText("info.step.allbooks"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblAllbooks, gridBagConstraints);
        this.chkAllbooks.setEnabled(false);
        this.chkAllbooks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkAllbooksActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkAllbooks, gridBagConstraints);
        this.lblFinished.setText(Localization.Main.getText("info.step.done.gui"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblFinished, gridBagConstraints);
        this.chkFinished.setEnabled(false);
        this.chkFinished.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkFinishedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkFinished, gridBagConstraints);
        this.lblThmbnails.setText(Localization.Main.getText("info.step.thumbnails"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblThmbnails, gridBagConstraints);
        this.chkThumbnails.setEnabled(false);
        this.chkThumbnails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkThumbnailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkThumbnails, gridBagConstraints);
        this.lblCopyLibToTarget.setText(Localization.Main.getText("info.step.copylib"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblCopyLibToTarget, gridBagConstraints);
        this.chkCopyLibToTarget.setEnabled(false);
        this.chkCopyLibToTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkCopyLibToTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkCopyLibToTarget, gridBagConstraints);
        this.lblCopyCatToTarget.setText(Localization.Main.getText("info.step.copycat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.lblCopyCatToTarget, gridBagConstraints);
        this.chkCopyCatToTarget.setEnabled(false);
        this.chkCopyCatToTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateCatalogDialog.this.chkCopyCatToTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.chkCopyCatToTarget, gridBagConstraints);
        this.pack();
    }

    private void chkThumbnailsActionPerformed(ActionEvent evt) {
    }

    private void chkRatedActionPerformed(ActionEvent evt) {
    }

    private void chkCopyLibToTargetActionPerformed(ActionEvent evt) {
    }

    private void chkCopyCatToTargetActionPerformed(ActionEvent evt) {
    }

    private void chkDatabaseActionPerformed(ActionEvent evt) {
    }

    private void chkTagsActionPerformed(ActionEvent evt) {
    }

    private void chkAuthorsActionPerformed(ActionEvent evt) {
    }

    private void chkSeriesActionPerformed(ActionEvent evt) {
    }

    private void chkRecentActionPerformed(ActionEvent evt) {
    }

    private void chkAllbooksActionPerformed(ActionEvent evt) {
    }

    private void chkFinishedActionPerformed(ActionEvent evt) {
    }
}

