/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.gui;

import java.net.URI;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class BareBonesBrowserLaunch {
    static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(String url) {
        try {
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
        }
        catch (Exception ignore) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    boolean found = false;
                    for (String browser : browsers) {
                        if (found) continue;
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
            }
        }
    }
}

