/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.configuration;

import com.gmail.dpierron.calibre.configuration.CompatibilityTrick;
import com.gmail.dpierron.calibre.configuration.Configuration;
import com.gmail.dpierron.calibre.configuration.ConfigurationInterface;
import com.gmail.dpierron.calibre.configuration.DeviceMode;
import com.gmail.dpierron.calibre.configuration.StanzaDefaultConfiguration;
import com.gmail.dpierron.tools.Helper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StanzaConfiguration implements ConfigurationInterface
{
    DEFAULT(true),
    INSTANCE(false);

    public static final String PROFILES_SUFFIX = ".PROFILE.XML";
    private static final String CONFIGURATION_FOLDER = ".calibre2opds";
    private static final String DEFAULT_CONFIGURATION = "default";
    private static final String PROPERTY_NAME_VERSIONCHIP = "VERSIONCHIP";
    private static final String PROPERTY_NAME_CURRENTCONFIGURATION = "CurrentConfiguration";
    private static final String PROPERTY_NAME_DATABASEFOLDER = "DatabaseFolder";
    private static final String PROPERTY_NAME_TARGETFOLDER = "TargetFolder";
    private static final String PROPERTY_NAME_LANGUAGE = "Language";
    private static final String PROPERTY_NAME_CATALOGFOLDERNAME = "CatalogFolderName";
    private static final String PROPERTY_NAME_CATALOGTITLE = "CatalogTitle";
    private static final String PROPERTY_NAME_MAXBEFOREPAGINATE = "MaxBeforePaginate";
    private static final String PROPERTY_NAME_MAXBEFORESPLIT = "MaxBeforeSplit";
    private static final String PROPERTY_NAME_BOOKSINRECENTADDITIONS = "BooksInRecentAdditions";
    private static final String PROPERTY_NAME_WIKIPEDIALANGUAGE = "WikipediaLanguage";
    private static final String PROPERTY_NAME_INCLUDEDFORMATSLIST = "IncludedFormatsList";
    private static final String PROPERTY_NAME_SAVEBANDWITH = "SaveBandwith";
    private static final String PROPERTY_NAME_THUMBNAILHEIGHT = "ThumbnailHeight";
    private static final String PROPERTY_NAME_GENERATEHTML = "GenerateHtml";
    private static final String PROPERTY_NAME_GENERATEHTMLDOWNLOADS = "GenerateHtmlDownloads";
    private static final String PROPERTY_NAME_SUPRESSRATINGSINTITLES = "SuppressRatingsInTitles";
    private static final String PROPERTY_NAME_GENERATEDOWNLOADS = "GenerateDownloads";
    private static final String PROPERTY_NAME_SPLITTAGSON = "SplitTagsOn";
    private static final String PROPERTY_NAME_INCLUDEBOOKSWITHNOFILE = "IncludeBooksWithNoFile";
    private static final String PROPERTY_NAME_BOOKLANGUAGETAG = "BookLanguageTag";
    private static final String PROPERTY_NAME_CRYPTFILENAMES = "CryptFilenames";
    private static final String PROPERTY_NAME_SHOWSERIESINAUTHORCATALOG = "ShowSeriesInAuthorCatalog";
    private static final String PROPERTY_NAME_TAGSTOGENERATE = "tagsToGenerate";
    private static final String PROPERTY_NAME_TAGSTOMAKEDEEP = "tagsToMakeDeep";
    private static final String PROPERTY_NAME_TAGSTOEXCLUDE = "tagsToExclude";
    private static final String PROPERTY_NAME_GENERATEEXTERNALLINKS = "generateExternalLinks";
    private static final String PROPERTY_NAME_GENERATECROSSLINKS = "generateCrossLinks";
    private static final String PROPERTY_NAME_MAXSUMMARYLENGTH = "maxSummaryLength";
    private static final String PROPERTY_NAME_GENERATERATINGS = "generateRatings";
    private static final String PROPERTY_NAME_GENERATEALLBOOKS = "generateAllbooks";
    private static final String PROPERTY_NAME_DEVICEMODE = "deviceMode";
    private static final String PROPERTY_NAME_COPYTODATABASEFOLDER = "CopyToDatabaseFolder";
    private static final String PROPERTY_NAME_BROWSEBYCOVER = "BrowseByCover";
    private static final String PROPERTY_NAME_SPLITBYAUTHORINITIALGOTOBOOK = "SplitByAuthorInitialGoToBooks";
    private static final String PROPERTY_NAME_INCLUDEABOUTLINK = "IncludeAboutLink";
    private static final String PROPERTY_NAME_BROWSEBYCOVERWITHOUTSPLIT = "BrowseByCoverWithoutSplit";
    private static final String PROPERTY_NAME_MINBOOKSTOMAKEDEEPLEVEL = "MinBooksToMakeDeepLevel";
    private static final String PROPERTY_NAME_MAXCOVERSIZE = "MaxCoverSize";
    private static final String PROPERTY_NAME_INCLUDEONLYONEFILE = "IncludeOnlyOneFile";
    private static final String PROPERTY_NAME_COMPATIBILITYTRICK = "CompatibilityTrick";
    private static final Logger logger;
    private static final String COMMENT = "calibre2opds 2.3 cr1";
    private Properties properties;
    private File configurationDirectory;
    private File propertiesFile;
    private boolean readOnly = false;
    private StanzaDefaultConfiguration defaults = new StanzaDefaultConfiguration();
    private boolean wasReset = false;
    private List<String> tokenizedTagsToMakeDeep;

    public static void loadCurrentProfile() {
        String profile = DEFAULT.getCurrentConfiguration();
        if (!DEFAULT_CONFIGURATION.equalsIgnoreCase(profile)) {
            INSTANCE.setCurrentConfigurationAndLoad(profile);
        }
    }

    public boolean isCurrentConfigurationReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_CURRENTCONFIGURATION);
    }

    public String getCurrentConfiguration() {
        String s = DEFAULT.getProperty(PROPERTY_NAME_CURRENTCONFIGURATION);
        if (Helper.isNotNullOrEmpty((Object)s)) {
            return s;
        }
        return DEFAULT_CONFIGURATION;
    }

    public void setCurrentConfiguration(String value) {
        DEFAULT.setProperty(PROPERTY_NAME_CURRENTCONFIGURATION, value);
    }

    public void setCurrentConfigurationAndSave(String value) {
        this.setCurrentConfiguration(value);
        this.reload(false, true);
    }

    public void setCurrentConfigurationAndLoad(String value) {
        this.setCurrentConfiguration(value);
        this.reload(true, false);
    }

    public List<String> getExistingConfigurations() {
        File configurationFolder = this.getConfigurationDirectory();
        String[] files = configurationFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(StanzaConfiguration.PROFILES_SUFFIX);
            }
        });
        Vector<String> result = new Vector<String>();
        for (String file : files) {
            result.add(file.substring(0, file.toUpperCase().indexOf(PROFILES_SUFFIX)));
        }
        return result;
    }

    private void reload(boolean load, boolean save) {
        if (load) {
            this.tryAndLoadProperties(false);
        }
        if (save) {
            this.propertiesFile = this.getConfigurationFile(false);
            this.save();
        }
    }

    private StanzaConfiguration(boolean loadDefault) {
        this.properties = new Properties();
        this.wasReset = this.tryAndLoadProperties(loadDefault);
        Configuration.setConfiguration(this);
    }

    public void resetReadOnly() {
        TreeSet<Object> keys = new TreeSet<Object>(this.properties.keySet());
        for (Object e : keys) {
            String name = (String)e;
            if (!name.endsWith("_ReadOnly")) continue;
            this.properties.remove(name);
        }
    }

    public boolean wasReset() {
        return this.wasReset;
    }

    public void reset() {
        StanzaDefaultConfiguration defaults = new StanzaDefaultConfiguration();
        this.setLanguage(defaults.getLanguage());
        this.setCatalogFolderName(defaults.getCatalogFolderName());
        this.setMaxBeforePaginate(defaults.getMaxBeforePaginate());
        this.setBooksInRecentAdditions(defaults.getBooksInRecentAdditions());
        this.setWikipediaLanguage(defaults.getWikipediaLanguage());
        this.setIncludedFormatsList(defaults.getIncludedFormatsList());
        this.setSaveBandwith(defaults.saveBandwith());
        this.setThumbnailHeight(defaults.getThumbnailHeight());
        this.setGenerateHtml(defaults.generateHtml());
        this.setGenerateHtmlDownloads(defaults.generateHtmlDownloads());
        this.setGenerateDownloads(defaults.generateDownloads());
        this.setMaxBeforeSplit(defaults.getMaxBeforeSplit());
        this.setSplitTagsOn(defaults.getSplitTagsOn());
        this.setIncludeBooksWithNoFile(defaults.getIncludeBooksWithNoFile());
        this.setCryptFilenames(defaults.getCryptFilenames());
        this.setShowSeriesInAuthorCatalog(defaults.getShowSeriesInAuthorCatalog());
        this.setTagsToGenerate(defaults.getTagsToGenerate());
        this.setTagsToExclude(defaults.getTagsToExclude());
        this.setGenerateCrossLinks(defaults.generateCrossLinks());
        this.setGenerateExternalLinks(defaults.generateExternalLinks());
        this.setMaxSummaryLength(defaults.getMaxSummaryLength());
        this.setGenerateRatings(defaults.generateRatings());
        this.setGenerateAllbooks(defaults.generateAllbooks());
        this.setTargetFolder(defaults.getTargetFolder());
        this.setDeviceMode(defaults.getDeviceMode());
        this.setCopyToDatabaseFolder(defaults.getCopyToDatabaseFolder());
        this.setBrowseByCover(defaults.getBrowseByCover());
        this.setSplitByAuthorInitialGoToBooks(defaults.getSplitByAuthorInitialGoToBooks());
        this.setIncludeAboutLink(defaults.getIncludeAboutLink());
        this.setTagsToMakeDeep(defaults.getTagsToMakeDeep());
        this.setMinBooksToMakeDeepLevel(defaults.getMinBooksToMakeDeepLevel());
        this.setBrowseByCoverWithoutSplit(defaults.getBrowseByCoverWithoutSplit());
        this.setMaxCoverSize(defaults.getMaxCoverSize());
        this.setIncludeOnlyOneFile(defaults.getIncludeOnlyOneFile());
        this.setCompatibilityTrick(defaults.getCompatibilityTrick());
    }

    public void setConfigurationDirectory(File newDirectory) {
        this.configurationDirectory = newDirectory;
        this.propertiesFile = this.getConfigurationFile(false);
        this.save();
    }

    public File getConfigurationDirectory() {
        if (this.configurationDirectory == null) {
            this.configurationDirectory = StanzaConfiguration.getDefaultConfigurationDirectory();
        }
        return this.configurationDirectory;
    }

    public static File getDefaultConfigurationDirectory() {
        String userHomePath;
        String configDirectory;
        File configurationFolder = null;
        if ((configurationFolder == null || !configurationFolder.exists()) && Helper.isNotNullOrEmpty((Object)(configDirectory = System.getenv("CALIBRE2OPDS_CONFIG")))) {
            configurationFolder = new File(configDirectory);
        }
        if ((configurationFolder == null || !configurationFolder.exists()) && Helper.isNotNullOrEmpty((Object)(userHomePath = System.getProperty("user.home")))) {
            configurationFolder = new File(userHomePath);
        }
        if (configurationFolder == null || !configurationFolder.exists()) {
            configurationFolder = new File("~");
        }
        if (configurationFolder == null || !configurationFolder.exists()) {
            URL mySource = StanzaConfiguration.class.getProtectionDomain().getCodeSource().getLocation();
            File sourceFile = new File(mySource.getPath());
            configurationFolder = sourceFile.getParentFile();
        }
        if (configurationFolder != null && !(configurationFolder = new File(configurationFolder, CONFIGURATION_FOLDER)).exists()) {
            configurationFolder.mkdirs();
        }
        return configurationFolder;
    }

    public File getConfigurationFile(boolean loadDefault) {
        File configurationFolder = this.getConfigurationDirectory();
        if (configurationFolder != null && configurationFolder.exists()) {
            String filename = (loadDefault ? DEFAULT_CONFIGURATION : this.getCurrentConfiguration()) + ".profile.xml";
            return new File(configurationFolder, filename);
        }
        return null;
    }

    private boolean tryAndLoadProperties(boolean loadDefault) {
        this.propertiesFile = this.getConfigurationFile(loadDefault);
        if (this.propertiesFile.exists()) {
            return this.load();
        }
        this.reset();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load() {
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(this.propertiesFile));
                this.properties.loadFromXML(bis);
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("error while loading properties from " + this.propertiesFile.getAbsolutePath(), e);
        }
        String versionChip = this.getProperty(PROPERTY_NAME_VERSIONCHIP);
        if (versionChip == null) {
            this.reset();
            return true;
        }
        if (versionChip.compareTo("02020001") == -1) {
            this.reset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        if (this.readOnly) {
            return;
        }
        this.properties.setProperty(PROPERTY_NAME_VERSIONCHIP, "02020001");
        FilterOutputStream bos = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.propertiesFile));
                this.properties.storeToXML(bos, COMMENT);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("error while storing properties in " + this.propertiesFile.getAbsolutePath(), e);
        }
    }

    void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value.toString());
        }
        this.save();
    }

    void setProperty(String name, boolean value) {
        this.properties.setProperty(name, Boolean.toString(value));
        this.save();
    }

    void setProperty(String name, int value) {
        this.properties.setProperty(name, Integer.toString(value));
        this.save();
    }

    boolean isPropertyReadOnly(String name) {
        String readOnlyName = name + "_ReadOnly";
        return Helper.trueBoolean((Object)this.getBoolean(readOnlyName));
    }

    void setPropertyReadOnly(String name, boolean readOnly) {
        if (Helper.isNullOrEmpty((Object)name)) {
            return;
        }
        String readOnlyName = name + "_ReadOnly";
        this.setProperty(readOnlyName, readOnly);
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private Boolean getBoolean(String name) {
        String s = this.getProperty(name);
        if (s == null) {
            return null;
        }
        return new Boolean(s);
    }

    private Integer getInteger(String name) {
        return Helper.parseInteger((String)this.getProperty(name));
    }

    public DeviceMode getDeviceMode() {
        String s = this.getProperty(PROPERTY_NAME_DEVICEMODE);
        if (s == null) {
            return this.defaults.getDeviceMode();
        }
        return DeviceMode.fromName(s);
    }

    public void setDeviceMode(DeviceMode mode) {
        this.setProperty(PROPERTY_NAME_DEVICEMODE, (Object)mode);
        if (mode != null) {
            this.resetReadOnly();
            Object[] options = mode.getOptions();
            for (int i = 0; i < options.length; i += 3) {
                String optionName = (String)options[i];
                Object optionValue = options[i + 1];
                Boolean readOnly = (Boolean)options[i + 2];
                this.setProperty(optionName, optionValue);
                this.setPropertyReadOnly(optionName, readOnly);
            }
        } else {
            this.reset();
        }
    }

    public boolean isDatabaseFolderReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_DATABASEFOLDER);
    }

    @Override
    public File getDatabaseFolder() {
        String s = this.getProperty(PROPERTY_NAME_DATABASEFOLDER);
        if (Helper.isNotNullOrEmpty((Object)s)) {
            return new File(s);
        }
        return null;
    }

    public void setDatabaseFolder(File databaseFolder) {
        this.setProperty(PROPERTY_NAME_DATABASEFOLDER, databaseFolder.getAbsolutePath());
    }

    public boolean isTargetFolderReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_TARGETFOLDER);
    }

    public File getTargetFolder() {
        String s = this.getProperty(PROPERTY_NAME_TARGETFOLDER);
        if (Helper.isNotNullOrEmpty((Object)s)) {
            return new File(s);
        }
        return null;
    }

    public void setTargetFolder(File targetFolder) {
        this.setProperty(PROPERTY_NAME_TARGETFOLDER, targetFolder == null ? null : targetFolder.getAbsolutePath());
    }

    public boolean isLanguageReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_LANGUAGE);
    }

    public String getLanguage() {
        String s = this.getProperty(PROPERTY_NAME_LANGUAGE);
        if (Helper.isNullOrEmpty((Object)s)) {
            return this.defaults.getLanguage();
        }
        return s;
    }

    public void setLanguage(String language) {
        this.setProperty(PROPERTY_NAME_LANGUAGE, language);
    }

    public boolean isWikipediaLanguageReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_WIKIPEDIALANGUAGE);
    }

    public String getWikipediaLanguage() {
        String s = this.getProperty(PROPERTY_NAME_WIKIPEDIALANGUAGE);
        if (s == null) {
            return this.defaults.getWikipediaLanguage();
        }
        return s;
    }

    public void setWikipediaLanguage(String wikipediaLanguage) {
        this.setProperty(PROPERTY_NAME_WIKIPEDIALANGUAGE, wikipediaLanguage);
    }

    public boolean isCatalogFolderNameReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_CATALOGFOLDERNAME);
    }

    public String getCatalogFolderName() {
        String s = this.getProperty(PROPERTY_NAME_CATALOGFOLDERNAME);
        if (s == null) {
            return this.defaults.getCatalogFolderName();
        }
        return s;
    }

    public void setCatalogFolderName(String catalogFolderName) {
        this.setProperty(PROPERTY_NAME_CATALOGFOLDERNAME, catalogFolderName);
    }

    public boolean isCatalogTitleReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_CATALOGTITLE);
    }

    public String getCatalogTitle() {
        String s = this.getProperty(PROPERTY_NAME_CATALOGTITLE);
        if (s == null) {
            return this.defaults.getCatalogTitle();
        }
        return s;
    }

    public void setCatalogTitle(String catalogTitle) {
        this.setProperty(PROPERTY_NAME_CATALOGTITLE, catalogTitle);
    }

    public boolean isMaxBeforePaginateReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_MAXBEFOREPAGINATE);
    }

    public int getMaxBeforePaginate() {
        Integer i = this.getInteger(PROPERTY_NAME_MAXBEFOREPAGINATE);
        if (i == null) {
            return this.defaults.getMaxBeforePaginate();
        }
        return i;
    }

    public void setMaxBeforePaginate(int maxBeforePaginate) {
        this.setProperty(PROPERTY_NAME_MAXBEFOREPAGINATE, maxBeforePaginate);
    }

    public boolean isMaxBeforeSplitReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_MAXBEFORESPLIT);
    }

    public int getMaxBeforeSplit() {
        Integer i = this.getInteger(PROPERTY_NAME_MAXBEFORESPLIT);
        if (i == null) {
            return this.defaults.getMaxBeforeSplit();
        }
        return i;
    }

    public void setMaxBeforeSplit(int maxBeforeSplit) {
        this.setProperty(PROPERTY_NAME_MAXBEFORESPLIT, maxBeforeSplit);
    }

    public boolean isBooksInRecentAdditionsReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_BOOKSINRECENTADDITIONS);
    }

    public int getBooksInRecentAdditions() {
        Integer i = this.getInteger(PROPERTY_NAME_BOOKSINRECENTADDITIONS);
        if (i == null) {
            return this.defaults.getBooksInRecentAdditions();
        }
        return i;
    }

    public void setBooksInRecentAdditions(int booksInRecentAdditions) {
        this.setProperty(PROPERTY_NAME_BOOKSINRECENTADDITIONS, booksInRecentAdditions);
    }

    public boolean isIncludedFormatsListReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_INCLUDEDFORMATSLIST);
    }

    public String getIncludedFormatsList() {
        String s = this.getProperty(PROPERTY_NAME_INCLUDEDFORMATSLIST);
        if (s == null) {
            return this.defaults.getIncludedFormatsList();
        }
        return s;
    }

    public void setIncludedFormatsList(String includedFormatsList) {
        this.setProperty(PROPERTY_NAME_INCLUDEDFORMATSLIST, includedFormatsList);
    }

    public boolean isSaveBandwithReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_SAVEBANDWITH);
    }

    public boolean saveBandwith() {
        Boolean b = this.getBoolean(PROPERTY_NAME_SAVEBANDWITH);
        if (b == null) {
            return this.defaults.saveBandwith();
        }
        return b;
    }

    public void setSaveBandwith(boolean saveBandwith) {
        this.setProperty(PROPERTY_NAME_SAVEBANDWITH, saveBandwith);
    }

    public boolean isGenerateHtmlReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATEHTML);
    }

    public boolean generateHtml() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATEHTML);
        if (b == null) {
            return this.defaults.generateHtml();
        }
        return b;
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.setProperty(PROPERTY_NAME_GENERATEHTML, generateHtml);
    }

    public boolean isGenerateHtmlDownloadsReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATEHTMLDOWNLOADS);
    }

    public boolean generateHtmlDownloads() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATEHTMLDOWNLOADS);
        if (b == null) {
            return this.defaults.generateHtmlDownloads();
        }
        return b;
    }

    public void setGenerateHtmlDownloads(boolean generateHtmlDownloads) {
        this.setProperty(PROPERTY_NAME_GENERATEHTMLDOWNLOADS, generateHtmlDownloads);
    }

    public void setSuppressRatingsInTitles(boolean supressRatingsInTitles) {
        this.setProperty(PROPERTY_NAME_SUPRESSRATINGSINTITLES, supressRatingsInTitles);
    }

    public boolean isSupressRatingsInTitlesReadyOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_SUPRESSRATINGSINTITLES);
    }

    public boolean suppressRatingsInTitles() {
        Boolean b = this.getBoolean(PROPERTY_NAME_SUPRESSRATINGSINTITLES);
        if (b == null) {
            return this.defaults.suppressRatingsInTitles();
        }
        return b;
    }

    public boolean isGenerateDownloadsReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATEDOWNLOADS);
    }

    public boolean generateDownloads() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATEDOWNLOADS);
        if (b == null) {
            return this.defaults.generateDownloads();
        }
        return b;
    }

    public void setGenerateDownloads(boolean generateDownloads) {
        this.setProperty(PROPERTY_NAME_GENERATEDOWNLOADS, generateDownloads);
    }

    public boolean isThumbnailHeightReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_THUMBNAILHEIGHT);
    }

    public int getThumbnailHeight() {
        Integer i = this.getInteger(PROPERTY_NAME_THUMBNAILHEIGHT);
        if (i == null) {
            return this.defaults.getThumbnailHeight();
        }
        return i;
    }

    public void setThumbnailHeight(int thumbnailHeight) {
        this.setProperty(PROPERTY_NAME_THUMBNAILHEIGHT, thumbnailHeight);
    }

    public boolean isSplitTagsOnReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_SPLITTAGSON);
    }

    public String getSplitTagsOn() {
        String s = this.getProperty(PROPERTY_NAME_SPLITTAGSON);
        if (s == null) {
            return this.defaults.getSplitTagsOn();
        }
        return s;
    }

    public void setSplitTagsOn(String splitTagsOn) {
        this.setProperty(PROPERTY_NAME_SPLITTAGSON, splitTagsOn);
    }

    public boolean isIncludeBooksWithNoFileReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_INCLUDEBOOKSWITHNOFILE);
    }

    public boolean getIncludeBooksWithNoFile() {
        Boolean b = this.getBoolean(PROPERTY_NAME_INCLUDEBOOKSWITHNOFILE);
        if (b == null) {
            return this.defaults.getIncludeBooksWithNoFile();
        }
        return b;
    }

    public void setIncludeBooksWithNoFile(boolean value) {
        this.setProperty(PROPERTY_NAME_INCLUDEBOOKSWITHNOFILE, value);
    }

    public boolean isBookLanguageTagReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_BOOKLANGUAGETAG);
    }

    public String getBookLanguageTag() {
        String s = this.getProperty(PROPERTY_NAME_BOOKLANGUAGETAG);
        if (s == null) {
            return this.defaults.getBookLanguageTag();
        }
        return s;
    }

    public void setBookLanguageTag(String value) {
        this.setProperty(PROPERTY_NAME_BOOKLANGUAGETAG, value);
    }

    public boolean isCryptFilenamesReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_CRYPTFILENAMES);
    }

    public boolean getCryptFilenames() {
        Boolean b = this.getBoolean(PROPERTY_NAME_CRYPTFILENAMES);
        if (b == null) {
            return this.defaults.getCryptFilenames();
        }
        return b;
    }

    public void setCryptFilenames(boolean value) {
        this.setProperty(PROPERTY_NAME_CRYPTFILENAMES, value);
    }

    public boolean isShowSeriesInAuthorCatalogReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_SHOWSERIESINAUTHORCATALOG);
    }

    public boolean getShowSeriesInAuthorCatalog() {
        Boolean b = this.getBoolean(PROPERTY_NAME_SHOWSERIESINAUTHORCATALOG);
        if (b == null) {
            return this.defaults.getShowSeriesInAuthorCatalog();
        }
        return b;
    }

    public void setShowSeriesInAuthorCatalog(boolean value) {
        this.setProperty(PROPERTY_NAME_SHOWSERIESINAUTHORCATALOG, value);
    }

    public boolean isGenerateExternalLinksReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATEEXTERNALLINKS);
    }

    public boolean generateExternalLinks() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATEEXTERNALLINKS);
        if (b == null) {
            return this.defaults.generateExternalLinks();
        }
        return b;
    }

    public void setGenerateExternalLinks(boolean value) {
        this.setProperty(PROPERTY_NAME_GENERATEEXTERNALLINKS, value);
    }

    public boolean isGenerateCrossLinksReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATECROSSLINKS);
    }

    public boolean generateCrossLinks() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATECROSSLINKS);
        if (b == null) {
            return this.defaults.generateCrossLinks();
        }
        return b;
    }

    public void setGenerateCrossLinks(boolean value) {
        this.setProperty(PROPERTY_NAME_GENERATECROSSLINKS, value);
    }

    public boolean isTagsToGenerateReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_TAGSTOGENERATE);
    }

    public String getTagsToGenerate() {
        String s = this.getProperty(PROPERTY_NAME_TAGSTOGENERATE);
        if (s == null) {
            return this.defaults.getTagsToGenerate();
        }
        return s;
    }

    public void setTagsToGenerate(String value) {
        this.setProperty(PROPERTY_NAME_TAGSTOGENERATE, value);
    }

    public boolean isTagsToExcludeReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_TAGSTOEXCLUDE);
    }

    public String getTagsToExclude() {
        String s = this.getProperty(PROPERTY_NAME_TAGSTOEXCLUDE);
        if (s == null) {
            return this.defaults.getTagsToExclude();
        }
        return s;
    }

    public void setTagsToExclude(String value) {
        this.setProperty(PROPERTY_NAME_TAGSTOEXCLUDE, value);
    }

    public boolean isMaxSummaryLengthReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_MAXSUMMARYLENGTH);
    }

    public int getMaxSummaryLength() {
        Integer i = this.getInteger(PROPERTY_NAME_MAXSUMMARYLENGTH);
        if (i == null) {
            return this.defaults.getMaxSummaryLength();
        }
        return i;
    }

    public void setMaxSummaryLength(int value) {
        this.setProperty(PROPERTY_NAME_MAXSUMMARYLENGTH, value);
    }

    public boolean isGenerateRatingsReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATERATINGS);
    }

    public boolean generateRatings() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATERATINGS);
        if (b == null) {
            return this.defaults.generateRatings();
        }
        return b;
    }

    public void setGenerateRatings(boolean value) {
        this.setProperty(PROPERTY_NAME_GENERATERATINGS, value);
    }

    public boolean isGenerateAllbooksReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_GENERATEALLBOOKS);
    }

    public boolean generateAllbooks() {
        Boolean b = this.getBoolean(PROPERTY_NAME_GENERATEALLBOOKS);
        if (b == null) {
            return this.defaults.generateAllbooks();
        }
        return b;
    }

    public void setGenerateAllbooks(boolean value) {
        this.setProperty(PROPERTY_NAME_GENERATEALLBOOKS, value);
    }

    public boolean isCopyToDatabaseFolderReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_COPYTODATABASEFOLDER);
    }

    public boolean getCopyToDatabaseFolder() {
        Boolean b = this.getBoolean(PROPERTY_NAME_COPYTODATABASEFOLDER);
        if (b == null) {
            return this.defaults.getCopyToDatabaseFolder();
        }
        return b;
    }

    public void setCopyToDatabaseFolder(boolean value) {
        this.setProperty(PROPERTY_NAME_COPYTODATABASEFOLDER, value);
    }

    public boolean isBrowseByCoverReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_BROWSEBYCOVER);
    }

    public boolean getBrowseByCover() {
        Boolean b = this.getBoolean(PROPERTY_NAME_BROWSEBYCOVER);
        if (b == null) {
            return this.defaults.getBrowseByCover();
        }
        return b;
    }

    public void setBrowseByCover(boolean value) {
        this.setProperty(PROPERTY_NAME_BROWSEBYCOVER, value);
    }

    public boolean isSplitByAuthorInitialGoToBooksReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_SPLITBYAUTHORINITIALGOTOBOOK);
    }

    public boolean getSplitByAuthorInitialGoToBooks() {
        Boolean b = this.getBoolean(PROPERTY_NAME_SPLITBYAUTHORINITIALGOTOBOOK);
        if (b == null) {
            return this.defaults.getSplitByAuthorInitialGoToBooks();
        }
        return b;
    }

    public void setSplitByAuthorInitialGoToBooks(boolean value) {
        this.setProperty(PROPERTY_NAME_SPLITBYAUTHORINITIALGOTOBOOK, value);
    }

    public boolean isIncludeAboutLinkReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_INCLUDEABOUTLINK);
    }

    public boolean getIncludeAboutLink() {
        Boolean b = this.getBoolean(PROPERTY_NAME_INCLUDEABOUTLINK);
        if (b == null) {
            return this.defaults.getIncludeAboutLink();
        }
        return b;
    }

    public void setIncludeAboutLink(boolean value) {
        this.setProperty(PROPERTY_NAME_INCLUDEABOUTLINK, value);
    }

    public boolean isTagsToMakeDeepReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_TAGSTOMAKEDEEP);
    }

    public List<String> getTokenizedTagsToMakeDeep() {
        if (this.tokenizedTagsToMakeDeep == null) {
            this.tokenizedTagsToMakeDeep = Helper.tokenize((String)this.getTagsToMakeDeep().toUpperCase(), (String)",", (boolean)true);
        }
        return this.tokenizedTagsToMakeDeep;
    }

    public String getTagsToMakeDeep() {
        String s = this.getProperty(PROPERTY_NAME_TAGSTOMAKEDEEP);
        if (s == null) {
            return this.defaults.getTagsToMakeDeep();
        }
        return s;
    }

    public void setTagsToMakeDeep(String value) {
        this.setProperty(PROPERTY_NAME_TAGSTOMAKEDEEP, value);
        this.tokenizedTagsToMakeDeep = null;
    }

    public boolean isMinBooksToMakeDeepLevelReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_MINBOOKSTOMAKEDEEPLEVEL);
    }

    public int getMinBooksToMakeDeepLevel() {
        Integer i = this.getInteger(PROPERTY_NAME_MINBOOKSTOMAKEDEEPLEVEL);
        if (i == null) {
            return this.defaults.getMinBooksToMakeDeepLevel();
        }
        return i;
    }

    public void setMinBooksToMakeDeepLevel(int value) {
        this.setProperty(PROPERTY_NAME_MINBOOKSTOMAKEDEEPLEVEL, value);
    }

    public boolean isBrowseByCoverWithoutSplitReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_BROWSEBYCOVERWITHOUTSPLIT);
    }

    public boolean getBrowseByCoverWithoutSplit() {
        Boolean b = this.getBoolean(PROPERTY_NAME_BROWSEBYCOVERWITHOUTSPLIT);
        if (b == null) {
            return this.defaults.getBrowseByCoverWithoutSplit();
        }
        return b;
    }

    public void setBrowseByCoverWithoutSplit(boolean value) {
        this.setProperty(PROPERTY_NAME_BROWSEBYCOVERWITHOUTSPLIT, value);
    }

    public boolean isMaxCoverSizeReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_MAXCOVERSIZE);
    }

    public int getMaxCoverSize() {
        Integer i = this.getInteger(PROPERTY_NAME_MAXCOVERSIZE);
        if (i == null) {
            return this.defaults.getMaxCoverSize();
        }
        return i;
    }

    public void setMaxCoverSize(int maxCoverSize) {
        this.setProperty(PROPERTY_NAME_MAXCOVERSIZE, maxCoverSize);
    }

    public boolean isIncludeOnlyOneFileReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_INCLUDEONLYONEFILE);
    }

    public boolean getIncludeOnlyOneFile() {
        Boolean b = this.getBoolean(PROPERTY_NAME_INCLUDEONLYONEFILE);
        if (b == null) {
            return this.defaults.getIncludeOnlyOneFile();
        }
        return b;
    }

    public void setIncludeOnlyOneFile(boolean value) {
        this.setProperty(PROPERTY_NAME_INCLUDEONLYONEFILE, value);
    }

    public boolean isCompatibilityTrickReadOnly() {
        return this.isPropertyReadOnly(PROPERTY_NAME_COMPATIBILITYTRICK);
    }

    public CompatibilityTrick getCompatibilityTrick() {
        String s = this.getProperty(PROPERTY_NAME_COMPATIBILITYTRICK);
        if (s == null) {
            return this.defaults.getCompatibilityTrick();
        }
        return CompatibilityTrick.fromString(s);
    }

    public void setCompatibilityTrick(CompatibilityTrick value) {
        this.setProperty(PROPERTY_NAME_COMPATIBILITYTRICK, value.toString());
    }

    static {
        logger = Logger.getLogger(StanzaConfiguration.class);
    }
}

