from calibre.ptempfile import PersistentTemporaryFile

class Alternet(BasicNewsRecipe):
    title          = u'Alternet'
    __author__= 'rty'
    oldest_article = 7
    max_articles_per_feed = 100
    publisher = 'alternet.org'
    category = 'News, Magazine'
    description = 'News magazine and online community'
    feeds          = [
	(u'Front Page', u'http://feeds.feedblitz.com/alternet'), 
	(u'Breaking News', u'http://feeds.feedblitz.com/alternet_breaking_news'), 
	(u'Top Ten Campaigns', u'http://feeds.feedblitz.com/alternet_top_10_campaigns'), 
	(u'Special Coverage Areas', u'http://feeds.feedblitz.com/alternet_coverage')
	]
    remove_attributes = ['width', 'align','cellspacing']
    remove_javascript = True
    use_embedded_content   = False
    no_stylesheets = True
    language = 'en'
    encoding               = 'UTF-8'
    temp_files = []
    articles_are_obfuscated = True

    def get_article_url(self, article):
       return article.get('link',  None)

    def get_obfuscated_article(self, url):
        br = self.get_browser()
        br.open(url)
        response = br.follow_link(url_regex = r'/printversion/[0-9]+', nr = 0) 
        html = response.read()
        self.temp_files.append(PersistentTemporaryFile('_fa.html'))
        self.temp_files[-1].write(html)
        self.temp_files[-1].close()
        return self.temp_files[-1].name