/*
 * Decompiled with CFR 0.152.
 */
package common.image;

import common.image.ImageUtils;
import java.awt.Color;

public class PixelData {
    private int x;
    private int y;
    private Color color;
    private int gray_level;
    private int binary_level;
    private boolean is_grayscale;

    public PixelData(int x, int y, Color color) {
        this.x = x;
        this.y = y;
        this.color = color;
        this.gray_level = ImageUtils.getGrayLevelFromRGB(color);
        this.binary_level = ImageUtils.getBinaryLevelFromGrayLevel(this.gray_level);
        this.is_grayscale = ImageUtils.isRGBColorGrayscale(color);
    }

    public boolean isPixelDataWithinColorThreshold(PixelData comp_pd, int threshold) {
        Color cur_pd_color = this.getColor();
        Color comp_pd_color = comp_pd.getColor();
        int total_difference = 0;
        total_difference += Math.abs(cur_pd_color.getRed() - comp_pd_color.getRed());
        total_difference += Math.abs(cur_pd_color.getGreen() - comp_pd_color.getGreen());
        return (total_difference += Math.abs(cur_pd_color.getBlue() - comp_pd_color.getBlue())) <= threshold;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Color getColor() {
        return this.color;
    }

    public int getGrayLevel() {
        return this.gray_level;
    }

    public int getBinaryLevel() {
        return this.binary_level;
    }

    public boolean isGrayscale() {
        return this.is_grayscale;
    }

    public String toString() {
        return "x:" + this.x + ", y:" + this.y + ", color:[r=" + this.color.getRed() + ",g=" + this.color.getGreen() + ",b=" + this.color.getBlue() + "], is_grayscale:" + this.is_grayscale + ", gray_level:" + this.gray_level + ", binary_level:" + this.binary_level;
    }
}

