/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageData;
import common.image.ImageMagick;
import common.image.ImageUtils;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.JarUtils;
import common.utils.StopWatch;
import common.utils.SystemRar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipOutputStream;
import manga.CMPropertiesWriter;
import manga.EpubMaker;
import manga.PropertiesLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertManga {
    public static final String PROGRAM_VERSION = "1.82";
    public static final String RELEASED_DATE = "July 14, 2010";
    private static String default_kindle_bookmark = "/manga/kindle/default.manga";

    public static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> backcover_image_files = new ArrayList<File>();
        ArrayList<File> insert_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            char first_char = cur_image.getName().charAt(0);
            if (!Character.isDigit(first_char)) {
                if (cur_image.getName().toLowerCase().contains("cover")) {
                    image_files.remove(i);
                    if (cur_image.getName().toLowerCase().contains("back")) {
                        backcover_image_files.add(cur_image);
                    } else {
                        cover_image_files.add(cur_image);
                    }
                    --i;
                } else if (cur_image.getName().toLowerCase().contains("insert")) {
                    image_files.remove(i);
                    insert_image_files.add(cur_image);
                    --i;
                } else if (cur_image.getName().toLowerCase().contains("credit")) {
                    image_files.remove(i);
                    credit_image_files.add(cur_image);
                    --i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < insert_image_files.size()) {
            image_files.add(cover_image_files.size(), (File)insert_image_files.get(insert_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < backcover_image_files.size()) {
            image_files.add((File)backcover_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    public static void renameSplitPages(File folder, int page_filename_length) {
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        int i = image_files.size() - 1;
        while (i >= 0) {
            File cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            --i;
        }
    }

    private static ArrayList<Integer> processBindFile(File bind_file) {
        ArrayList<Integer> binds = new ArrayList<Integer>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(bind_file));
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                line = line.replaceAll(" ", "");
                if ((line = line.replaceAll("\t", "")).equals("") || line.charAt(0) == '#' || line.charAt(0) == '/') continue;
                binds.add(Integer.parseInt(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return binds;
    }

    private static void bindFolders(ArrayList<File> folders, File bind_folder, String output_folder_filename, ImageMagick im, String title, boolean use_zip, String zip_extension, boolean use_rar, String rar_extension, SystemRar sysrar, boolean use_pdf, boolean pdf_r_to_l, boolean use_kindle_bookmark, boolean use_comic_zeal_naming, boolean use_epub, boolean epub_r_to_l, int page_filename_length) {
        if (folders.isEmpty() || folders.size() == 0) {
            return;
        }
        int next_starting_number = 0;
        int i = 0;
        while (i < folders.size()) {
            File cur_folder = folders.get(i);
            ArrayList<File> cur_folder_image_list = FileUtils.getImageFileList(cur_folder);
            Collections.sort(cur_folder_image_list);
            int j = 0;
            while (j < cur_folder_image_list.size()) {
                File cur_image = cur_folder_image_list.get(j);
                String extension = ExtFilter.getExtension(cur_image);
                String new_name = Integer.toString(next_starting_number + j);
                while (new_name.length() < page_filename_length) {
                    new_name = "0" + new_name;
                }
                try {
                    FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + new_name + extension));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_folder_image_list.size();
            ++i;
        }
        if (use_kindle_bookmark) {
            ArrayList<File> bind_folder_image_list = FileUtils.getImageFileList(bind_folder);
            Collections.sort(bind_folder_image_list);
            File bookmark_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga_save");
            ConvertManga.writeBookmark(bind_folder, bookmark_file, bookmark_save_file, bind_folder_image_list.get(0));
        }
        String zip_file_filename = null;
        String rar_file_filename = null;
        if (use_comic_zeal_naming) {
            zip_file_filename = String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + zip_extension;
            rar_file_filename = String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + rar_extension;
        } else {
            zip_file_filename = String.valueOf(output_folder_filename) + bind_folder.getName() + zip_extension;
            rar_file_filename = String.valueOf(output_folder_filename) + bind_folder.getName() + rar_extension;
        }
        File zip_file = new File(zip_file_filename);
        File rar_file = new File(rar_file_filename);
        File pdf_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".pdf");
        File epub_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".epub");
        if (use_zip) {
            FileUtils.zipFolder(bind_folder, zip_file);
        }
        if (use_rar) {
            sysrar.rarFolder(bind_folder, rar_file);
        }
        if (use_pdf) {
            if (pdf_r_to_l) {
                File tmp_r_to_l_folder = new File(String.valueOf(bind_folder.getParent()) + File.separatorChar + bind_folder.getName() + "_TMP_R_TO_L");
                ConvertManga.createFolderOfRToLPages(bind_folder, tmp_r_to_l_folder, page_filename_length);
                im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                FileUtils.deleteDirectory(tmp_r_to_l_folder);
            } else {
                im.pdfImageFolder(bind_folder, pdf_file);
            }
        }
        if (use_epub) {
            EpubMaker em = new EpubMaker(bind_folder.getName(), epub_file, folders, page_filename_length, epub_r_to_l);
            em.makeEpub();
        }
    }

    public static void writeBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            JarUtils ju = new JarUtils();
            ju.copyJarFileToFilesystem(default_kindle_bookmark, bookmark_file);
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outputUsage() {
        System.out.println("\nCanti v1.82");
        System.out.println("Released: July 14, 2010");
        System.out.println("Author: Andrew Mantel");
        System.out.println("Purpose: Process a collection of manga scans for ereader devices.");
        System.out.println("Usage: java -jar Canti.jar [mandatory_arguments] [other_options]");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder /path/to/parent_folder/");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-title \"Manga Title\"");
        System.out.println("  Title of the manga, such as \"School Rumble\".");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-manga_prefix \"[manga_prefix]\"");
        System.out.println("  This is placed after the manga title but before the subfolder suffix.");
        System.out.println("  Recommended value is something like \"Ch.\" or \"Vol.\" so that the output will look like \"School_Rumble_-_Ch.001\"");
        System.out.println("-bind_prefix \"[bind_prefix]\"");
        System.out.println("  This is places after the manga title but before the binding number of bound manga.");
        System.out.println("  Recommend value is something like \"Vol.\" or \"Bind.\" so that the output will look like \"School_Rumble_-_Vol.1\"");
        System.out.println("  If not specified, the default value is \"Vol.\"");
        System.out.println("-output_folder /path/to/output_folder/");
        System.out.println("  The output parent folder. If not specified, default is an \"OUT\" folder created one directory above -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("  If you do not set this, or set this to -1, then the program will attempt to auto sense the suffix.");
        System.out.println("  Note that if using auto suffix sensing then each manga folder must end with a number such as 1, 001, 1.11, 001.11, or 01-10 for this to work properly).");
        System.out.println("\nCreating a default .properties file:");
        System.out.println("Usage: java -jar Canti.jar -create_properties [device name]");
        System.out.println("  The program will create a default .properties file for your particular ereader device.");
        System.out.println("  No manga will be processed when you use this option. This will create the default .properties file and then exit.");
        System.out.println("  Acceptable [device name] values: " + CMPropertiesWriter.getSupportedDevices());
        System.out.println("  If you don't see your device listed under Acceptable values, enter \"default\" for [device name] and edit the generated .properties file with the proper settings for your device.");
        System.out.println("\nSee Canti.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("");
        System.exit(0);
    }

    private static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_path = folder.getAbsolutePath();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                if (!line.equals(folder_path)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    private static void verifyProgressFile(File progress_file) {
        ArrayList<File> processed_folders = new ArrayList<File>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                processed_folders.add(new File(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<File> processed_folders_exists = new ArrayList<File>();
        int i = 0;
        while (i < processed_folders.size()) {
            File cur_processed_folder = (File)processed_folders.get(i);
            if (cur_processed_folder.exists()) {
                processed_folders_exists.add(cur_processed_folder);
            }
            ++i;
        }
        if (processed_folders_exists.size() < processed_folders.size()) {
            progress_file.delete();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file));
                int i2 = 0;
                while (i2 < processed_folders_exists.size()) {
                    bw.write(String.valueOf(((File)processed_folders_exists.get(i2)).getAbsolutePath()) + "\n");
                    ++i2;
                }
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getAbsolutePath()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String removeLeadingZeros(String str) {
        String mod_str = str;
        boolean done_leading_zeros = false;
        while (!done_leading_zeros && mod_str.length() >= 2) {
            char cur_char = mod_str.charAt(0);
            char next_char = mod_str.charAt(1);
            if (cur_char == '0') {
                if (Character.isDigit(next_char)) {
                    mod_str = mod_str.substring(1);
                    continue;
                }
                done_leading_zeros = true;
                continue;
            }
            done_leading_zeros = true;
        }
        return mod_str;
    }

    public static String getFileNumberSuffix(File fh, boolean is_directory) {
        char cur_char;
        boolean done = false;
        boolean found_decimal = false;
        boolean found_hyphen = false;
        String filename = null;
        String suffix = "";
        filename = is_directory ? fh.getName() : ExtFilter.getNameWithoutExtension(fh);
        int j = 0;
        while (!done && j < filename.length()) {
            cur_char = filename.charAt(filename.length() - 1 - j);
            if (cur_char == '.') {
                if (!found_decimal) {
                    int next_char_index = filename.length() - 2 - j;
                    if (next_char_index >= 0) {
                        char next_char = filename.charAt(next_char_index);
                        if (Character.isDigit(next_char) || next_char == '_' || next_char == ' ' || next_char == '-' && !found_hyphen) {
                            suffix = String.valueOf(cur_char) + suffix;
                            found_decimal = true;
                        } else {
                            done = true;
                        }
                    } else {
                        suffix = String.valueOf(cur_char) + suffix;
                        found_decimal = true;
                    }
                } else {
                    done = true;
                }
            } else if (cur_char == '-') {
                if (!found_hyphen) {
                    suffix = String.valueOf(cur_char) + suffix;
                    found_decimal = false;
                    found_hyphen = true;
                } else {
                    done = true;
                }
            } else if (Character.isDigit(cur_char) || cur_char == ' ' || cur_char == '_') {
                suffix = String.valueOf(cur_char) + suffix;
            } else {
                done = true;
            }
            ++j;
        }
        suffix = suffix.replaceAll(" ", "");
        suffix = suffix.replaceAll("_", "");
        boolean done_leading = false;
        while (!done_leading && !suffix.isEmpty()) {
            cur_char = suffix.charAt(0);
            if (Character.isDigit(cur_char)) {
                done_leading = true;
                continue;
            }
            if (cur_char == '.') {
                int hyphen_index = suffix.indexOf(45);
                int decimal_range_index = hyphen_index < 0 ? suffix.length() : hyphen_index;
                boolean found_another_decimal = false;
                int i = 1;
                while (!found_another_decimal && i < decimal_range_index) {
                    if (suffix.charAt(i) == '.') {
                        suffix = suffix.substring(1);
                        found_another_decimal = true;
                    }
                    ++i;
                }
                if (found_another_decimal) continue;
                done_leading = true;
                continue;
            }
            suffix = suffix.length() == 1 ? "" : suffix.substring(1);
        }
        int hyphen_index = suffix.indexOf(45);
        if (hyphen_index == -1) {
            suffix = ConvertManga.removeLeadingZeros(suffix);
        } else {
            String suffix_before_hyphen = suffix.substring(0, hyphen_index);
            String suffix_after_hyphen = suffix.substring(hyphen_index + 1);
            suffix_before_hyphen = ConvertManga.removeLeadingZeros(suffix_before_hyphen);
            suffix_after_hyphen = ConvertManga.removeLeadingZeros(suffix_after_hyphen);
            suffix = String.valueOf(suffix_before_hyphen) + "-" + suffix_after_hyphen;
        }
        if (suffix.length() >= 1 && suffix.charAt(0) == '.') {
            suffix = String.valueOf('0') + suffix;
        }
        return suffix;
    }

    public static void createFolderOfRToLPages(File in_folder, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        ArrayList<File> in_folder_images = FileUtils.getImageFileList(in_folder);
        Collections.sort(in_folder_images);
        int i = 0;
        while (i < in_folder_images.size()) {
            File cur_image = in_folder_images.get(i);
            String cur_image_ext = ExtFilter.getExtension(cur_image);
            String new_filename_noext = Integer.toString(in_folder_images.size() - 1 - i);
            while (new_filename_noext.length() < page_filename_length) {
                new_filename_noext = "0" + new_filename_noext;
            }
            File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
            try {
                FileUtils.copyFile(cur_image, new_image);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void createFolderOfRToLPages(ArrayList<File> in_folders, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        Collections.sort(in_folders);
        int next_starting_number = 0;
        int i = 0;
        while (i < in_folders.size()) {
            File cur_in_folder = in_folders.get(in_folders.size() - 1 - i);
            ArrayList<File> cur_in_folder_images = FileUtils.getImageFileList(cur_in_folder);
            Collections.sort(cur_in_folder_images);
            int j = 0;
            while (j < cur_in_folder_images.size()) {
                File cur_image = cur_in_folder_images.get(j);
                String cur_image_ext = ExtFilter.getExtension(cur_image);
                String new_filename_noext = Integer.toString(cur_in_folder_images.size() - 1 - j + next_starting_number);
                while (new_filename_noext.length() < page_filename_length) {
                    new_filename_noext = "0" + new_filename_noext;
                }
                File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
                try {
                    FileUtils.copyFile(cur_image, new_image);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_in_folder_images.size();
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        boolean use_auto_bind;
        File cur_folder;
        File cur_tmp_folder;
        String parent_folder_filename = null;
        String output_folder_filename = null;
        String title = null;
        String manga_prefix = "";
        String bind_prefix = "Vol.";
        String prefix = null;
        File progress_file = null;
        File bind_file = null;
        File parent_folder_file = null;
        File output_folder_file = null;
        File properties_file = new File("Canti.properties");
        boolean use_bind = false;
        boolean single_folder_mode = false;
        boolean auto_sense_suffix = false;
        boolean user_set_manga_prefix = false;
        int num_chars_keep_suffix = -1;
        PropertiesLoader pl = null;
        ArrayList<Object> binds = new ArrayList();
        ArrayList<String> suffixes = new ArrayList<String>();
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else if (args.length % 2 != 0) {
            System.out.println("ERROR: Invalid number of arguments.");
            ConvertManga.outputUsage();
        } else if (args.length == 2 && args[0].equalsIgnoreCase("-create_properties")) {
            String device = args[1].trim().toLowerCase();
            System.out.println("\nWriting .properties file for " + device + " device, then exiting...");
            CMPropertiesWriter.writePropertiesFile(device);
            if (properties_file.exists()) {
                System.out.println("Finished writing default .properties file.");
                System.out.println("Please read through " + properties_file.getAbsolutePath() + " to see if there are any default settings you would like changed.");
            } else {
                System.out.println("ERROR: Cannot find created .properties file. There must have been a problem during file creation.");
            }
            System.exit(0);
        } else {
            if (properties_file.exists()) {
                pl = new PropertiesLoader(properties_file);
            }
            boolean parsed_parent_folder = false;
            boolean parsed_title = false;
            int i = 0;
            while (i < args.length) {
                String option = args[i];
                String option_value = args[++i];
                if (option.equalsIgnoreCase("-parent_folder")) {
                    parent_folder_filename = option_value;
                    if (parent_folder_filename.charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                        parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                    }
                    parsed_parent_folder = true;
                } else if (option.equalsIgnoreCase("-title")) {
                    title = option_value;
                    title = title.replaceAll(" ", "_");
                    parsed_title = true;
                } else if (option.equalsIgnoreCase("-manga_prefix")) {
                    manga_prefix = option_value;
                    manga_prefix = manga_prefix.replaceAll(" ", "_");
                    user_set_manga_prefix = true;
                } else if (option.equalsIgnoreCase("-bind_prefix")) {
                    bind_prefix = option_value;
                    bind_prefix = bind_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                    num_chars_keep_suffix = Integer.parseInt(option_value);
                } else if (option.equalsIgnoreCase("-output_folder")) {
                    output_folder_filename = option_value;
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                } else if (option.equalsIgnoreCase("-create_properties")) {
                    System.out.println("ERROR: When using -create_properties you cannot set any other options.");
                    System.exit(1);
                } else {
                    System.out.println("ERROR: Invalid option \"" + option + "\"");
                    ConvertManga.outputUsage();
                }
                ++i;
            }
            if (!parsed_parent_folder || !parsed_title) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (!(parent_folder_file = new File(parent_folder_filename)).exists()) {
                System.out.println("ERROR: Cannot find parent folder: " + parent_folder_file.getAbsolutePath());
                System.exit(1);
            }
            if (output_folder_filename == null) {
                String output_base_folder = pl.getOutputBaseFolder();
                if (output_base_folder.equalsIgnoreCase("default")) {
                    output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
                } else {
                    output_folder_filename = output_base_folder = output_base_folder.replaceAll(" ", "_");
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                    output_folder_filename = String.valueOf(output_folder_filename) + title + File.separatorChar;
                }
            }
            if (output_folder_filename.equals(parent_folder_filename)) {
                output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
            }
            if (!(output_folder_file = new File(output_folder_filename)).exists()) {
                FileUtils.recursiveMakeDirectory(output_folder_file);
            }
            if (!(progress_file = new File(String.valueOf(output_folder_filename) + "progress.txt")).exists()) {
                progress_file.createNewFile();
            }
            if ((bind_file = new File(String.valueOf(parent_folder_filename) + "bind.txt")).exists()) {
                use_bind = true;
                binds = ConvertManga.processBindFile(bind_file);
            }
            if (num_chars_keep_suffix < 0) {
                auto_sense_suffix = true;
            }
        }
        StopWatch sw = new StopWatch();
        sw.start();
        ExtFilter zip_ext_filter = new ExtFilter("zip");
        ExtFilter rar_ext_filter = new ExtFilter("rar");
        ExtFilter archive_ext_filter = new ExtFilter("archive");
        ExtFilter pdf_ext_filter = new ExtFilter("pdf");
        if (pl == null) {
            if (properties_file.exists()) {
                pl = new PropertiesLoader(properties_file);
            } else {
                System.out.println("ERROR: Couldn't load .properties file. Please make sure that " + properties_file.getAbsolutePath() + " exists.");
                System.exit(1);
            }
        }
        boolean use_archive = pl.getArchive();
        String archive_extension = pl.getArchiveFormat();
        if (!archive_ext_filter.isValid(archive_extension)) {
            System.out.println("ERROR: " + archive_extension + " is not a valid archive extension. Defaulting to .zip");
            archive_extension = ".zip";
        }
        boolean use_zip = false;
        String zip_extension = ".zip";
        if (zip_ext_filter.isValid(archive_extension)) {
            if (use_archive) {
                use_zip = true;
            }
            zip_extension = archive_extension;
        }
        boolean use_rar = false;
        String rar_extension = ".rar";
        if (rar_ext_filter.isValid(archive_extension)) {
            if (use_archive) {
                use_rar = true;
            }
            rar_extension = archive_extension;
        }
        boolean use_pdf = pl.getPdf();
        boolean pdf_r_to_l = pl.getPdfRToL();
        boolean use_epub = pl.getEpub();
        boolean epub_r_to_l = pl.getEpubRToL();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        boolean use_comic_zeal_naming = pl.getComicZealNaming();
        boolean use_auto_split_landscape_scans = pl.getAutoSplitLandscapeScans();
        boolean auto_split_r_first = pl.getAutoSplitRFirst();
        boolean allow_auto_split_color_scans = pl.getAllowAutoSplitColorScans();
        double auto_split_gray_strictness = pl.getAutoSplitGrayStrictness();
        double auto_split_color_strictness = pl.getAutoSplitColorStrictness();
        boolean auto_sense_landscape_folders = pl.getAutoSenseLandscapeFolders();
        String prop_manga_prefix = pl.getMangaPrefix();
        int page_filename_length = pl.getPageFilenameLength();
        pl.printProperties();
        if (use_bind) {
            System.out.println("Found bind.txt file, will perform binding after processing manga.");
        }
        if (use_auto_split_landscape_scans) {
            if (auto_split_gray_strictness < 0.0 || auto_split_gray_strictness > 1.0) {
                System.out.println("ERROR: @auto_split_gray_strictness must be a value between 0 and 1.0 inclusive. Defaulting to 0.8");
                auto_split_gray_strictness = 0.8;
            }
            if (auto_split_gray_strictness < 0.0 || auto_split_gray_strictness > 1.0) {
                System.out.println("ERROR: @auto_split_color_strictness must be a value between 0 and 1.0 inclusive. Defaulting to 0.9");
                auto_split_color_strictness = 0.9;
            }
        }
        if (!user_set_manga_prefix) {
            if (prop_manga_prefix.equalsIgnoreCase("auto")) {
                if (progress_file.exists()) {
                    boolean found = false;
                    File found_file = null;
                    ArrayList<File> output_folder_folderList = FileUtils.getFolderList(output_folder_file);
                    ArrayList<File> output_folder_fileList = FileUtils.getFileList(output_folder_file);
                    int i = 0;
                    while (!found && i < output_folder_folderList.size()) {
                        File cur_folder2 = output_folder_folderList.get(i);
                        String cur_folder_filename = cur_folder2.getName();
                        if (cur_folder_filename.contains(title)) {
                            found_file = cur_folder2;
                            found = true;
                        }
                        ++i;
                    }
                    i = 0;
                    while (!found && i < output_folder_fileList.size()) {
                        File cur_file = output_folder_fileList.get(i);
                        String cur_file_filename = cur_file.getName();
                        if (cur_file_filename.contains(title)) {
                            found_file = cur_file;
                            found = true;
                        }
                        ++i;
                    }
                    if (found) {
                        String found_file_filename = found_file.getName();
                        found_file_filename = found_file_filename.replace(String.valueOf(title) + "~" + title, "");
                        found_file_filename = found_file_filename.replace(title, "");
                        found_file_filename = found_file_filename.replace("_-_", "");
                        String suffix = ConvertManga.getFileNumberSuffix(found_file, true);
                        found_file_filename = found_file_filename.replace(suffix, "");
                        if (!found_file.isDirectory()) {
                            found_file_filename = found_file_filename.replace(ExtFilter.getExtension(found_file), "");
                        }
                        manga_prefix = found_file_filename;
                    } else {
                        manga_prefix = "";
                    }
                } else {
                    manga_prefix = "";
                }
            } else if (prop_manga_prefix.equalsIgnoreCase("default")) {
                manga_prefix = prop_manga_prefix;
                manga_prefix = manga_prefix.replaceAll(" ", "_");
                prefix = String.valueOf(title) + " - " + manga_prefix;
                prefix = prefix.replaceAll(" ", "_");
            }
        }
        prefix = String.valueOf(title) + " - " + manga_prefix;
        prefix = prefix.replaceAll(" ", "_");
        ImageMagick im = new ImageMagick();
        System.out.println("Testing rar handler...");
        SystemRar sysrar = new SystemRar();
        System.out.println("  Can unrar: " + sysrar.canUnrar());
        System.out.println("  Can rar: " + sysrar.canRar());
        if (use_rar && !sysrar.canRar()) {
            System.out.println("  WARNING: You have enabled rar archives but Canti cannot find a compatible program for creating rar archives; therefore, rar archive creation will fail. Please see readme.txt for instructions on setting up a compatible rar handler.");
        }
        System.out.println("");
        ArrayList<File> zipList = FileUtils.getZipFileList(parent_folder_file);
        ArrayList<File> zipExtractedFolderList = new ArrayList<File>();
        Collections.sort(zipList);
        ArrayList<File> rarList = FileUtils.getRarFileList(parent_folder_file);
        ArrayList<File> rarExtractedFolderList = new ArrayList<File>();
        Collections.sort(rarList);
        ArrayList<File> pdfList = FileUtils.getPdfFileList(parent_folder_file);
        ArrayList<File> pdfExtractedFolderList = new ArrayList<File>();
        Collections.sort(pdfList);
        boolean printed_single_folder_message = false;
        boolean parent_folder_is_zip = zip_ext_filter.isValid(parent_folder_file);
        boolean parent_folder_is_rar = rar_ext_filter.isValid(parent_folder_file);
        boolean parent_folder_is_pdf = pdf_ext_filter.isValid(parent_folder_file);
        if (parent_folder_is_zip) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a zip/cbz, so running in single folder mode.\n");
            zipList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        } else if (parent_folder_is_rar) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a rar/cbr, so running in single folder mode.\n");
            rarList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        } else if (parent_folder_is_pdf) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a pdf, so running in single folder mode.\n");
            pdfList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        }
        boolean printed_message = false;
        if (zipList.size() > 0) {
            if (!printed_message) {
                System.out.println("Extracting archives in -parent_folder...");
                printed_message = true;
            }
            System.out.println("  Found " + zipList.size() + " zip archives, extracting to temporary folders...");
        }
        int i = 0;
        while (i < zipList.size()) {
            File cur_zip_file = zipList.get(i);
            String cur_zip_filename_noext = ExtFilter.getNameWithoutExtension(cur_zip_file);
            cur_tmp_folder = null;
            if (!single_folder_mode) {
                cur_tmp_folder = new File(String.valueOf(parent_folder_file.getAbsolutePath()) + File.separatorChar + cur_zip_filename_noext);
            } else {
                parent_folder_file = cur_tmp_folder = new File(String.valueOf(parent_folder_file.getParent()) + File.separatorChar + cur_zip_filename_noext);
            }
            FileUtils.unzipFile(cur_zip_file, cur_tmp_folder);
            zipExtractedFolderList.add(cur_tmp_folder);
            ++i;
        }
        if (rarList.size() > 0) {
            if (!printed_message) {
                System.out.println("Extracting archives in -parent_folder...");
                printed_message = true;
            }
            System.out.println("  Found " + rarList.size() + " rar archives, extracting to temporary folders...");
        }
        if (!sysrar.canUnrar()) {
            System.out.println("    ERROR: Cannot unrar archives since Canti couldn't find a compatible unrar program on your system. Please check readme.txt for more details on how to get rar support for Canti.");
        } else {
            i = 0;
            while (i < rarList.size()) {
                File cur_rar_file = rarList.get(i);
                String cur_rar_filename_noext = ExtFilter.getNameWithoutExtension(cur_rar_file);
                cur_tmp_folder = null;
                if (!single_folder_mode) {
                    cur_tmp_folder = new File(String.valueOf(parent_folder_file.getAbsolutePath()) + File.separatorChar + cur_rar_filename_noext);
                } else {
                    parent_folder_file = cur_tmp_folder = new File(String.valueOf(parent_folder_file.getParent()) + File.separatorChar + cur_rar_filename_noext);
                }
                sysrar.unrarFile(cur_rar_file, cur_tmp_folder);
                rarExtractedFolderList.add(cur_tmp_folder);
                ++i;
            }
        }
        if (pdfList.size() > 0) {
            if (!printed_message) {
                System.out.println("Extracting archives in -parent_folder...");
                printed_message = true;
            }
            System.out.println("  Found " + pdfList.size() + " pdfs, converting to temporary image folders...");
        }
        i = 0;
        while (i < pdfList.size()) {
            File cur_pdf_file = pdfList.get(i);
            String cur_pdf_filename_noext = ExtFilter.getNameWithoutExtension(cur_pdf_file);
            cur_tmp_folder = null;
            if (!single_folder_mode) {
                cur_tmp_folder = new File(String.valueOf(parent_folder_file.getAbsolutePath()) + File.separatorChar + cur_pdf_filename_noext);
            } else {
                parent_folder_file = cur_tmp_folder = new File(String.valueOf(parent_folder_file.getParent()) + File.separatorChar + cur_pdf_filename_noext);
            }
            im.convertPdfToImageFolder(cur_pdf_file, cur_tmp_folder);
            pdfExtractedFolderList.add(cur_tmp_folder);
            ++i;
        }
        ArrayList<File> folderList = FileUtils.getFolderList(parent_folder_file);
        Collections.sort(folderList);
        if (folderList.isEmpty() && parent_folder_file.isDirectory()) {
            if (!printed_single_folder_message) {
                System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a directory that did not contain any subfolders, so running in single folder mode.\n");
            }
            single_folder_mode = true;
            folderList.add(parent_folder_file);
        }
        boolean found_empty_folder = false;
        boolean found_subfolder = false;
        int i2 = 0;
        while (!folderList.isEmpty() && i2 < folderList.size()) {
            cur_folder = folderList.get(i2);
            ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
            if (image_files.isEmpty()) {
                ArrayList<File> cur_folder_folderList = FileUtils.getFolderList(cur_folder);
                if (cur_folder_folderList.size() == 1) {
                    File cur_folder_subfolder = cur_folder_folderList.get(0);
                    image_files = FileUtils.getImageFileList(cur_folder_subfolder);
                    if (!image_files.isEmpty()) {
                        found_subfolder = true;
                        System.out.println("Found images one folder deep in " + cur_folder.getAbsolutePath() + ", moving the images up one directory and deleting subfolder.");
                        FileUtils.copyDirectory(cur_folder_subfolder, cur_folder);
                        FileUtils.deleteDirectory(cur_folder_subfolder);
                    } else {
                        found_empty_folder = true;
                        System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                        folderList.remove(i2);
                        --i2;
                    }
                } else {
                    found_empty_folder = true;
                    System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                    folderList.remove(i2);
                    --i2;
                }
            }
            ++i2;
        }
        if (found_empty_folder || found_subfolder) {
            System.out.println("");
        }
        i2 = 0;
        while (i2 < folderList.size()) {
            cur_folder = folderList.get(i2);
            String cur_folder_name = cur_folder.getName();
            if (auto_sense_suffix) {
                String suffix = ConvertManga.getFileNumberSuffix(cur_folder, true);
                suffixes.add(suffix);
            } else {
                suffixes.add(cur_folder_name.substring(cur_folder_name.length() - num_chars_keep_suffix));
            }
            ++i2;
        }
        if (use_bind) {
            int total_num_binds = 0;
            int i3 = 0;
            while (i3 < binds.size()) {
                total_num_binds += ((Integer)binds.get(i3)).intValue();
                ++i3;
            }
            if (total_num_binds > folderList.size()) {
                System.out.println("ERROR: Total number of binds (" + total_num_binds + ") is greater than the number of manga folders (" + folderList.size() + ") in " + parent_folder_filename + ". The number of binds must be equal to or less than the number of manga folders. Please correct the bind.txt file before running again.");
                System.exit(1);
            }
        }
        if (use_bind && manga_prefix.equals(bind_prefix)) {
            bind_prefix = !manga_prefix.equals("Bind.") ? "Bind." : "Vol.";
            System.out.println("WARNING: manga_prefix is the same as bind_prefix. Changing bind_prefix to \"" + bind_prefix + "\".");
        }
        if (!use_bind && !single_folder_mode && (use_auto_bind = pl.getAutoBind())) {
            use_bind = true;
            int auto_bind_size = pl.getAutoBindSize();
            System.out.println("Will perform auto-binding after processing manga.");
            int num_full = folderList.size() / auto_bind_size;
            int num_left_over = folderList.size() % auto_bind_size;
            int i4 = 0;
            while (i4 < num_full) {
                binds.add(auto_bind_size);
                ++i4;
            }
            if (num_left_over != 0) {
                binds.add(num_left_over);
            }
        }
        ArrayList<File> outputZipList = FileUtils.getZipFileList(output_folder_file);
        ArrayList<File> outputRarList = FileUtils.getRarFileList(output_folder_file);
        ArrayList<File> outputFolderList = FileUtils.getFolderList(output_folder_file);
        if ((outputZipList.size() > 1 || outputRarList.size() > 1) && outputFolderList.isEmpty()) {
            File cur_output_folder_file;
            String comic_zeal_prefix = String.valueOf(title) + "~" + title;
            boolean printed_restore_message = false;
            int i5 = 0;
            while (i5 < outputZipList.size()) {
                File cur_output_zip_file = outputZipList.get(i5);
                String cur_output_zip_filename_noext = ExtFilter.getNameWithoutExtension(cur_output_zip_file);
                if (cur_output_zip_filename_noext.contains(title)) {
                    if (!printed_restore_message) {
                        System.out.println("Restoring output image folders from zip archives...");
                        printed_restore_message = true;
                    }
                    if (cur_output_zip_filename_noext.indexOf(comic_zeal_prefix) == 0) {
                        cur_output_zip_filename_noext = cur_output_zip_filename_noext.substring(new String(String.valueOf(title) + "~").length());
                    }
                    if (!(cur_output_folder_file = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_output_zip_filename_noext)).exists()) {
                        FileUtils.unzipFile(cur_output_zip_file, cur_output_folder_file);
                    }
                }
                ++i5;
            }
            printed_restore_message = false;
            i5 = 0;
            while (i5 < outputRarList.size()) {
                File cur_output_rar_file = outputRarList.get(i5);
                String cur_output_rar_filename_noext = ExtFilter.getNameWithoutExtension(cur_output_rar_file);
                if (cur_output_rar_filename_noext.contains(title)) {
                    if (!printed_restore_message) {
                        System.out.println("Restoring output image folders from rar archives...");
                        printed_restore_message = true;
                    }
                    if (cur_output_rar_filename_noext.indexOf(comic_zeal_prefix) == 0) {
                        cur_output_rar_filename_noext = cur_output_rar_filename_noext.substring(new String(String.valueOf(title) + "~").length());
                    }
                    if (!(cur_output_folder_file = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_output_rar_filename_noext)).exists()) {
                        sysrar.unrarFile(cur_output_rar_file, cur_output_folder_file);
                    }
                }
                ++i5;
            }
        }
        ConvertManga.verifyProgressFile(progress_file);
        ArrayList<File> newFolderList = new ArrayList<File>();
        System.out.println("Copying files to new folders...");
        int i6 = 0;
        while (i6 < folderList.size()) {
            File source = folderList.get(i6);
            String suffix = (String)suffixes.get(i6);
            if (!source.exists()) {
                System.out.println("File or directory does not exist.");
                System.exit(0);
            }
            String dest_filename = null;
            dest_filename = !(suffix != null && !suffix.equals("") || manga_prefix != null && !manga_prefix.equals("")) ? String.valueOf(output_folder_filename) + File.separatorChar + title : String.valueOf(output_folder_filename) + File.separatorChar + prefix + suffix;
            File destination = new File(dest_filename);
            if (!destination.exists()) {
                destination.mkdir();
                ArrayList<File> source_image_list = FileUtils.getImageFileList(source);
                int j = 0;
                while (j < source_image_list.size()) {
                    File cur_image = source_image_list.get(j);
                    FileUtils.copyFile(cur_image, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + cur_image.getName()));
                    ++j;
                }
            }
            newFolderList.add(destination);
            ++i6;
        }
        if (!pl.getUnarchiveInputImageArchives()) {
            i6 = 0;
            while (i6 < zipExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)zipExtractedFolderList.get(i6));
                ++i6;
            }
            i6 = 0;
            while (i6 < rarExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)rarExtractedFolderList.get(i6));
                ++i6;
            }
            i6 = 0;
            while (i6 < pdfExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)pdfExtractedFolderList.get(i6));
                ++i6;
            }
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        System.out.println("Converting all manga scans using ImageMagick...");
        int num_folders_processed = 0;
        int i7 = 0;
        while (i7 < newFolderList.size()) {
            boolean already_zipped = false;
            boolean already_rarred = false;
            boolean already_pdfed = false;
            boolean already_epubbed = false;
            File cur_folder3 = (File)newFolderList.get(i7);
            if (num_folders_processed != 0) {
                String approx_time_remaining = StopWatch.formatTime((long)(newFolderList.size() - i7) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                System.out.println("  Processing folder: " + cur_folder3.getName() + "... (approx " + approx_time_remaining + " remaining)");
            } else {
                System.out.println("  Processing folder: " + cur_folder3.getName() + "...");
            }
            File bookmark_file = new File(String.valueOf(cur_folder3.getAbsolutePath()) + File.separatorChar + cur_folder3.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(cur_folder3.getAbsolutePath()) + File.separatorChar + cur_folder3.getName() + ".manga_save");
            String zip_file_filename = null;
            String rar_file_filename = null;
            if (use_comic_zeal_naming) {
                zip_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder3.getName() + zip_extension;
                rar_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder3.getName() + rar_extension;
            } else {
                zip_file_filename = String.valueOf(output_folder_filename) + cur_folder3.getName() + zip_extension;
                rar_file_filename = String.valueOf(output_folder_filename) + cur_folder3.getName() + rar_extension;
            }
            File zip_file = new File(zip_file_filename);
            File rar_file = new File(rar_file_filename);
            File pdf_file = new File(String.valueOf(output_folder_filename) + cur_folder3.getName() + ".pdf");
            File epub_file = new File(String.valueOf(output_folder_filename) + cur_folder3.getName() + ".epub");
            boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder3);
            if (zip_file.exists()) {
                already_zipped = true;
            }
            if (rar_file.exists()) {
                already_rarred = true;
            }
            if (pdf_file.exists()) {
                already_pdfed = true;
            }
            if (epub_file.exists()) {
                already_epubbed = true;
            }
            if (!processed) {
                ConvertManga.renamePages(cur_folder3, page_filename_length);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder3);
                Collections.sort(image_files);
                im.preprocessImages(image_files);
                boolean performed_split = false;
                if (use_auto_split_landscape_scans) {
                    boolean perform_splits_on_folder = true;
                    ArrayList<ImageData> ids = ImageUtils.getImageDataOfImageFiles(image_files);
                    if (auto_sense_landscape_folders) {
                        int num_landscape_scans = 0;
                        int num_invalid_ids = 0;
                        int j = 0;
                        while (j < ids.size()) {
                            ImageData cur_id = ids.get(j);
                            if (cur_id == null) {
                                ++num_invalid_ids;
                            } else if (cur_id.width > cur_id.height) {
                                ++num_landscape_scans;
                            }
                            ++j;
                        }
                        double num_analyzed_ids = (double)ids.size() - (double)num_invalid_ids;
                        if (num_analyzed_ids > 0.0 && (double)num_landscape_scans / num_analyzed_ids < 0.5) {
                            perform_splits_on_folder = false;
                        }
                    }
                    if (perform_splits_on_folder) {
                        int j = 0;
                        while (j < image_files.size()) {
                            int x_split_pos;
                            File cur_image = image_files.get(j);
                            ImageData cur_image_id = ids.get(j);
                            if (cur_image_id != null && (x_split_pos = ImageUtils.isTwoPages(cur_image, -1, true, allow_auto_split_color_scans, auto_split_gray_strictness, auto_split_color_strictness)) > 0) {
                                im.splitImage(cur_image, (int)cur_image_id.width, (int)cur_image_id.height, x_split_pos, auto_split_r_first);
                                performed_split = true;
                            }
                            ++j;
                        }
                    }
                }
                if (performed_split) {
                    ConvertManga.renameSplitPages(cur_folder3, page_filename_length);
                    image_files = FileUtils.getImageFileList(cur_folder3);
                    Collections.sort(image_files);
                }
                int j = 0;
                while (j < image_files.size()) {
                    File cur_image = image_files.get(j);
                    im.processImage(cur_image);
                    ++j;
                }
                if (image_files.size() > 0 && use_kindle_bookmark) {
                    ConvertManga.writeBookmark(cur_folder3, bookmark_file, bookmark_save_file, image_files.get(0));
                }
                ConvertManga.addProcessedFolder(progress_file, cur_folder3);
                ++num_folders_processed;
            }
            if (use_zip && !use_bind && !already_zipped) {
                FileUtils.zipFolder(cur_folder3, zip_file);
            }
            if (use_rar && !use_bind && !already_rarred) {
                sysrar.rarFolder(cur_folder3, rar_file);
            }
            if (use_pdf && !use_bind && !already_pdfed) {
                if (pdf_r_to_l) {
                    File tmp_r_to_l_folder = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_folder3.getName() + "_TMP_R_TO_L");
                    ConvertManga.createFolderOfRToLPages(cur_folder3, tmp_r_to_l_folder, page_filename_length);
                    im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                    FileUtils.deleteDirectory(tmp_r_to_l_folder);
                } else {
                    im.pdfImageFolder(cur_folder3, pdf_file);
                }
            }
            if (use_epub && !use_bind && !already_epubbed) {
                EpubMaker em = new EpubMaker(cur_folder3.getName(), epub_file, cur_folder3, page_filename_length, epub_r_to_l);
                em.makeEpub();
            }
            ++i7;
        }
        ArrayList<File> bind_folders = new ArrayList<File>();
        if (use_bind) {
            System.out.println("\nBeginning binding...");
            ArrayList<File> unbound_folders = FileUtils.getFolderList(output_folder_file);
            Collections.sort(unbound_folders);
            int i8 = 0;
            while (i8 < binds.size()) {
                int cur_bind = (Integer)binds.get(i8);
                String bind_title = String.valueOf(title) + "_-_" + bind_prefix + Integer.toString(i8 + 1);
                bind_title = bind_title.replaceAll(" ", "_");
                String bind_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar + bind_title;
                File bind_folder = new File(bind_folder_filename);
                if (bind_folder.exists()) {
                    FileUtils.deleteDirectory(bind_folder);
                }
                bind_folder.mkdir();
                ArrayList<File> folders_to_bind = new ArrayList<File>();
                int j = 0;
                while (j < cur_bind) {
                    folders_to_bind.add(unbound_folders.remove(0));
                    ++j;
                }
                System.out.println("  Binding folders:");
                j = 0;
                while (j < folders_to_bind.size()) {
                    System.out.println("    " + ((File)folders_to_bind.get(j)).getName());
                    ++j;
                }
                System.out.println("  to form " + bind_title + "...");
                ConvertManga.bindFolders(folders_to_bind, bind_folder, output_folder_filename, im, title, use_zip, zip_extension, use_rar, rar_extension, sysrar, use_pdf, pdf_r_to_l, use_kindle_bookmark, use_comic_zeal_naming, use_epub, epub_r_to_l, page_filename_length);
                bind_folders.add(bind_folder);
                ++i8;
            }
        }
        if (pl.getUnarchiveInputImageArchives()) {
            folderList = FileUtils.getFolderList(parent_folder_file);
            Collections.sort(folderList);
            ArrayList<String> folderList_filenames = new ArrayList<String>();
            int i9 = 0;
            while (!folderList.isEmpty() && i9 < folderList.size()) {
                File cur_folder4 = folderList.get(i9);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder4);
                if (image_files.isEmpty()) {
                    folderList.remove(i9);
                    --i9;
                } else {
                    folderList_filenames.add(cur_folder4.getName());
                }
                ++i9;
            }
            ArrayList<File> archiveList = FileUtils.getArchiveFileList(parent_folder_file);
            if (!archiveList.isEmpty() && !folderList.isEmpty()) {
                System.out.println("\nDeleting input image archives...");
            }
            int i10 = 0;
            while (i10 < archiveList.size()) {
                File cur_archive = archiveList.get(i10);
                String cur_archive_filename_noext = ExtFilter.getNameWithoutExtension(cur_archive);
                if (folderList_filenames.contains(cur_archive_filename_noext)) {
                    cur_archive.delete();
                }
                ++i10;
            }
        } else if (pl.getArchiveInputImageFolders()) {
            File cur_folder5;
            folderList = FileUtils.getFolderList(parent_folder_file);
            Collections.sort(folderList);
            int i11 = 0;
            while (!folderList.isEmpty() && i11 < folderList.size()) {
                cur_folder5 = folderList.get(i11);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder5);
                if (image_files.isEmpty()) {
                    folderList.remove(i11);
                    --i11;
                }
                ++i11;
            }
            if (!folderList.isEmpty()) {
                System.out.println("\nArchiving input image folders, then deleting the folders...");
            }
            i11 = 0;
            while (i11 < folderList.size()) {
                cur_folder5 = folderList.get(i11);
                File new_zip_file = new File(String.valueOf(cur_folder5.getParent()) + File.separatorChar + cur_folder5.getName() + ".zip");
                File new_cbz_file = new File(String.valueOf(cur_folder5.getParent()) + File.separatorChar + cur_folder5.getName() + ".cbz");
                File new_rar_file = new File(String.valueOf(cur_folder5.getParent()) + File.separatorChar + cur_folder5.getName() + ".rar");
                File new_cbr_file = new File(String.valueOf(cur_folder5.getParent()) + File.separatorChar + cur_folder5.getName() + ".cbr");
                File new_archive_file = new File(String.valueOf(cur_folder5.getParent()) + File.separatorChar + cur_folder5.getName() + archive_extension);
                if (new_zip_file.exists() || new_cbz_file.exists() || new_rar_file.exists() || new_cbr_file.exists()) {
                    FileUtils.deleteDirectory(cur_folder5);
                } else if (use_zip) {
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new_archive_file));
                    FileUtils.zipFolderRecursive(cur_folder5.getAbsolutePath(), cur_folder5.getAbsolutePath(), zos);
                    zos.close();
                    FileUtils.deleteDirectory(cur_folder5);
                } else if (use_rar && sysrar.rarFolder(cur_folder5, new_archive_file)) {
                    FileUtils.deleteDirectory(cur_folder5);
                }
                ++i11;
            }
        }
        if (pl.getDelOutputImageFolders()) {
            if (!use_bind) {
                System.out.println("\nDeleting output image folders...");
                folderList = FileUtils.getFolderList(output_folder_file);
                Collections.sort(folderList);
                StopWatch sw_del = new StopWatch();
                int i12 = 0;
                while (i12 < folderList.size()) {
                    File cur_folder6 = folderList.get(i12);
                    String cur_zip_file_filename = null;
                    String cur_cbz_file_filename = null;
                    String cur_rar_file_filename = null;
                    String cur_cbr_file_filename = null;
                    if (use_comic_zeal_naming) {
                        cur_zip_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder6.getName() + ".zip";
                        cur_cbz_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder6.getName() + ".cbz";
                        cur_rar_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder6.getName() + ".rar";
                        cur_cbr_file_filename = String.valueOf(output_folder_filename) + title + "~" + cur_folder6.getName() + ".cbr";
                    } else {
                        cur_zip_file_filename = String.valueOf(output_folder_filename) + cur_folder6.getName() + ".zip";
                        cur_cbz_file_filename = String.valueOf(output_folder_filename) + cur_folder6.getName() + ".cbz";
                        cur_rar_file_filename = String.valueOf(output_folder_filename) + cur_folder6.getName() + ".rar";
                        cur_cbr_file_filename = String.valueOf(output_folder_filename) + cur_folder6.getName() + ".cbr";
                    }
                    File cur_zip_file = new File(cur_zip_file_filename);
                    File cur_cbz_file = new File(cur_cbz_file_filename);
                    File cur_rar_file = new File(cur_rar_file_filename);
                    File cur_cbr_file = new File(cur_cbr_file_filename);
                    if (cur_zip_file.exists() || cur_cbz_file.exists() || (cur_rar_file.exists() || cur_cbr_file.exists()) && sysrar.canUnrar()) {
                        boolean deleted = FileUtils.deleteDirectory(cur_folder6);
                        if (!deleted) {
                            sw_del.reset();
                            sw_del.start();
                            while (!deleted && sw_del.getElapsedTimeSecs() < 10L) {
                                deleted = FileUtils.deleteDirectory(cur_folder6);
                            }
                            sw_del.stop();
                            if (!deleted) {
                                try {
                                    Thread.sleep(5000L);
                                    int attempt = 0;
                                    while (!deleted && attempt < 5) {
                                        deleted = FileUtils.deleteDirectory(cur_folder6);
                                        Thread.sleep(1000L);
                                        ++attempt;
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (cur_folder6.exists()) {
                            System.out.println("  ERROR: Failed to delete output image folder: " + cur_folder6.getAbsolutePath() + "  You will have to delete this folder manually.");
                        }
                    }
                    ++i12;
                }
            } else {
                System.out.println("\nDeleting output bind image folders...");
                StopWatch sw_del = new StopWatch();
                int i13 = 0;
                while (i13 < bind_folders.size()) {
                    File cur_bind_folder = (File)bind_folders.get(i13);
                    boolean deleted = FileUtils.deleteDirectory(cur_bind_folder);
                    if (!deleted) {
                        sw_del.reset();
                        sw_del.start();
                        while (!deleted && sw_del.getElapsedTimeSecs() < 10L) {
                            deleted = FileUtils.deleteDirectory(cur_bind_folder);
                        }
                        sw_del.stop();
                        if (!deleted) {
                            try {
                                Thread.sleep(5000L);
                                int attempt = 0;
                                while (!deleted && attempt < 5) {
                                    deleted = FileUtils.deleteDirectory(cur_bind_folder);
                                    Thread.sleep(1000L);
                                    ++attempt;
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (cur_bind_folder.exists()) {
                        System.out.println("  ERROR: Failed to delete output bind image folder: " + cur_bind_folder.getAbsolutePath() + "  You will have to delete this folder manually.");
                    }
                    ++i13;
                }
                System.out.println("\nAlthough you requested to delete output image folders, this cannot be allowed with your current settings. Check to make sure that @archive is enabled and binding (either through bind file or auto-binding) is disabled.");
            }
        }
        sw.stop();
        System.out.println("\nFinished.");
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

