/*
 * Decompiled with CFR 0.152.
 */
import common.utils.ExtFilter;
import common.utils.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class FixSuffixes {
    public static String removeLeadingZeros(String str) {
        String mod_str = str;
        boolean done_leading_zeros = false;
        while (!done_leading_zeros && mod_str.length() >= 2) {
            char cur_char = mod_str.charAt(0);
            char next_char = mod_str.charAt(1);
            if (cur_char == '0') {
                if (Character.isDigit(next_char)) {
                    mod_str = mod_str.substring(1);
                    continue;
                }
                done_leading_zeros = true;
                continue;
            }
            done_leading_zeros = true;
        }
        return mod_str;
    }

    public static String getFileNumberSuffix(File fh, boolean is_directory) {
        char cur_char;
        boolean done = false;
        boolean found_decimal = false;
        boolean found_hyphen = false;
        String filename = null;
        String suffix = "";
        filename = is_directory ? fh.getName() : ExtFilter.getNameWithoutExtension(fh);
        int j = 0;
        while (!done && j < filename.length()) {
            cur_char = filename.charAt(filename.length() - 1 - j);
            if (cur_char == '.') {
                if (!found_decimal) {
                    int next_char_index = filename.length() - 2 - j;
                    if (next_char_index >= 0) {
                        char next_char = filename.charAt(next_char_index);
                        if (Character.isDigit(next_char) || next_char == '_' || next_char == ' ' || next_char == '-' && !found_hyphen) {
                            suffix = String.valueOf(cur_char) + suffix;
                            found_decimal = true;
                        } else {
                            done = true;
                        }
                    } else {
                        suffix = String.valueOf(cur_char) + suffix;
                        found_decimal = true;
                    }
                } else {
                    done = true;
                }
            } else if (cur_char == '-') {
                if (!found_hyphen) {
                    suffix = String.valueOf(cur_char) + suffix;
                    found_decimal = false;
                    found_hyphen = true;
                } else {
                    done = true;
                }
            } else if (Character.isDigit(cur_char) || cur_char == ' ' || cur_char == '_') {
                suffix = String.valueOf(cur_char) + suffix;
            } else {
                done = true;
            }
            ++j;
        }
        suffix = suffix.replaceAll(" ", "");
        suffix = suffix.replaceAll("_", "");
        boolean done_leading = false;
        while (!done_leading && !suffix.isEmpty()) {
            cur_char = suffix.charAt(0);
            if (Character.isDigit(cur_char)) {
                done_leading = true;
                continue;
            }
            if (cur_char == '.') {
                int hyphen_index = suffix.indexOf(45);
                int decimal_range_index = hyphen_index < 0 ? suffix.length() : hyphen_index;
                boolean found_another_decimal = false;
                int i = 1;
                while (!found_another_decimal && i < decimal_range_index) {
                    if (suffix.charAt(i) == '.') {
                        suffix = suffix.substring(1);
                        found_another_decimal = true;
                    }
                    ++i;
                }
                if (found_another_decimal) continue;
                done_leading = true;
                continue;
            }
            suffix = suffix.length() == 1 ? "" : suffix.substring(1);
        }
        int hyphen_index = suffix.indexOf(45);
        if (hyphen_index == -1) {
            suffix = FixSuffixes.removeLeadingZeros(suffix);
        } else {
            String suffix_before_hyphen = suffix.substring(0, hyphen_index);
            String suffix_after_hyphen = suffix.substring(hyphen_index + 1);
            suffix_before_hyphen = FixSuffixes.removeLeadingZeros(suffix_before_hyphen);
            suffix_after_hyphen = FixSuffixes.removeLeadingZeros(suffix_after_hyphen);
            suffix = String.valueOf(suffix_before_hyphen) + "-" + suffix_after_hyphen;
        }
        if (suffix.length() >= 1 && suffix.charAt(0) == '.') {
            suffix = String.valueOf('0') + suffix;
        }
        return suffix;
    }

    public static String getFilenameNoSuffix(File fh) {
        String fh_name = fh.getName();
        int separator_index = fh_name.indexOf("_-_");
        int suffix_index = 0;
        boolean done = false;
        int i = separator_index + 3;
        while (!done && i < fh_name.length()) {
            char cur_char = fh_name.charAt(i);
            if (Character.isDigit(cur_char)) {
                suffix_index = i;
                done = true;
            }
            ++i;
        }
        return fh_name.substring(0, suffix_index);
    }

    private static void outputUsage() {
        System.out.println("\nFixSuffixes");
        System.out.println("Author: Andrew Mantel");
        System.out.println("Purpose: Fix suffix of filenames that contain leading 0's.");
        System.out.println("Usage: java -jar FixSuffixes.jar [folder path]");
        System.out.println("Example: java -jar FixSuffixes.jar C:\\\\Manga\\\\SchoolRumble\\\\");
        System.out.println("Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        File new_file;
        String cur_file_extension;
        String cur_file_filename_no_suffix;
        String cur_file_new_suffix;
        File cur_file;
        String folder_path;
        File folder_file;
        if (args.length != 1) {
            FixSuffixes.outputUsage();
        }
        if (!(folder_file = new File(folder_path = args[0])).exists()) {
            System.out.println("ERROR: Couldn't find folder: " + folder_file.getAbsolutePath());
            FixSuffixes.outputUsage();
        }
        ArrayList<File> zipList = FileUtils.getZipFileList(folder_file);
        Collections.sort(zipList);
        ArrayList<File> rarList = FileUtils.getRarFileList(folder_file);
        Collections.sort(rarList);
        ArrayList<File> pdfList = FileUtils.getPdfFileList(folder_file);
        Collections.sort(pdfList);
        ArrayList<File> folderList = FileUtils.getFolderList(folder_file);
        Collections.sort(folderList);
        if (!zipList.isEmpty()) {
            System.out.println("Fixing suffixes of " + zipList.size() + " zip/cbz archives...");
        }
        int i = 0;
        while (i < zipList.size()) {
            cur_file = zipList.get(i);
            cur_file_new_suffix = FixSuffixes.getFileNumberSuffix(cur_file, false);
            cur_file_filename_no_suffix = FixSuffixes.getFilenameNoSuffix(cur_file);
            cur_file_extension = ExtFilter.getExtension(cur_file);
            new_file = new File(String.valueOf(cur_file.getParent()) + File.separatorChar + cur_file_filename_no_suffix + cur_file_new_suffix + cur_file_extension);
            cur_file.renameTo(new_file);
            ++i;
        }
        if (!rarList.isEmpty()) {
            System.out.println("Fixing suffixes of " + rarList.size() + " rar/cbr archives...");
        }
        i = 0;
        while (i < rarList.size()) {
            cur_file = rarList.get(i);
            cur_file_new_suffix = FixSuffixes.getFileNumberSuffix(cur_file, false);
            cur_file_filename_no_suffix = FixSuffixes.getFilenameNoSuffix(cur_file);
            cur_file_extension = ExtFilter.getExtension(cur_file);
            new_file = new File(String.valueOf(cur_file.getParent()) + File.separatorChar + cur_file_filename_no_suffix + cur_file_new_suffix + cur_file_extension);
            cur_file.renameTo(new_file);
            ++i;
        }
        if (!pdfList.isEmpty()) {
            System.out.println("Fixing suffixes of " + pdfList.size() + " pdfs...");
        }
        i = 0;
        while (i < pdfList.size()) {
            cur_file = pdfList.get(i);
            cur_file_new_suffix = FixSuffixes.getFileNumberSuffix(cur_file, false);
            cur_file_filename_no_suffix = FixSuffixes.getFilenameNoSuffix(cur_file);
            cur_file_extension = ExtFilter.getExtension(cur_file);
            new_file = new File(String.valueOf(cur_file.getParent()) + File.separatorChar + cur_file_filename_no_suffix + cur_file_new_suffix + cur_file_extension);
            cur_file.renameTo(new_file);
            ++i;
        }
        if (!folderList.isEmpty()) {
            System.out.println("Fixing suffixes of " + folderList.size() + " folders...");
        }
        i = 0;
        while (i < folderList.size()) {
            cur_file = folderList.get(i);
            cur_file_new_suffix = FixSuffixes.getFileNumberSuffix(cur_file, true);
            cur_file_filename_no_suffix = FixSuffixes.getFilenameNoSuffix(cur_file);
            File new_file2 = new File(String.valueOf(cur_file.getParent()) + File.separatorChar + cur_file_filename_no_suffix + cur_file_new_suffix);
            cur_file.renameTo(new_file2);
            ++i;
        }
        File progress_file = new File(String.valueOf(folder_file.getAbsolutePath()) + File.separatorChar + "progress.txt");
        if (progress_file.exists()) {
            System.out.println("Fixing suffixes of progress.txt...");
            ArrayList<File> lines = new ArrayList<File>();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(progress_file));
                while ((line = br.readLine()) != null) {
                    lines.add(new File(line));
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ArrayList<File> fixed_lines = new ArrayList<File>();
            int i2 = 0;
            while (i2 < lines.size()) {
                File cur_file2 = (File)lines.get(i2);
                String cur_file_new_suffix2 = FixSuffixes.getFileNumberSuffix(cur_file2, true);
                String cur_file_filename_no_suffix2 = FixSuffixes.getFilenameNoSuffix(cur_file2);
                fixed_lines.add(new File(String.valueOf(cur_file2.getParent()) + File.separatorChar + cur_file_filename_no_suffix2 + cur_file_new_suffix2));
                ++i2;
            }
            try {
                progress_file.delete();
                BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file));
                int i3 = 0;
                while (i3 < fixed_lines.size()) {
                    bw.write(String.valueOf(((File)fixed_lines.get(i3)).getAbsolutePath()) + "\n");
                    ++i3;
                }
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\nFinished.");
    }
}

