#ifndef __DB_H__
#define __DB_H__

#include <libermetadb/ermetadb.h>

/* Get interesting fields from application_data for specific file.
 *
 * @param [in]  filename - filename for which we want to read the data
 * @param [out] pageflow - value of uds_page_flow (0|1)
 * @param [out] fullscreen - value of uds_full_screen (0|1)
 */
void
get_db_fields(const gchar *filename, int *pageflow, int *fullscreen);

/* Set interesting fields in application_data for specific file.
 *
 * @param [in] filename - filename for which we want to set the fields
 * @param [in] pageflow - value of uds_page_flow (0|1)
 * @param [in] fullscreen - value of uds_full_screen (0|1)
 */
void
set_db_fields(const gchar *filename, int pageflow, int fullscreen);


#endif
