#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libermetadb/ermetadb.h>

#include "log.h"


void
get_db_fields(const gchar *filename, int *pageflow, int *fullscreen) {
  gchar *directory = g_path_get_dirname(filename);
  gchar *file = g_path_get_basename(filename);
  erMetadb db = ermetadb_local_open(directory, TRUE);

  // Prepare the query.
  metadata_table *names, *values;
  values = NULL;
  names = metadata_table_new();
  metadata_table_add_column(names, "uds_page_flow");
  metadata_table_add_column(names, "uds_full_screen");

  // Query the database.
  ermetadb_local_get_application_data(db, file, names, &values);

  // Grab the returned values.
  int idx = metadata_table_find_column(values, "uds_page_flow");
  GString *pf = metadata_table_get_string(values, idx);
  idx = metadata_table_find_column(values, "uds_full_screen");
  GString *fs = metadata_table_get_string(values, idx);
  LOG("Current settings in db: pageflow: [%s], fullscreen: [%s]",
      pf->str, fs->str);

  // "Return" proper value for pageflow...
  if(strcmp("continuous", pf->str) == 0) {
    *pageflow = 1;
  } else {
    *pageflow = 0;
  };

  // ...and for fullscreen.
  if(strcmp("full_screen_mode", fs->str) == 0) {
    *fullscreen = 1;
  } else {
    *fullscreen = 0;
  };

  // Cleanup.
  g_string_free(fs, TRUE);
  g_string_free(pf, TRUE);
  metadata_table_free(values);
  metadata_table_free(names);
  ermetadb_close(db);
  g_free(file);
  g_free(directory);
};


void
set_db_fields(const gchar *filename, int pageflow, int fullscreen) {
  gchar *directory = g_path_get_dirname(filename);
  gchar *file = g_path_get_basename(filename);
  erMetadb db = ermetadb_local_open(directory, TRUE);
  LOG("I got asked to flip: pageflow: [%d], fullscreen: [%d]",
      pageflow, fullscreen);

  // Prepare structure for new values.
  metadata_table *values;
  values = metadata_table_new();
  if (pageflow >= 0) {
    metadata_table_add_column(values, "uds_page_flow");
    int idx = metadata_table_find_column(values, "uds_page_flow");
    if (pageflow == 1) {
      metadata_table_set_text (values, idx, "continuous");
    } else {
      metadata_table_set_text (values, idx, "");
    };
  };
  if (fullscreen >= 0) { 
    metadata_table_add_column(values, "uds_full_screen");
    int idx = metadata_table_find_column(values, "uds_full_screen");
    if (fullscreen == 1) {
      metadata_table_set_text (values, idx, "full_screen_mode");
    } else {
      metadata_table_set_text (values, idx, "");
    };
  };

  // Write new values to db.
  ermetadb_local_set_application_data(db, file, values);

  // Cleanup.
  metadata_table_free(values);
  ermetadb_close(db);
  free(file);
  free(directory);
};
