#ifndef __DBUS_H__
#define __DBUS_H__

#include <dbus/dbus.h>

/* Sets up DBus communication, create default message objects.
 *
 * @param [out] connection - pointer to newly created connection
 * @param [in]  filter_func - function to install as a handler for all messages
 */
void
setup_dbus(DBusConnection **connection, DBusHandleMessageFunction filter_func);

/* Sends one of predefined DBus messages.
 *
 * @param [in] c - DBus connection to use
 * @param [in] t - name of predefined message to send
 * @param [in] ... - extra arguments for DBus message
 */
void
send_message(DBusConnection *c, const char *t, int first_arg_type, ...);

/* Sends "addItem" method to popupmenu.
 *
 * @param [in] c - DBus connection to use
 * @param [in] name - name of the menu item
 * @param [in] parent - label of parent menu group
 * @param [in] title - string to display for new menu item
 * @param [in] icon - filename of icon to be displayed for new menu item
 */
void
add_item(DBusConnection *c, const char *name, const char *parent, const char *title, const char *icon);

/* Sends "setItemState" method to popupmenu.
 *
 * @param [in] c - DBus connection to use
 * @param [in] name - name of the menu item
 * @param [in] parent - label of parent menu group
 * @param [in] state - string describing new state (normal|selected|disabled)
 */
void
set_item_state(DBusConnection *c, const char *name, const char *parent, const char *state);

/* Sends "sysVolumeMounted" to sysd.
 *
 * @param [in] c - DBus connection to use
 */
void
volume_mounted(DBusConnection *c);

/* Sends "sysPrepareUnmount" to sysd.
 *
 * @param [in] c - DBus connection to use
 */
void
prepare_unmount(DBusConnection *c);

/* Sends "startTask" to sysd.
 *
 * @param [in] c - DBus connection to use
 * @param [in] filename - filename to open
 */
void
reopen_file(DBusConnection *c, const char *filename);


#endif
