#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dbus/dbus.h>
#include <glib.h>

#include "log.h"


// Message templates.
static DBusMessage *addItem, *setItemState;
static DBusMessage *mount, *umount;
static DBusMessage *startTask;


void
setup_dbus(DBusConnection **c, DBusHandleMessageFunction filter_func) {
  DBusError error;

  // Connect to session bus.
  dbus_error_init (&error);
  *c = dbus_bus_get (DBUS_BUS_SESSION, &error);
  DBusConnection *connection = *c;
  if (connection == NULL) {
    LOG("Failed to open connection to session message bus: %s",
	error.message);
    exit(1);
  };

  // Prepare generic messages.
  char *card = "/media/mmcblk0p1";
  addItem = dbus_message_new_method_call(
    "com.irexnet.popupmenu",
    "/com/irexnet/popupmenu",
    "com.irexnet.popupmenu",
    "addItem");
  setItemState = dbus_message_new_method_call(
    "com.irexnet.popupmenu",
    "/com/irexnet/popupmenu",
    "com.irexnet.popupmenu",
    "setItemState");
  mount = dbus_message_new_signal(
    "/com/irexnet/sysd",
    "com.irexnet.sysd",
    "sysVolumeMounted");
  dbus_message_append_args(mount, DBUS_TYPE_STRING, &card, DBUS_TYPE_INVALID);
  umount = dbus_message_new_signal(
    "/com/irexnet/sysd",
    "com.irexnet.sysd",
    "sysPrepareUnmount");
  dbus_message_append_args(umount, DBUS_TYPE_STRING, &card, DBUS_TYPE_INVALID);
  startTask = dbus_message_new_method_call(
    "com.irexnet.sysd",
    "/com/irexnet/sysd",
    "com.irexnet.sysd",
    "startTask");

  // Register interest in specific messages.
  dbus_bus_add_match(connection,
		     "destination=com.irexnet.uds,path=/com/irexnet/uds,interface=com.irexnet.uds,member=openFile", 
		     &error);
  dbus_bus_add_match(connection,
		     "destination=com.irexnet.uds,path=/com/irexnet/uds,interface=com.irexnet.uds,member=menuItemActivated,arg0=trickdPageFlow", 
		     &error);
  dbus_bus_add_match(connection,
		     "destination=com.irexnet.uds,path=/com/irexnet/uds,interface=com.irexnet.uds,member=menuItemActivated,arg0=trickdFullScreen", 
		     &error);

  // Add handler function for all messages.
  if (!dbus_connection_add_filter (connection, *filter_func, NULL, NULL)) {
    LOG("Couldn't add filter!");
    exit(1);
  };
};


void
send_message(DBusConnection *c, const char *t, int first_arg_type, ...) {
  DBusMessage *tmp;

  // Select template to use.
  if (strcmp("addItem", t) == 0) {
    tmp = dbus_message_copy(addItem);
  } else if (strcmp("setItemState", t) == 0) {
    tmp = dbus_message_copy(setItemState);
  } else if (strcmp("startTask", t) == 0) {
    tmp = dbus_message_copy(startTask);
  } else {
    // TODO: Handle this more gracefully.
    LOG("Unknown type of message: %s", t);
    exit(1);  
  };

  // Add user-supplied parameters for method call.
  va_list p;
  va_start(p, first_arg_type);
  dbus_message_append_args_valist(tmp, first_arg_type, p);
  va_end(p);

  // Send the message.
  dbus_connection_send(c, tmp, NULL);
  dbus_connection_flush(c);

  // Cleanup.
  dbus_message_unref(tmp);
};


void
add_item(DBusConnection *c, const char *name, const char *parent, const char *title, const char *icon) {
  send_message(c, "addItem",
	       DBUS_TYPE_STRING, &name, 
	       DBUS_TYPE_STRING, &parent,
	       DBUS_TYPE_STRING, &title,
	       DBUS_TYPE_STRING, &icon,
	       DBUS_TYPE_INVALID);
};


void
set_item_state(DBusConnection *c, const char *name, const char *parent, const char *state) {
  send_message(c, "setItemState",
	       DBUS_TYPE_STRING, &name,
	       DBUS_TYPE_STRING, &parent,
	       DBUS_TYPE_STRING, &state,
	       DBUS_TYPE_INVALID);
};


void
volume_mounted(DBusConnection *c) {
  dbus_connection_send(c, mount, NULL);
  dbus_connection_flush(c);
};


void
prepare_unmount(DBusConnection *c) {
  dbus_connection_send(c, umount, NULL);
  dbus_connection_flush(c);
};


void
reopen_file(DBusConnection *c, const char *filename) {
  gchar *cmdline = g_strconcat("uds \"", filename, "\"", NULL);
  gchar *directory = g_path_get_dirname(filename);
  gchar *label = "Continue Reading";
  gchar *icon = "";

  send_message(c, "startTask",
	       DBUS_TYPE_STRING, &cmdline,
	       DBUS_TYPE_STRING, &directory,
	       DBUS_TYPE_STRING, &label,
	       DBUS_TYPE_STRING, &icon,
	       DBUS_TYPE_INVALID);
  g_free(directory);
  g_free(cmdline);
};
