/*
 * File Name: model_test.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <stdio.h>

#include "text_model.h"

using namespace text;

int main(int argc, char* argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s <file_path>.\n", argv[0]);
        return -1;
    }

    std::string doc_path(argv[1]);
    TextModel doc(doc_path);

    assert(doc.open());
    doc.read_text();

    const std::string *paragraph = 0;
    for (unsigned int i=0; i<doc.get_paragraph_count(); i++)
    {
        paragraph = doc.get_paragraph(i);
        printf("%s", paragraph->c_str());
    }

    getchar();
    return 0;
}

