/**
 * @File   : nsUniversalDetectorImpl.h
 * @Author : Jinlei Li
 * @Date   : 2008-06-03
 *
 * @brief  : A wrapper for internal encoding detector implementations.
 *           This is the ONLY header file that will be included by plaintext
 *           plugin implementations.
 *
 * Copyright (C) 2008, iRex Technologies B.V.
 * All rights reserved.
 */

#include <string>
#include "nsUniversalDetector.h"

class nsUniversalDetectorImpl: public nsUniversalDetector
{
public:
    nsUniversalDetectorImpl() {}
    ~nsUniversalDetectorImpl() {}

public:
    const std::string& get_enc() const
    {
        return enc;
    }

protected:
    virtual void Report(const char* aCharset)
    {
        enc = aCharset;
    }

private:
    std::string enc;
};
