/*
 * File Name: poppler_test.cpp
 */

/*
 * This file is part of uds-plugin-pdf.
 *
 * uds-plugin-pdf is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-pdf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <stdio.h>
#include "goo/GooList.h"
#include "poppler/GlobalParams.h"
#include "poppler/Object.h"
#include "poppler/Link.h"
#include "goo/GooString.h"
#include "poppler/PDFDoc.h"
#include "poppler/SplashOutputDev.h"
#include "splash/SplashTypes.h"

#ifdef WIN32
#include <windows.h>
#else
#include <sys/time.h>
#endif

#define AppName "xpdf"

#ifdef WIN32
#include "poppler/SecurityHandler.h"
void CDECL error(int pos, char *msg, ...) {
}

void * StandardSecurityHandler::getAuthData()
{
    return 0;
}
#endif

int get_cur_time()
{
    int now;
#ifdef WIN32
    now = GetTickCount();
#else
    struct timeval cur_time_struct;
    gettimeofday(&cur_time_struct, 0);
    now = cur_time_struct.tv_sec;
#endif
    return now;
}

int main(int argc, char * argv[])
{

    printf("open file %s\n", argv[1]);
    GooString * name = new GooString(argv[1]);
#ifdef WIN32
    globalParams = new GlobalParams("");
#else
    globalParams = new GlobalParams();
#endif
    SplashColor white;
    white[0] = 255;
    white[1] = 255;
    white[2] = 255;
    SplashColorMode mode = splashModeMono8;
    printf("Use Mono8 mode\n");
    // SplashColorMode mode = splashModeRGB8;
    SplashOutputDev * outputDev = new SplashOutputDev(mode/*Packed*/, 4, gFalse, white);
    
    PDFDoc * pdfdoc = new PDFDoc(name);     
    
    if (!pdfdoc->isOk())
    {
        printf("could not open doc %s\n", argv[1]);
        return -1;
    }
 
    double zoom = 100.0f;
    if (argc >= 3)
    {
        zoom = atof(argv[2]);
    }

    double hDPI = zoom * 0.01 * 150;
    double vDPI = zoom * 0.01 * 150;
    int rotate  = 0;
    printf("start docuemnt pages %d\n", pdfdoc->getNumPages());
    outputDev->startDoc(pdfdoc->getXRef());
    printf("start document done!\n");
    
    for(int i = 1; i <= pdfdoc->getNumPages(); ++i)
    {
        printf("render page %d, zoom:%f, crop width:%f, crop height:%f\n", i
            , zoom            
            , pdfdoc->getPageCropWidth(i)
            , pdfdoc->getPageCropHeight(i));
        int cur_time = get_cur_time();
        RenderRet ret =
			pdfdoc->displayPage(outputDev,  i, hDPI, vDPI, rotate, gFalse, gTrue, gTrue);
		
		
		printf("consume time:%d, result: %s\n", get_cur_time() - cur_time, ret == Render_Done ? "Done" : "Abort");
    }
       
    return 0;    

}

