/*
 * File Name: render_result_impl.h
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef TEXT_PLUGIN_RENDER_RESULT_H_
#define TEXT_PLUGIN_RENDER_RESULT_H_

#include "plugin_inc.h"
#include "signal_slot.h"
#include "text_base_types.h"
#include "interfaces_utils.h"

using namespace utils;

namespace text
{

class PluginViewImpl;
class PluginRenderSettingsImpl;

class PluginRenderResultImpl : public IPluginUnknown
                             , public IPluginRenderResult
                             , public IPluginRenderSettings
                             // , public IPluginZoom
                             // , public IPluginRotation
{
public:
    PluginRenderResultImpl(PluginViewImpl *view,
                           const PluginBitmapAttributes&,
                           const unsigned long id,
                           PluginRenderSettingsImpl * settings);
    ~PluginRenderResultImpl(void);

public:
    void set_render_result_range(const Position& start, const Position& end)
    {
        page_range.start = start;
        page_range.end = end;
    }
    Signal<PluginRenderResultImpl *> release_signal;

private:
    // IPluginUnknown
    static PluginStatus query_interface_impl(
        IPluginUnknown    *thiz,
        const UDSString   *id, 
        void              **ptr );

    static int release_impl(
        IPluginUnknown  *thiz );

    // IPluginRenderResult 
    static PluginStatus get_bitmap_attributes_impl(
        IPluginUnknown         *thiz, 
        PluginBitmapAttributes *attributes);

    static PluginStatus get_anchor_from_coordinates_impl(
        IPluginUnknown *thiz,
        const int      x,
        const int      y,
        UDSString      *anchor );

    static IPluginUnknown* get_bounding_rectangles_from_range_impl(
        IPluginUnknown      *thiz,
        const PluginRange   *range);

    static PluginStatus get_rendered_range_impl(
        IPluginUnknown *thiz,
        PluginRange    *range);

    // IPluginZoom
    // IPluginRotation

private:
    PluginViewImpl *view_impl;
    typedef PluginRenderResultImpl * RenderResultPtr;
    static utils::ObjectTable<PluginRenderResultImpl> g_instances_table;

    PluginBitmapAttributes atts;    ///< Reference to the image.
    unsigned long ref_id;           ///< The reference id.
    Range page_range;               ///< [start_anchor, end_anchor] of the render result.
    PluginRenderSettingsImpl *settings;
};

};  // namespace text

#endif

