/*
 * File Name: search_criteria_impl.h
 */

/*
 * This file is part of uds-plugin-images.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef IMAGES_PLUGIN_SEARCH_CRITERIA_H_
#define IMAGES_PLUGIN_SEARCH_CRITERIA_H_

#include "plugin_inc.h"

namespace images
{

// The images image plugin does not support search criteria.
// It's placeholder for the other plugins.
class PluginSearchCriteria : public IPluginUnknown
                           , public IPluginSearchCriteria
{
public:
    PluginSearchCriteria(void);
    ~PluginSearchCriteria(void);

private:
    /// IPluginUnknown
    static PluginStatus query_interface_impl(
        IPluginUnknown    *thiz,
        const UDSString   *id, 
        void              **ptr );

    static int release_impl(
        IPluginUnknown  *thiz );

    /// IPluginSearchCriteria
    static PluginStatus set_search_text_impl(
        IPluginUnknown    *thiz, 
        const UDSString   *text ); 

    static PluginStatus set_case_sensitive_impl(
        IPluginUnknown   *thiz, 
        const PluginBool is_sensitive );

    static PluginStatus set_match_whole_word_impl(
        IPluginUnknown   *thiz, 
        const PluginBool do_match_word );

    static PluginStatus set_forward_impl(
        IPluginUnknown    *thiz, 
        const PluginBool  do_search_forward );


private:

};

};  // namespace images

#endif


