/*
 * File Name: search_criteria_impl.cpp
 */

/*
 * This file is part of uds-plugin-images.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "search_criteria_impl.h"

namespace images
{

PluginSearchCriteria::PluginSearchCriteria(void)
{
    // IPluginUnkown
    query_interface = query_interface_impl;
    release         = release_impl;

    // IPluginSearchCriteria
    set_search_text      = set_search_text_impl;
    set_case_sensitive   = set_case_sensitive_impl;
    set_match_whole_word = set_match_whole_word_impl;
    set_forward          = set_forward_impl;
}

PluginSearchCriteria::~PluginSearchCriteria(void)
{
}

PluginStatus 
PluginSearchCriteria::query_interface_impl(IPluginUnknown    *thiz,
                                           const UDSString   *id, 
                                           void              **ptr )
{
    return PLUGIN_FAIL;
}

int PluginSearchCriteria::release_impl(IPluginUnknown  *thiz )
{
    return 0;
}

/// IPluginSearchCriteria
PluginStatus 
PluginSearchCriteria::set_search_text_impl(IPluginUnknown    *thiz, 
                                           const UDSString   *text )
{
    return PLUGIN_FAIL;
}

PluginStatus 
PluginSearchCriteria::set_case_sensitive_impl(IPluginUnknown   *thiz, 
                                              const PluginBool is_sensitive )
{
    return PLUGIN_FAIL;
}

PluginStatus 
PluginSearchCriteria::set_match_whole_word_impl(IPluginUnknown   *thiz, 
                                                const PluginBool do_match_word )
{
    return PLUGIN_FAIL;
}

PluginStatus 
PluginSearchCriteria::set_forward_impl(IPluginUnknown    *thiz, 
                                       const PluginBool  do_search_forward )
{
    return PLUGIN_FAIL;
}

}   // namespace images

