/*
 * File Name: image_dither_unittest.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef _TEST_IMAGE_DITHER_H_
#define _TEST_IMAGE_DITHER_H_

#include "image_dither.h"

namespace comics
{
  class TestImageDither
  {
      public:
          TestImageDither (void);
          ~TestImageDither (void);
      
      public:
          void set_image(const std::string & filepath);

          /**
           * @brief (1)Calling ImageDither to dither to  8bits.
           *        (2)Convert 8bits to 24bits for saving.
           *        (3)Save the image data in 24bits to file to verify.
           */
          void test (void);
          
      private:
          /**
           * @brief Convert the image data in 8bits 
           *        to the image data in 24bits.
           * @param 
           * @return
           */
          void convert_8bits_to_24bits (const BitmapAttributes * attrs_src,
                                        BitmapAttributes * attrs_dst);

          unsigned char *_convert_8bits_to_24bits(const unsigned char *data,
                                                  int w, int h);

          /**
           * @brief Save the image data in 24bits into a file 
           * @param 
           * @return
           */
          void save_24bits_to_file (const BitmapAttributes * attrs);
          
      private:
          std::string img_path;
  };

}

#endif// _TEST_IMAGE_DITHER_H_

