/*
 * File Name: render_result_impl.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef IMAGES_PLUGIN_RENDER_RESULT_H_
#define IMAGES_PLUGIN_RENDER_RESULT_H_

#include "plugin_inc.h"
#include "signal_slot.h"
#include "interfaces_utils.h"
#include "images_renderer.h"

using namespace utils;

namespace comics
{

class PluginRenderSettingsImpl;

class PluginRenderResultImpl : public IPluginUnknown
                             , public IPluginRenderResult
                             , public IPluginRenderSettings
                             , public IPluginZoom
                             , public IPluginRotation
{
public:
    PluginRenderResultImpl(void);
    ~PluginRenderResultImpl(void);

public:
    void set_page(ImagePage * p);

public:
    Signal<PluginRenderResultImpl *> release_signal;

private:
    // IPluginUnknown
    static PluginStatus query_interface_impl(
        IPluginUnknown    *thiz,
        const UDSString   *id, 
        void              **ptr );

    static int release_impl(
        IPluginUnknown  *thiz );

    // IPluginRenderResult 
    static PluginStatus get_bitmap_attributes_impl(
        IPluginUnknown         *thiz, 
        PluginBitmapAttributes *attributes);

    static PluginStatus get_anchor_from_coordinates_impl(
        IPluginUnknown *thiz,
        const int      x,
        const int      y,
        UDSString      *anchor );

    static IPluginUnknown* get_bounding_rectangles_from_range_impl(
        IPluginUnknown      *thiz,
        const PluginRange   *range);

    static PluginStatus get_rendered_range_impl(
        IPluginUnknown *thiz,
        PluginRange    *range);

    // IPluginZoom
    static PluginStatus set_zoom_factor_impl(
        IPluginUnknown* thiz,
        const float zoom_factor );

    static float get_zoom_factor_impl(
        IPluginUnknown* thiz );

    static float get_max_zoom_factor_impl(
        IPluginUnknown* thiz );

    static float get_min_zoom_factor_impl(
        IPluginUnknown* thiz );

    // IPluginRotation
    static PluginStatus set_rotation_impl(
        IPluginUnknown               *thiz,
        const PluginRotationDegree   rotation );
    
    static PluginRotationDegree get_rotation_impl(
        IPluginUnknown  *thiz );

private:
    typedef PluginRenderResultImpl * RenderResultPtr;
    static utils::ObjectTable<PluginRenderResultImpl> g_instances_table;

    ImagePage *page;     // Render result. 
};

};  // namespace comics

#endif

