/*
 * File Name: marker_entry_impl.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-pdf is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-pdf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef IMAGES_MARKER_ENTRY_IMPL_H_
#define IMAGES_MARKER_ENTRY_IMPL_H_

#include "plugin_inc.h"
#include "collection_impl.h"
#include "string_impl.h"
#include "log.h"

namespace comics
{

// Function to allocate a MarkerEntry structure.
MarkerEntry* marker_entry_new(unsigned int uds_private_size);

// Release the whole marker tree pointed by self.
void marker_entry_free_recursive(MarkerEntry* self);

template <>
class DataContainer<MarkerEntry *> : public DataContainerBase
{
public:
    DataContainer(){}
    ~DataContainer()
    {
        for (unsigned int i=0; i<data.size(); i++)
        {
            marker_entry_free_recursive(data[i]);
        }
    }

public:
    virtual bool get_first_element(void **data_ptr)
    {
        *data_ptr = &data[0];
        return true;
    }

    virtual int  get_count()
    {
        return static_cast<int>(data.size());
    }

    std::vector<MarkerEntry *> & ref() 
    {
        return data;
    }

private:
    std::vector<MarkerEntry *> data;
};

};  // namespace pdf

#endif
