/*
 * File Name: render_result_impl.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "render_result_impl.h"
#include "render_settings_impl.h"
#include "view_impl.h"

namespace text
{

utils::ObjectTable<PluginRenderResultImpl> PluginRenderResultImpl::g_instances_table;

PluginRenderResultImpl::PluginRenderResultImpl(PluginViewImpl *view,
                                               const PluginBitmapAttributes& bmp,
                                               const unsigned long id,
                                               PluginRenderSettingsImpl * s)
: view_impl(view)
, atts(bmp)
, ref_id(id)
, settings(s)
{
    // IPluginUnknown
    query_interface = query_interface_impl;
    release = release_impl;

    // IPluginRenderResult
    get_bitmap_attributes = get_bitmap_attributes_impl;
    get_anchor_from_coordinates = get_anchor_from_coordinates_impl;
    get_bounding_rectangles_from_range = get_bounding_rectangles_from_range_impl;
    get_rendered_range = get_rendered_range_impl;

    // IPluginRenderSettings, no method yet.


    // IPluginZoom
    // IPluginRotation

    // Initialize all supported interfaces. In render result, 
    // the render settings, zoom and rotation are read only.
    g_instances_table.add_interface<IPluginUnknown>(this);
    g_instances_table.add_interface<IPluginRenderResult>(this);
    g_instances_table.add_interface<IPluginRenderSettings>(this);
}

PluginRenderResultImpl::~PluginRenderResultImpl(void)
{
    delete [] atts.data;
    g_instances_table.remove(this);
}


PluginStatus
PluginRenderResultImpl::query_interface_impl(IPluginUnknown    *thiz,
                                             const UDSString   *id, 
                                             void              **ptr )
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    if (g_instances_table.query_interface(instance, id->get_buffer(id), ptr))
    {
        return PLUGIN_OK;
    }
    return PLUGIN_FAIL;
}

int 
PluginRenderResultImpl::release_impl(IPluginUnknown  *thiz )
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    instance->release_signal.safe_broadcast(instance);
    return 0;
}

PluginStatus 
PluginRenderResultImpl::get_bitmap_attributes_impl(IPluginUnknown         *thiz, 
                                                   PluginBitmapAttributes *attributes)
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    *attributes = instance->atts;
    return PLUGIN_OK;
}

PluginStatus 
PluginRenderResultImpl::get_anchor_from_coordinates_impl(IPluginUnknown *thiz,
                                                         const int      x,
                                                         const int      y,
                                                         UDSString      *anchor )
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    return instance->view_impl->get_anchor_from_coordinates_impl(instance->page_range.start, x, y, anchor);
}

IPluginUnknown* 
PluginRenderResultImpl::get_bounding_rectangles_from_range_impl(IPluginUnknown      *thiz,
                                                                const PluginRange   *range)
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    return instance->view_impl->get_bounding_rectangles_from_range_impl(instance->page_range.start, range);
}

PluginStatus 
PluginRenderResultImpl::get_rendered_range_impl(IPluginUnknown  *thiz,
                                                PluginRange     *range)
{
    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);

    range->start_anchor->assign(range->start_anchor, instance->page_range.start.to_string().c_str());
    range->end_anchor->assign(range->end_anchor, instance->page_range.end.to_string().c_str());
    return PLUGIN_OK;
}

}
