/*
 * File Name: render_settings_impl.cpp
 */

/*
 * This file is part of uds-plugin-images.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "render_settings_impl.h"
#include "image_page.h"

namespace images
{

utils::ObjectTable<PluginRenderSettingsImpl> PluginRenderSettingsImpl::g_instances_table;

PluginRenderSettingsImpl::PluginRenderSettingsImpl(void)
: zoom_(DEFAULT_ZOOM_FACTOR)
, rotation_(DEFAULT_ROTATION)
{
    // IPluginUnknown
    query_interface = query_interface_impl;
    release         = release_impl;

    // IPluginClone
    create_clone_object = create_clone_object_impl;
    
    // IPluginRenderSettings, no method yet.

    // IPluginZoom
    set_zoom_factor     = set_zoom_factor_impl;
    get_zoom_factor     = get_zoom_factor_impl;
    get_max_zoom_factor = get_max_zoom_factor_impl;
    get_min_zoom_factor = get_min_zoom_factor_impl;

    // IPluginRotation
    set_rotation = set_rotation_impl;
    get_rotation = get_rotation_impl;

    g_instances_table.add_interface<IPluginUnknown>(this);
    g_instances_table.add_interface<IPluginClone>(this);
    g_instances_table.add_interface<IPluginRenderSettings>(this);
    g_instances_table.add_interface<IPluginZoom>(this);
    g_instances_table.add_interface<IPluginRotation>(this);
}

PluginRenderSettingsImpl::PluginRenderSettingsImpl(const PluginRenderSettingsImpl &ref)
: zoom_(ref.zoom_)
, rotation_(ref.rotation_)
{
    // IPluginUnknown
    query_interface = query_interface_impl;
    release         = release_impl;

    // IPluginClone
    create_clone_object = create_clone_object_impl;
    
    // IPluginRenderSettings, no method yet.

    // IPluginZoom
    set_zoom_factor     = set_zoom_factor_impl;
    get_zoom_factor     = get_zoom_factor_impl;
    get_max_zoom_factor = get_max_zoom_factor_impl;
    get_min_zoom_factor = get_min_zoom_factor_impl;

    // IPluginRotation
    set_rotation = set_rotation_impl;
    get_rotation = get_rotation_impl;

    g_instances_table.add_interface<IPluginUnknown>(this);
    g_instances_table.add_interface<IPluginClone>(this);
    g_instances_table.add_interface<IPluginRenderSettings>(this);
    g_instances_table.add_interface<IPluginZoom>(this);
    g_instances_table.add_interface<IPluginRotation>(this);
}

PluginRenderSettingsImpl::~PluginRenderSettingsImpl(void)
{
    g_instances_table.remove(this);
}

PluginRenderSettingsImpl * 
PluginRenderSettingsImpl::query_instance(IPluginUnknown * thiz)
{
    return g_instances_table.get_object(thiz);
}

PluginStatus 
PluginRenderSettingsImpl::query_interface_impl(IPluginUnknown    *thiz,
                                               const UDSString   *id, 
                                               void              **ptr)
{
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    if (g_instances_table.query_interface(instance, id->get_buffer(id), ptr))
    {
        return PLUGIN_OK;
    }
    return PLUGIN_FAIL;
}

int 
PluginRenderSettingsImpl::release_impl(IPluginUnknown  *thiz)
{
    // Have to handle the object cloned and object created by view.
    // For cloned object, its life cycle is not limited.
    // For object created by view, view keeps a reference to it, so
    // it should notify view when it's to be released.
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    if (instance->release_signal.count())
    {
        instance->release_signal.safe_broadcast(instance);
    }
    else
    {
        delete instance;
    }
    return 0;
}

IPluginUnknown* 
PluginRenderSettingsImpl::create_clone_object_impl(IPluginUnknown *thiz)
{
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    PluginRenderSettingsImpl * another_instance 
        = new PluginRenderSettingsImpl(*instance);

    // DON'T need to connect the release signal.
    return static_cast<IPluginUnknown *>(another_instance);
}

PluginStatus 
PluginRenderSettingsImpl::set_zoom_factor_impl(IPluginUnknown *thiz,
                                               const float zoom_factor)
{
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);

    // Should check the zoom factor boundary. TODO
    instance->zoom_ = zoom_factor;
    return PLUGIN_OK;
}

float 
PluginRenderSettingsImpl::get_zoom_factor_impl(IPluginUnknown *thiz)
{
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    return instance->zoom_;
}
    
float 
PluginRenderSettingsImpl::get_max_zoom_factor_impl(IPluginUnknown *thiz)
{
    // PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    return images::ImagePage::max_zoom_factor();
}

float 
PluginRenderSettingsImpl::get_min_zoom_factor_impl(IPluginUnknown *thiz)
{
    // PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    return images::ImagePage::min_zoom_factor();
}

PluginStatus 
PluginRenderSettingsImpl::set_rotation_impl(IPluginUnknown  *thiz,
                                            const PluginRotationDegree rotation)
{
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    instance->rotation_ = rotation;
    return PLUGIN_OK;
}
    
PluginRotationDegree 
PluginRenderSettingsImpl::get_rotation_impl(IPluginUnknown  *thiz)
{    
    PluginRenderSettingsImpl * instance = g_instances_table.get_object(thiz);
    return instance->rotation_;
}

}   // namespace images

