/*
 * File Name: image_dither.h
 */

/*
 * This file is part of uds-plugin-images.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef _IMAGE_DITHER_H_
#define _IMAGE_DITHER_H_

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>

#define WHITE_BACKGROUND 255

namespace images
{
    typedef struct 
    {
        int width;
        int height;
        int rowstride;
        int bytes_per_pixel;
        unsigned char * data;
    }BitmapAttributes;

    /**
     * @brief ImageDither 
     */
    class ImageDither
    {
        public:
            ImageDither(void);
            ~ImageDither(void);

        public:
            /**
             * @brief Convert and dither 32bits or 24bits true color image 
             *        into 256 grayscale image.
             * @param attrs_src in 32bits or 24bits
             * @param attrs_dst return in 256 grayscale
             */
            void dither_to_8bits(const BitmapAttributes *attrs_src,
                                  BitmapAttributes *attrs_dst);

        private:
           /**
             * @brief Convert and dither image data in 32bits or 24bits
             *        into the one in 8bits. 
             * @param data the image data
             * @param w    the width of image
             * @param h    the height of image
             * @return     the image data in 8bits
             */
            unsigned char*dither_32bits_to_8bits(const unsigned char *data, 
                                             int w, int h, int rowstride);

            unsigned char*dither_24bits_to_8bits(const unsigned char *data, 
                                             int w, int h, int rowstride);

        public:
            /**
             * @brief Get the rowstride. 
             * @param width  width of image
             * @return       rowstride
             */
            static int get_rowstride(int width, 
                                     int bytes_per_pixel, 
                                     int alignment);
   };

} // namespace image

#endif // _IMAGE_DITHER_H_


