/*
 * File Name: images_scanner_unittest.cpp
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <iostream>
#include <glib.h>
#include <glib-object.h>
#include "images_scanner.h"
#include "log.h"

using namespace comics;

void test_ImagesScanner(void)
{
    LOGPRINTF("BEGIN-->test_ImagesScanner");

    g_type_init();

    const char * path_list[] = {
    "/data/wa/uds/yehong/sample/rome.jpg",
//    "/data/wa/uds/yehong/example1",
//    "/data/wa/uds/yehong/example1/",
//    "rome.jpg",
//    "*.jpg",
//    "/data/wa/uds/yehong/sample/",
//    "/data/wa/uds/yehong/sample/a.b.c",
//    "/data/wa/uds/yehong/sample",
//    "*.*",
//    ".",
//    "./sample/c.b.a",
//    "/data/wa/uds/trunk/sample/Pisa1.JPG",
//    "/usr/share"
    };
   
    ImagesScanner scanner;
    Images images;
    
    int n_cases = sizeof(path_list) / sizeof(path_list[0]);
    for (int j = 0; j < n_cases; j++)
    {
        // Clear the last scan results.
        ImagesIter begin = images.begin();
        ImagesIter end   = images.end();
        for(ImagesIter iter = begin; iter != end; ++iter)
        {
            delete *iter;
        }
        images.clear();

        /*
        int n_active = scanner.scan_images(path_list[j],
                                           true,
                                           true, 
                                           BY_SIZE,
                                           false,
                                           images);
        LOGPRINTF("%d", n_active);
        */
        
        int n_images = images.size();
        LOGPRINTF("%d", n_images);

        for (int i = 0; i < n_images; i++)
        {
            LOGPRINTF("%s", images[i]->path.c_str());
        }
    }

    LOGPRINTF("END-->test_ImagesScanner");
}

int main()
{
    test_ImagesScanner();
    return 0;
}


