/*
 * File Name: images_renderer.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef _IMAGES_RENDERER_H_
#define _IMAGES_RENDERER_H_

#include <string>

#include "images_pages_cache.h"
#include "thread.h"
#include "signal_slot.h"

#include "images_document.h"
#include "image_page.h"


namespace comics
{

    typedef enum
    {
        IMG_RENDER_OK = 0,
        IMG_RENDER_FAIL,
        IMG_RENDER_INVALID,
        IMG_RENDER_OOM
    }ImageRenderStatus;

    class ImagesRenderer
    {
        public:
            ImagesRenderer(ImagesDocument * document);
            ~ImagesRenderer(void);

        public:
            ImageRenderStatus render(const std::string & anchor, 
                                     const ImagePageAttrs & attrs,
                                     int ref_id,
                                     void * user_data);

            void notify_page_ready(ImagePage * page, 
                                   int ref_id, 
                                   ImageRenderStatus status,
                                   void * user_data);

            ImagePage * get_page(const std::string & anchor, 
                                 const ImagePageAttrs & attrs);
                                        
            void add_page(ImagePage * page);

            ImageRenderStatus can_render(const std::string & anchor, 
                                         const ImagePageAttrs & attrs);        
            
            bool set_memory_limit(const int bytes);
             
            void stop(void);
            
        private:
            void pre_render(int page_num, 
                            const ImagePageAttrs & attrs, 
                            bool page_down);

            void render_prev_pages(int page_num, 
                                   const ImagePageAttrs & attrs);

            void render_next_pages(int page_num, 
                                   const ImagePageAttrs & attrs);

            void set_prerender_policy(int prev_range, int next_range);
 
        public:
            utils::Signal <ImagePage *, const unsigned int, ImageRenderStatus, void *> sig_page_ready;

        private:
            ImagesDocument * doc;
            common::Thread render_thread;  
            PagesCache pages_cache;

            int last_render_page;
            int prev_range_pages;
            int next_range_pages;
    };
};

#endif //_IMAGES_RENDERER_H_
 

