/*
 * File Name: images_document.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef IMAGES_DOCUMENT_H_
#define IMAGES_DOCUMENT_H_

#include <map>
#include <vector>
#include <string>
#include "images_scanner.h"

namespace comics
{

/// Handle images file format
class ImagesDocument
{
public:
	ImagesScanner scanner;
	
    ImagesDocument(void);
    ~ImagesDocument(void);

    /// Open .images index file.
    bool open_document(const std::string &path, std::map<std::string, std::string> &metadata);

    /// Check if the document has been opened.
    bool is_open();

    /// How many "page" does it contain.
    unsigned int page_count();

    /// Get the initial page number
    int get_initial_page_num();

    /// Retrieve specified page.
    const ImagePtr get_page(const unsigned int page_number);

    /// Retrieve page from anchor.
    int get_page(const std::string & anchor);

    bool get_page_name(const std::string & anchor,
                       std::string & name);

    /// Close and release all allocated resource.
    bool close_document();

    /// Anchor policy: Use path name of image as the anchor.
    /// Get anchor for specified page.
    bool get_anchor_of_page(const unsigned int page_number, 
                            std::string & anchor);

    /// Check the document contains the anchor or not.
    bool has_anchor(const std::string & anchor);

    /// Find position from the anchor.
    int get_position(const std::string & anchor);

    /// Compare the anchor object.
    int compare_anchor(const std::string & first,
                       const std::string & second);

    /// Anchor iteraotr: retrieve the previous anchor.
    bool get_prev_page(std::string & anchor);

    /// Anchor iteraotr: retrieve the next anchor.
    bool get_next_page(std::string & anchor);

    bool get_original_size(const std::string &anchor, 
                           unsigned int & width,
                           unsigned int & height);

    bool get_original_rotation(const std::string & anchor,
                               PluginRotationDegree & rotation);

private:
    int initial_page_num;
};

};  // namespace comics

#endif

