/*
 * Decompiled with CFR 0.152.
 */
import common.utils.ExtFilter;
import common.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipOutputStream;

public class FixArchives {
    private static void outputUsage() {
        System.out.println("\nFixArchives");
        System.out.println("Author: Andrew Mantel");
        System.out.println("Purpose: Fix archive filenames that contain filesystem separator character (\\ or /) at the beginning ofthe filename.");
        System.out.println("Usage: java -jar FixArchives.jar [folder path]");
        System.out.println("Example: java -jar FixArchives.jar C:\\\\Manga\\\\SchoolRumble\\\\");
        System.out.println("Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        File cur_folder;
        String folder_path;
        File folder_file;
        if (args.length != 1) {
            FixArchives.outputUsage();
        }
        if (!(folder_file = new File(folder_path = args[0])).exists()) {
            System.out.println("ERROR: Couldn't find folder: " + folder_file.getAbsolutePath());
            FixArchives.outputUsage();
        }
        ArrayList<File> zipList = FileUtils.getZipFileList(folder_file);
        ArrayList<File> zipExtractedFolderList = new ArrayList<File>();
        Collections.sort(zipList);
        if (zipList.isEmpty()) {
            System.out.println("ERROR: Couldn't find any .zip/.cbz archive in " + folder_file.getAbsolutePath());
            System.exit(1);
        } else {
            System.out.println("Beginning FixArchive process. This may take a few minutes, depending on how many archives need to be fixed.");
            System.out.println("DO NOT stop this program once it has started rearchiving or you may lose some data.");
        }
        if (zipList.size() > 0) {
            System.out.println("Found " + zipList.size() + " zip archives, extracting to temporary folders...");
        }
        int one_tenth_size = zipList.size() / 10;
        int num_printed_progress = 0;
        System.out.print("  Progress (every . is 10% done): [");
        int i = 0;
        while (i < zipList.size()) {
            File cur_zip_file = zipList.get(i);
            String cur_zip_filename_noext = ExtFilter.getNameWithoutExtension(cur_zip_file);
            File cur_tmp_folder = new File(String.valueOf(folder_file.getAbsolutePath()) + File.separatorChar + cur_zip_filename_noext);
            FileUtils.unzipFile(cur_zip_file, cur_tmp_folder);
            zipExtractedFolderList.add(cur_tmp_folder);
            if (i != 0 && i % one_tenth_size == 0) {
                System.out.print(".");
                ++num_printed_progress;
            }
            ++i;
        }
        if (num_printed_progress < 10) {
            System.out.print(".");
        }
        System.out.println("]");
        System.out.println("Fixing filenames in temporary folders...");
        i = 0;
        while (i < zipExtractedFolderList.size()) {
            cur_folder = (File)zipExtractedFolderList.get(i);
            ArrayList<File> fileList = FileUtils.getFileListRecursive(cur_folder);
            int j = 0;
            while (j < fileList.size()) {
                File cur_file = fileList.get(j);
                String cur_file_name = cur_file.getName();
                if (cur_file_name.charAt(0) == '\\' || cur_file_name.charAt(0) == '/') {
                    String new_name = cur_file_name.substring(1);
                    File new_file = new File(String.valueOf(cur_file.getParent()) + File.separatorChar + new_name);
                    cur_file.renameTo(new_file);
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Rearchiving... (DO NOT stop this program or you may lose some data)");
        one_tenth_size = zipExtractedFolderList.size() / 10;
        num_printed_progress = 0;
        System.out.print("  Progress (every . is 10% done): [");
        i = 0;
        while (i < zipExtractedFolderList.size()) {
            cur_folder = (File)zipExtractedFolderList.get(i);
            File new_zip_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".zip");
            File new_cbz_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".cbz");
            String archive_extension = null;
            if (new_zip_file.exists()) {
                archive_extension = ".zip";
                new_zip_file.delete();
            } else {
                archive_extension = ".cbz";
                new_cbz_file.delete();
            }
            File new_archive_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + archive_extension);
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new_archive_file));
            FileUtils.zipFolderRecursive(cur_folder.getAbsolutePath(), cur_folder.getAbsolutePath(), zos);
            zos.close();
            FileUtils.deleteDirectory(cur_folder);
            if (i != 0 && i % one_tenth_size == 0) {
                System.out.print(".");
                ++num_printed_progress;
            }
            ++i;
        }
        if (num_printed_progress < 10) {
            System.out.print(".");
        }
        System.out.println("]");
        System.out.println("\nFinished.");
    }
}

