import com.jinke.gui.Window;
import com.jinke.gui.Graphics;
import com.jinke.gui.Color;
import com.jinke.gui.Font;
import com.jinke.gui.event.KeyListener;
import com.jinke.gui.event.KeyEvent;


// Very basic example of Jinke's Hanlin v3+ 'JINKlet',
// draws rect, text and exits when [Back] holden.

public class Basics extends Window
	implements KeyListener {

	// Entry point, not MIDlet
	public static void main(String args[]) { 
		new Basics();
	}

	public Basics() {
		super(0, 0, 600, 800);
		addKeyListener(this);
		setVisible(true);

		Color c = new Color();
		c.setColor(0x121212);
		gc.setForeColor(c);
		gc.fillRect(10, 10, 50, 50);
		
		// font family name works too, but with size problems
		Font f = new Font("/root/fonts/truetype/lBOOKN.ttf", 24, Font.NONE);	
		c.setColor(0x404040);
		gc.setForeColor(c);
		gc.setFont(f);
		gc.drawString("Hello Hanlin V3+ from java!", 70, 35);
		
		// Request nano-X to repaint the *whole* window(see also: blockFlush, fastBlockFlush)
		flush(); 
		beginUIThread(); // Start event queque
	}
	
	
	public void keyPressed(KeyEvent ke) {
		if (ke.getCh() == 'h') { // Long hold [BACK] button
			finalize(); // Release window resources
			System.gc(); // Garbage collector
			System.exit(0);
		}
	}
	
	
	// keyReleased is called only for holden 'long keys'
    public void keyReleased(KeyEvent ke){
	}	

}













